/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo.healthcheck.impl;

import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Http
extends AbstractHealthChecker {
    public static final String TYPE = "HTTP";
    private static final long serialVersionUID = 551826315222362349L;
    private String path = "";
    private String headers = "";
    private int expectedResponseCode = 200;

    public Http() {
        super(TYPE);
    }

    public int getExpectedResponseCode() {
        return this.expectedResponseCode;
    }

    public void setExpectedResponseCode(int expectedResponseCode) {
        this.expectedResponseCode = expectedResponseCode;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    @JsonIgnore
    public Map<String, String> getCustomHeaders() {
        if (StringUtils.isBlank(this.headers)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headerMap = new HashMap<String, String>(16);
        for (String s2 : this.headers.split("\\|")) {
            String[] splits = s2.split(":");
            if (splits.length != 2) continue;
            headerMap.put(StringUtils.trim(splits[0]), StringUtils.trim(splits[1]));
        }
        return headerMap;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.headers, this.expectedResponseCode);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Http)) {
            return false;
        }
        Http other = (Http)obj;
        if (!StringUtils.equals(this.type, other.getType())) {
            return false;
        }
        if (!StringUtils.equals(this.path, other.getPath())) {
            return false;
        }
        if (!StringUtils.equals(this.headers, other.getHeaders())) {
            return false;
        }
        return this.expectedResponseCode == other.getExpectedResponseCode();
    }

    @Override
    public Http clone() throws CloneNotSupportedException {
        Http config = new Http();
        config.setPath(this.getPath());
        config.setHeaders(this.getHeaders());
        config.setExpectedResponseCode(this.getExpectedResponseCode());
        return config;
    }
}

