/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.core.ServerListManager;
import com.alibaba.nacos.client.naming.core.ServiceInfoUpdateService;
import com.alibaba.nacos.client.naming.event.InstancesChangeNotifier;
import com.alibaba.nacos.client.naming.remote.NamingClientProxy;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientManager;
import com.alibaba.nacos.client.naming.remote.http.NamingHttpClientProxy;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NamingClientProxyDelegate
implements NamingClientProxy {
    private final long securityInfoRefreshIntervalMills = TimeUnit.SECONDS.toMillis(5L);
    private final ServerListManager serverListManager;
    private final ServiceInfoUpdateService serviceInfoUpdateService;
    private final ServiceInfoHolder serviceInfoHolder;
    private final NamingHttpClientProxy httpClientProxy;
    private final NamingGrpcClientProxy grpcClientProxy;
    private final SecurityProxy securityProxy;
    private ScheduledExecutorService executorService;

    public NamingClientProxyDelegate(String namespace, ServiceInfoHolder serviceInfoHolder, Properties properties, InstancesChangeNotifier changeNotifier) throws NacosException {
        this.serviceInfoUpdateService = new ServiceInfoUpdateService(properties, serviceInfoHolder, this, changeNotifier);
        this.serverListManager = new ServerListManager(properties, namespace);
        this.serviceInfoHolder = serviceInfoHolder;
        this.securityProxy = new SecurityProxy(properties, NamingHttpClientManager.getInstance().getNacosRestTemplate());
        this.initSecurityProxy();
        this.httpClientProxy = new NamingHttpClientProxy(namespace, this.securityProxy, this.serverListManager, properties, serviceInfoHolder);
        this.grpcClientProxy = new NamingGrpcClientProxy(namespace, this.securityProxy, this.serverListManager, properties, serviceInfoHolder);
    }

    private void initSecurityProxy() {
        this.executorService = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName("com.alibaba.nacos.client.naming.security");
            t.setDaemon(true);
            return t;
        });
        this.securityProxy.login(this.serverListManager.getServerList());
        this.executorService.scheduleWithFixedDelay(() -> this.securityProxy.login(this.serverListManager.getServerList()), 0L, this.securityInfoRefreshIntervalMills, TimeUnit.MILLISECONDS);
    }

    @Override
    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        this.getExecuteClientProxy(instance).registerService(serviceName, groupName, instance);
    }

    @Override
    public void deregisterService(String serviceName, String groupName, Instance instance) throws NacosException {
        this.getExecuteClientProxy(instance).deregisterService(serviceName, groupName, instance);
    }

    @Override
    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
    }

    @Override
    public ServiceInfo queryInstancesOfService(String serviceName, String groupName, String clusters, int udpPort, boolean healthyOnly) throws NacosException {
        return this.grpcClientProxy.queryInstancesOfService(serviceName, groupName, clusters, udpPort, healthyOnly);
    }

    @Override
    public Service queryService(String serviceName, String groupName) throws NacosException {
        return null;
    }

    @Override
    public void createService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        return false;
    }

    @Override
    public void updateService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        return this.grpcClientProxy.getServiceList(pageNo, pageSize, groupName, selector);
    }

    @Override
    public ServiceInfo subscribe(String serviceName, String groupName, String clusters) throws NacosException {
        String serviceNameWithGroup = NamingUtils.getGroupedName(serviceName, groupName);
        String serviceKey = ServiceInfo.getKey(serviceNameWithGroup, clusters);
        this.serviceInfoUpdateService.scheduleUpdateIfAbsent(serviceName, groupName, clusters);
        ServiceInfo result = this.serviceInfoHolder.getServiceInfoMap().get(serviceKey);
        if (null == result) {
            result = this.grpcClientProxy.subscribe(serviceName, groupName, clusters);
        }
        this.serviceInfoHolder.processServiceInfo(result);
        return result;
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, String clusters) throws NacosException {
        this.serviceInfoUpdateService.stopUpdateIfContain(serviceName, groupName, clusters);
        this.grpcClientProxy.unsubscribe(serviceName, groupName, clusters);
    }

    @Override
    public void updateBeatInfo(Set<Instance> modifiedInstances) {
        this.httpClientProxy.updateBeatInfo(modifiedInstances);
    }

    @Override
    public boolean serverHealthy() {
        return this.grpcClientProxy.serverHealthy() || this.httpClientProxy.serverHealthy();
    }

    private NamingClientProxy getExecuteClientProxy(Instance instance) {
        return instance.isEphemeral() ? this.grpcClientProxy : this.httpClientProxy;
    }

    @Override
    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        this.serviceInfoUpdateService.shutdown();
        this.serverListManager.shutdown();
        this.httpClientProxy.shutdown();
        this.grpcClientProxy.shutdown();
        ThreadUtils.shutdownThreadPool(this.executorService, LogUtils.NAMING_LOGGER);
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }
}

