/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.shaded.com.google.common.cache.Cache;
import com.alibaba.nacos.shaded.com.google.common.cache.CacheBuilder;
import com.alibaba.nacos.shaded.com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class Limiter {
    private static final Logger LOGGER = LogUtils.logger(Limiter.class);
    private static final int CAPACITY_SIZE = 1000;
    private static final int LIMIT_TIME = 1000;
    private static final Cache<String, RateLimiter> CACHE = CacheBuilder.newBuilder().initialCapacity(1000).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final String LIMIT_TIME_PROPERTY = "limitTime";
    private static double limit = 5.0;

    public static boolean isLimit(String accessKeyID) {
        RateLimiter rateLimiter = null;
        try {
            rateLimiter = CACHE.get(accessKeyID, new Callable<RateLimiter>(){

                @Override
                public RateLimiter call() throws Exception {
                    return RateLimiter.create(limit);
                }
            });
        }
        catch (ExecutionException e) {
            LOGGER.error("create limit fail", (Throwable)e);
        }
        if (rateLimiter != null && !rateLimiter.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
            LOGGER.error("access_key_id:{} limited", (Object)accessKeyID);
            return true;
        }
        return false;
    }

    static {
        try {
            String limitTimeStr = System.getProperty(LIMIT_TIME_PROPERTY, String.valueOf(limit));
            limit = Double.parseDouble(limitTimeStr);
            LOGGER.info("limitTime:{}", (Object)limit);
        }
        catch (Exception e) {
            LOGGER.error("init limitTime fail", (Throwable)e);
        }
    }
}

