/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun;

import com.alibaba.nacos.api.config.filter.AbstractConfigFilter;
import com.alibaba.nacos.api.config.filter.IConfigFilterChain;
import com.alibaba.nacos.api.config.filter.IConfigRequest;
import com.alibaba.nacos.api.config.filter.IConfigResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.AesUtils;
import com.alibaba.nacos.client.aliyun.AliyunConst;
import com.alibaba.nacos.client.aliyun.AsyncProcessor;
import com.alibaba.nacos.client.aliyun.GroupKeyUtils;
import com.alibaba.nacos.client.aliyun.KmsLocalCache;
import com.alibaba.nacos.client.aliyun.KmsUtils;
import com.alibaba.nacos.client.aliyun.MD5Utils;
import com.aliyun.dkms.gcs.openapi.models.Config;
import com.aliyun.kms.KmsTransferAcsClient;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.InstanceProfileCredentialsProvider;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.kms.model.v20160120.DecryptRequest;
import com.aliyuncs.kms.model.v20160120.DecryptResponse;
import com.aliyuncs.kms.model.v20160120.DescribeKeyRequest;
import com.aliyuncs.kms.model.v20160120.DescribeKeyResponse;
import com.aliyuncs.kms.model.v20160120.EncryptRequest;
import com.aliyuncs.kms.model.v20160120.EncryptResponse;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyRequest;
import com.aliyuncs.kms.model.v20160120.GenerateDataKeyResponse;
import com.aliyuncs.kms.model.v20160120.SetDeletionProtectionRequest;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunConfigFilter
extends AbstractConfigFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunConfigFilter.class);
    public static final int defaultRetryTimes = 3;
    public static final int defaultRetryIntervalMilliseconds = 200;
    public static final int defaultTimeoutMilliseconds = 3000;
    private AliyunConst.KmsVersion kmsVersion;
    private IAcsClient kmsClient;
    private String keyId;
    private final Set<String> addedKeys = new HashSet<String>();
    private AsyncProcessor asyncProcessor;
    private Exception localInitException;
    private boolean isUseLocalCache;
    private KmsLocalCache kmsLocalCache;
    private boolean localCacheTestMode = false;

    public void init(Properties properties) {
        LOGGER.info("init ConfigFilter: {}, for more information, please check: {}", (Object)this.getFilterName(), (Object)"https://help.aliyun.com/zh/mse/user-guide/create-and-use-encrypted-configurations?spm=a2c4g.11186623.0.0.55587becdOW3jf");
        String kv = properties.getProperty("kmsVersion", System.getProperty("kmsVersion", System.getenv("kmsVersion")));
        if (StringUtils.isBlank((CharSequence)kv)) {
            LOGGER.warn("kms version is not set, using kms v1 version.");
            this.kmsVersion = AliyunConst.KmsVersion.Kmsv1;
        } else {
            this.kmsVersion = AliyunConst.KmsVersion.fromValue(kv);
            if (this.kmsVersion == AliyunConst.KmsVersion.UNKNOWN_VERSION) {
                LOGGER.warn("kms version is not supported, using kms v1 version.");
                this.kmsVersion = AliyunConst.KmsVersion.Kmsv1;
            } else {
                LOGGER.info("using kms version {}.", (Object)this.kmsVersion.getValue());
            }
        }
        if (this.kmsVersion == AliyunConst.KmsVersion.Kmsv1) {
            this.keyId = "alias/acs/mse";
            LOGGER.info("using default keyId {}.", (Object)this.keyId);
        } else if (this.kmsVersion == AliyunConst.KmsVersion.Kmsv3) {
            this.keyId = properties.getProperty("keyId", System.getProperty("keyId", System.getenv("keyId")));
            if (StringUtils.isBlank((CharSequence)this.keyId)) {
                String errorMsg = "keyId is not set up yet, unable to encrypt the configuration.";
                this.localInitException = new RuntimeException(errorMsg);
                LOGGER.error(AliyunConst.formatHelpMessage(errorMsg), (Throwable)this.localInitException);
                return;
            }
            LOGGER.info("using keyId {}.", (Object)this.keyId);
        }
        this.isUseLocalCache = KmsUtils.parsePropertyValue(properties, "nacos.config.encryption.kms.local.cache.switch", true);
        if (this.isUseLocalCache()) {
            this.localCacheTestMode = KmsUtils.parsePropertyValue(properties, "nacos.config.encryption.kms.local.cache.testMode", false);
            LOGGER.info("using kms encryption local cache.");
            this.kmsLocalCache = new KmsLocalCache(properties);
        }
        try {
            if (this.kmsVersion == AliyunConst.KmsVersion.Kmsv1) {
                this.kmsClient = this.createKmsV1Client(properties);
            } else if (this.kmsVersion == AliyunConst.KmsVersion.Kmsv3) {
                this.kmsClient = this.createKmsV3Client(properties);
            }
        }
        catch (ClientException e) {
            LOGGER.error(AliyunConst.formatHelpMessage("kms init failed."), (Throwable)e);
            this.localInitException = e;
        }
        catch (Exception e) {
            LOGGER.error(AliyunConst.formatHelpMessage("create kms client failed."), (Throwable)e);
            this.localInitException = e;
        }
        try {
            this.asyncProcessor = new AsyncProcessor();
        }
        catch (Exception e) {
            LOGGER.error("init async processor failed.", (Throwable)e);
        }
    }

    private IAcsClient createKmsV1Client(Properties properties) {
        String regionId = properties.getProperty("regionId", System.getProperty("regionId", System.getenv("regionId")));
        String kmsRegionId = properties.getProperty("kms_region_id", System.getProperty("kms_region_id", System.getenv("kms_region_id")));
        if (StringUtils.isBlank((CharSequence)regionId)) {
            regionId = kmsRegionId;
        }
        LOGGER.info("using regionId {}.", (Object)regionId);
        if (StringUtils.isBlank((CharSequence)kmsRegionId)) {
            kmsRegionId = regionId;
        }
        LOGGER.info("using kms regionId {}.", (Object)kmsRegionId);
        if (StringUtils.isBlank((CharSequence)kmsRegionId) && StringUtils.isBlank((CharSequence)regionId)) {
            String errorMsg = "region is not set up yet";
            LOGGER.error(AliyunConst.formatHelpMessage(errorMsg));
            this.localInitException = new RuntimeException(errorMsg);
            return null;
        }
        String ramRoleName = properties.getProperty("ramRoleName", System.getProperty("ramRoleName", System.getenv("ramRoleName")));
        LOGGER.info("using ramRoleName {}.", (Object)ramRoleName);
        String accessKey = properties.getProperty("accessKey", System.getProperty("accessKey", System.getenv("accessKey")));
        LOGGER.info("using accessKey {}.", (Object)accessKey);
        String secretKey = properties.getProperty("secretKey", System.getProperty("secretKey", System.getenv("secretKey")));
        DefaultProfile profile = null;
        KmsTransferAcsClient kmsClient = null;
        if (!StringUtils.isBlank((CharSequence)ramRoleName)) {
            profile = DefaultProfile.getProfile((String)regionId);
            InstanceProfileCredentialsProvider alibabaCloudCredentialsProvider = new InstanceProfileCredentialsProvider(ramRoleName);
            kmsClient = new KmsTransferAcsClient((IClientProfile)profile, (AlibabaCloudCredentialsProvider)alibabaCloudCredentialsProvider);
            LOGGER.info("successfully create kms client by using RAM role.");
        } else {
            profile = DefaultProfile.getProfile((String)regionId, (String)accessKey, (String)secretKey);
            kmsClient = new KmsTransferAcsClient((IClientProfile)profile);
            LOGGER.info("successfully create kms client by using ak/sk.");
        }
        return kmsClient;
    }

    private IAcsClient createKmsV3Client(Properties properties) throws ClientException {
        Config config = new Config();
        config.setProtocol("https");
        DefaultProfile profile = null;
        String kmsClientKeyContent = properties.getProperty("kmsClientKeyContent", System.getProperty("kmsClientKeyContent", System.getenv("kmsClientKeyContent")));
        if (!StringUtils.isBlank((CharSequence)kmsClientKeyContent)) {
            LOGGER.info("using {}: {}.", (Object)"kmsClientKeyContent", (Object)kmsClientKeyContent);
            config.setClientKeyContent(kmsClientKeyContent);
        } else {
            String errorMsg = null;
            LOGGER.info("{} is empty, will read from file.", (Object)"kmsClientKeyContent");
            String kmsClientKeyFilePath = properties.getProperty("kmsClientKeyFilePath", System.getProperty("kmsClientKeyFilePath", System.getenv("kmsClientKeyFilePath")));
            if (!StringUtils.isBlank((CharSequence)kmsClientKeyFilePath)) {
                String s = AliyunConfigFilter.readFileToString(kmsClientKeyFilePath);
                if (!StringUtils.isBlank((CharSequence)s)) {
                    LOGGER.info("using kmsClientKeyFilePath: {}.", (Object)kmsClientKeyFilePath);
                    config.setClientKeyFile(kmsClientKeyFilePath);
                } else {
                    errorMsg = "both config from kmsClientKeyContent and kmsClientKeyFilePath is empty";
                }
            } else {
                errorMsg = "kmsClientKeyFilePath is empty";
            }
            if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                this.localInitException = new RuntimeException(errorMsg);
                return null;
            }
        }
        String kmsEndpoint = properties.getProperty("kmsEndpoint", System.getProperty("kmsEndpoint", System.getenv("kmsEndpoint")));
        if (StringUtils.isBlank((CharSequence)kmsEndpoint)) {
            String errorMsg = String.format("%s is empty", "kmsEndpoint");
            this.localInitException = new RuntimeException(errorMsg);
            return null;
        }
        LOGGER.info("using kmsEndpoint: {}.", (Object)kmsEndpoint);
        config.setEndpoint(kmsEndpoint);
        String kmsPassword = properties.getProperty("kmsPasswordKey", System.getProperty("kmsPasswordKey", System.getenv("kmsPasswordKey")));
        if (StringUtils.isBlank((CharSequence)kmsPassword)) {
            String errorMsg = String.format("%s is empty", "kmsPasswordKey");
            this.localInitException = new RuntimeException(errorMsg);
            return null;
        }
        LOGGER.info("using kmsPassword prefix: {}.", (Object)kmsPassword.substring(kmsPassword.length() / 8));
        config.setPassword(kmsPassword);
        String kmsCaFileContent = properties.getProperty("kmsCaFileContent", System.getProperty("kmsCaFileContent", System.getenv("kmsCaFileContent")));
        if (!StringUtils.isBlank((CharSequence)kmsCaFileContent)) {
            LOGGER.info("using {}: {}.", (Object)"kmsCaFileContent", (Object)kmsCaFileContent);
            config.setCa(kmsCaFileContent);
        } else {
            String errorMsg = null;
            LOGGER.info("{} is empty, will read from file.", (Object)"kmsCaFileContent");
            String kmsCaFilePath = properties.getProperty("kmsCaFilePath", System.getProperty("kmsCaFilePath", System.getenv("kmsCaFilePath")));
            if (!StringUtils.isBlank((CharSequence)kmsCaFilePath)) {
                config.setCaFilePath(kmsCaFilePath);
            } else {
                errorMsg = "kmsCaFilePath is empty";
                config.setCaFilePath(null);
            }
            if (!StringUtils.isBlank((CharSequence)errorMsg)) {
                LOGGER.warn(AliyunConst.formatHelpMessage(errorMsg));
                profile = DefaultProfile.getProfile((String)config.getRegionId(), (String)"ak", (String)"sk", (String)"sts");
                HttpClientConfig httpClientConfig = HttpClientConfig.getDefault();
                httpClientConfig.setIgnoreSSLCerts(true);
                profile.setHttpClientConfig(httpClientConfig);
            }
        }
        if (profile == null) {
            return new KmsTransferAcsClient(config);
        }
        return new KmsTransferAcsClient(profile, config);
    }

    public void doFilter(IConfigRequest request, IConfigResponse response, IConfigFilterChain filterChain) throws NacosException {
        String dataId = null;
        String group = null;
        try {
            if (request != null) {
                dataId = (String)request.getParameter("dataId");
                group = (String)request.getParameter("group");
                if (dataId.startsWith("cipher-") && !StringUtils.isBlank((CharSequence)((String)request.getParameter("content")))) {
                    request.putParameter("content", (Object)this.encrypt(this.keyId, request));
                }
                filterChain.doFilter(request, response);
            }
            if (response != null) {
                dataId = (String)response.getParameter("dataId");
                group = (String)response.getParameter("group");
                if (dataId.startsWith("cipher-") && !StringUtils.isBlank((CharSequence)((String)response.getParameter("content")))) {
                    response.putParameter("content", (Object)this.decrypt(response));
                }
            }
        }
        catch (ClientException e) {
            String message = String.format("KMS message:[%s], error message:[%s], dataId: %s, groupId: %s", e.getMessage(), e.getErrMsg(), dataId, group);
            throw new NacosException(-500, AliyunConst.formatHelpMessage(message), (Throwable)e);
        }
        catch (Exception e) {
            throw new NacosException(400, AliyunConst.formatHelpMessage(e.getMessage()), (Throwable)e);
        }
    }

    private String decrypt(IConfigResponse response) throws Exception {
        this.checkIfKmsClientIsReady();
        String dataId = (String)response.getParameter("dataId");
        String group = (String)response.getParameter("group");
        String encryptedContent = (String)response.getParameter("content");
        String encryptedDataKey = (String)response.getParameter("encryptedDataKey");
        String plainDataKey = null;
        String result = null;
        Exception requestKmsException = null;
        String blankResultErrorMsg = "decrypt from kms failed.";
        boolean isUsedCache = true;
        try {
            if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
                this.throwExceptionIfStringBlankWithErrorKey(encryptedDataKey, GroupKeyUtils.getGroupKey2(dataId, group), "decrypt failed", "response.getParameter(ENCRYPTED_DATA_KEY)");
                plainDataKey = this.decrypt(encryptedDataKey);
                result = AesUtils.decrypt(encryptedContent, plainDataKey, AliyunConst.ENCODE_UTF8);
            } else if (dataId.startsWith("cipher-")) {
                result = this.decrypt(encryptedContent);
            }
        }
        catch (BlankStringException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("decrypt config:[{}] failed by using kms service: {}.", new Object[]{GroupKeyUtils.getGroupKey2(dataId, group), e.getMessage(), e});
            requestKmsException = e;
        }
        if (this.localCacheTestMode) {
            requestKmsException = requestKmsException == null ? new RuntimeException("test mode exception to use local cache") : requestKmsException;
            result = null;
        }
        if (requestKmsException != null || StringUtils.isBlank((CharSequence)result)) {
            LOGGER.warn("decrypt config [{}] failed with exception or empty result by using kms service. try to use local cache.", (Object)GroupKeyUtils.getGroupKey2(dataId, group));
            result = this.getDecryptedContentByUsingLocalCache(group, dataId, encryptedDataKey, encryptedContent);
            if (requestKmsException != null && StringUtils.isBlank((CharSequence)result)) {
                throw requestKmsException;
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                blankResultErrorMsg = blankResultErrorMsg + "and no kms decryption local cache.";
            }
        } else {
            isUsedCache = false;
        }
        this.throwExceptionIfStringBlankWithErrorKey(result, GroupKeyUtils.getGroupKey2(dataId, group), "decrypt failed", blankResultErrorMsg);
        if (!isUsedCache) {
            this.updateLocalCacheItem(group, dataId, encryptedDataKey, encryptedContent, plainDataKey, result);
        }
        return result;
    }

    private String encrypt(String keyId, IConfigRequest configRequest) throws Exception {
        this.checkIfKmsClientIsReady();
        this.throwExceptionIfStringBlankWithErrorKey(keyId, "", "keyId is not set.", "keyId");
        this.protectKeyId(keyId);
        String dataId = (String)configRequest.getParameter("dataId");
        String group = (String)configRequest.getParameter("group");
        String plainContent = (String)configRequest.getParameter("content");
        String plainDataKey = null;
        String encryptedDataKey = null;
        String result = null;
        String blankResultErrorMsg = "encrypt from kms failed.";
        try {
            if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
                String keySpec = KmsUtils.getKeySpecByDataIdPrefix(dataId);
                GenerateDataKeyResponse generateDataKeyResponse = this.generateDataKey(keyId, keySpec);
                plainDataKey = generateDataKeyResponse.getPlaintext();
                this.throwExceptionIfStringBlankWithErrorKey(plainDataKey, GroupKeyUtils.getGroupKey2(dataId, group), "generateDataKeyResponse.getPlaintext()", "plainDataKey");
                encryptedDataKey = generateDataKeyResponse.getCiphertextBlob();
                this.throwExceptionIfStringBlankWithErrorKey(encryptedDataKey, GroupKeyUtils.getGroupKey2(dataId, group), "generateDataKeyResponse.getCiphertextBlob()", "encryptedDataKey");
                configRequest.putParameter("encryptedDataKey", (Object)encryptedDataKey);
                result = AesUtils.encrypt(plainContent, plainDataKey, AliyunConst.ENCODE_UTF8);
            } else if (dataId.startsWith("cipher-")) {
                result = this.encrypt(keyId, plainContent);
            }
        }
        catch (Exception e) {
            LOGGER.error("encrypt config:[{}] failed by using kms service: {}.", new Object[]{GroupKeyUtils.getGroupKey2(dataId, group), e.getMessage(), e});
            throw e;
        }
        this.throwExceptionIfStringBlankWithErrorKey(result, GroupKeyUtils.getGroupKey2(dataId, group), "encrypt failed", blankResultErrorMsg);
        this.updateLocalCacheItem(group, dataId, encryptedDataKey, result, plainDataKey, plainContent);
        return result;
    }

    @Deprecated
    private String getEncryptedContentByUsingLocalCache(String group, String dataId, String plainContent, IConfigRequest configRequest) throws Exception {
        KmsLocalCache.LocalCacheItem localCacheItem = this.getLocalCacheItem(group, dataId, plainContent);
        String result = null;
        if (localCacheItem != null) {
            if (!StringUtils.isBlank((CharSequence)localCacheItem.getPlainDataKey())) {
                result = AesUtils.encrypt(plainContent, localCacheItem.getPlainDataKey(), AliyunConst.ENCODE_UTF8);
                configRequest.putParameter("encryptedDataKey", (Object)localCacheItem.getEncryptedDataKey());
            } else if (!StringUtils.isBlank((CharSequence)localCacheItem.getPlainContent())) {
                result = localCacheItem.getEncryptedContent();
            }
        }
        return result;
    }

    private String getDecryptedContentByUsingLocalCache(String group, String dataId, String encryptedDataKey, String encryptedContent) throws Exception {
        KmsLocalCache.LocalCacheItem localCacheItem = this.getLocalCacheItem(group, dataId, encryptedDataKey, encryptedContent);
        if (localCacheItem != null) {
            if (!StringUtils.isBlank((CharSequence)localCacheItem.getPlainDataKey())) {
                return AesUtils.decrypt(encryptedContent, localCacheItem.getPlainDataKey(), AliyunConst.ENCODE_UTF8);
            }
            if (!StringUtils.isBlank((CharSequence)localCacheItem.getPlainContent())) {
                return localCacheItem.getPlainContent();
            }
        }
        return null;
    }

    private void updateLocalCacheItem(String group, String dataId, String encryptedDataKey, String encryptedContent, String plainDataKey, String plainContent) {
        if (!this.isLocalCacheAvailable()) {
            return;
        }
        if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
            this.getKmsLocalCache().put(GroupKeyUtils.getGroupKey2(dataId, group), new KmsLocalCache.LocalCacheItem(encryptedDataKey, encryptedContent, plainDataKey));
        } else if (dataId.startsWith("cipher-")) {
            this.getKmsLocalCache().put(GroupKeyUtils.getGroupKey2(dataId, group), new KmsLocalCache.LocalCacheItem(encryptedContent, plainContent));
        }
    }

    private String decrypt(String content) throws Exception {
        AtomicReference resultContent = new AtomicReference();
        DecryptRequest decReq = new DecryptRequest();
        decReq.setSysProtocol(ProtocolType.HTTPS);
        decReq.setSysMethod(MethodType.POST);
        decReq.setAcceptFormat(FormatType.XML);
        decReq.setCiphertextBlob(content);
        AliyunConfigFilter.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(((DecryptResponse)this.kmsClient.getAcsResponse((AcsRequest)decReq)).getPlaintext());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)resultContent.get()))) {
                return false;
            }
            return true;
        }, 3, 3000L);
        return (String)resultContent.get();
    }

    public String encrypt(String keyId, String plainText) throws Exception {
        AtomicReference resultContent = new AtomicReference();
        EncryptRequest encReq = new EncryptRequest();
        encReq.setProtocol(ProtocolType.HTTPS);
        encReq.setAcceptFormat(FormatType.XML);
        encReq.setMethod(MethodType.POST);
        encReq.setKeyId(keyId);
        encReq.setPlaintext(plainText);
        AliyunConfigFilter.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(((EncryptResponse)this.kmsClient.getAcsResponse((AcsRequest)encReq)).getCiphertextBlob());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)resultContent.get()))) {
                return false;
            }
            return true;
        }, 200, 3000L);
        return (String)resultContent.get();
    }

    public GenerateDataKeyResponse generateDataKey(String keyId, String keySpec) throws Exception {
        GenerateDataKeyRequest generateDataKeyRequest = new GenerateDataKeyRequest();
        generateDataKeyRequest.setAcceptFormat(FormatType.XML);
        generateDataKeyRequest.setKeyId(keyId);
        generateDataKeyRequest.setKeySpec(keySpec);
        AtomicReference resultContent = new AtomicReference();
        AliyunConfigFilter.locallyRunWithRetryTimesAndTimeout(() -> {
            try {
                resultContent.set(this.kmsClient.getAcsResponse((AcsRequest)generateDataKeyRequest));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (resultContent.get() == null) {
                return false;
            }
            return true;
        }, 3, 3000L);
        return (GenerateDataKeyResponse)resultContent.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void protectKeyId(final String keyId) {
        if (!this.addedKeys.contains(keyId)) {
            Set<String> set = this.addedKeys;
            synchronized (set) {
                if (this.addedKeys.contains(keyId)) {
                    return;
                }
                this.addedKeys.add(keyId);
                this.asyncProcessor.addTack(new Runnable(){

                    @Override
                    public void run() {
                        block9: {
                            try {
                                if (AliyunConfigFilter.this.kmsClient == null) {
                                    LOGGER.error("kms client hasn't initiated.");
                                    return;
                                }
                                DescribeKeyRequest describeKeyRequest = new DescribeKeyRequest();
                                describeKeyRequest.setKeyId(keyId);
                                try {
                                    DescribeKeyResponse describeKeyResponse = (DescribeKeyResponse)AliyunConfigFilter.this.kmsClient.getAcsResponse((AcsRequest)describeKeyRequest);
                                    if (describeKeyResponse.getKeyMetadata() != null) {
                                        if (!"Enabled".equals(describeKeyResponse.getKeyMetadata().getKeyState())) {
                                            throw new RuntimeException("Key not available");
                                        }
                                        String arn = describeKeyResponse.getKeyMetadata().getArn();
                                        LOGGER.info("set deletion protection for keyId[{}], arn[{}]", (Object)keyId, (Object)arn);
                                        SetDeletionProtectionRequest setDeletionProtectionRequest = new SetDeletionProtectionRequest();
                                        setDeletionProtectionRequest.setProtectedResourceArn(arn);
                                        setDeletionProtectionRequest.setEnableDeletionProtection(Boolean.valueOf(true));
                                        setDeletionProtectionRequest.setDeletionProtectionDescription("key is used by mse");
                                        try {
                                            AliyunConfigFilter.this.kmsClient.getAcsResponse((AcsRequest)setDeletionProtectionRequest);
                                            break block9;
                                        }
                                        catch (ClientException e) {
                                            LOGGER.error("set deletion protect failed, keyId: {}.", (Object)keyId);
                                            throw e;
                                        }
                                    }
                                    AliyunConfigFilter.this.addedKeys.remove(keyId);
                                    LOGGER.warn("keyId meta is null, cannot set key protection");
                                }
                                catch (ClientException e) {
                                    LOGGER.error("describe key failed, keyId: {}.", (Object)keyId);
                                    throw e;
                                }
                            }
                            catch (Exception e) {
                                AliyunConfigFilter.this.addedKeys.remove(keyId);
                                LOGGER.error("execute async task failed", (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
    }

    private static void locallyRunWithRetryTimesAndTimeout(Supplier<Boolean> runnable, int retryTimes, long timeout) throws Exception {
        int locallyRetryTimes = 0;
        Exception localException = null;
        long beginTime = System.currentTimeMillis();
        while (locallyRetryTimes++ < retryTimes && System.currentTimeMillis() < beginTime + timeout) {
            try {
                if (runnable.get().booleanValue()) {
                    break;
                }
            }
            catch (Exception e) {
                localException = e;
            }
            if (localException == null || localException != null && localException instanceof ClientException && KmsUtils.judgeNeedRecoveryException((ClientException)((Object)localException))) {
                Thread.sleep(200L);
                continue;
            }
            throw localException;
        }
        if (localException != null) {
            throw localException;
        }
    }

    private static String readFileToString(String filePath) {
        File file = AliyunConfigFilter.getFileByPath(filePath);
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            byte[] fileContent = Files.readAllBytes(path);
            return new String(fileContent, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getFileByPath(String filePath) {
        String path;
        File file = new File(filePath);
        if (!(file.exists() || (file = new File((path = AliyunConfigFilter.class.getClassLoader().getResource("").getPath()) + filePath)).exists() || (file = new File(path = Paths.get(filePath, new String[0]).toAbsolutePath().toString())).exists())) {
            return null;
        }
        return file;
    }

    private boolean isUseLocalCache() {
        return this.isUseLocalCache;
    }

    private KmsLocalCache getKmsLocalCache() {
        return this.kmsLocalCache;
    }

    private KmsLocalCache.LocalCacheItem getLocalCacheItem(String group, String dataId, String encryptDataKey, String encryptedContent) {
        if (!this.isLocalCacheAvailable()) {
            return null;
        }
        KmsLocalCache.LocalCacheItem localCacheItem = this.getKmsLocalCache().get(GroupKeyUtils.getGroupKey2(dataId, group));
        if (localCacheItem == null) {
            return null;
        }
        if (!this.checkIfKmsCacheItemValidByDecrypt(localCacheItem, dataId, encryptDataKey, encryptedContent)) {
            return null;
        }
        return localCacheItem;
    }

    private KmsLocalCache.LocalCacheItem getLocalCacheItem(String group, String dataId, String plainText) {
        if (!this.isLocalCacheAvailable()) {
            return null;
        }
        KmsLocalCache.LocalCacheItem localCacheItem = this.getKmsLocalCache().get(GroupKeyUtils.getGroupKey2(dataId, group));
        if (localCacheItem == null) {
            return null;
        }
        if (this.checkIfKmsCacheItemValidByEncrypt(localCacheItem, dataId, plainText)) {
            return null;
        }
        return localCacheItem;
    }

    private boolean checkIfKmsCacheItemValidByEncrypt(KmsLocalCache.LocalCacheItem localCacheItem, String dataId, String plainContent) {
        if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
            return !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedDataKey()) && !StringUtils.isBlank((CharSequence)localCacheItem.getPlainDataKey());
        }
        if (dataId.startsWith("cipher-")) {
            return !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedContent()) && !StringUtils.isBlank((CharSequence)localCacheItem.getPlainContent()) && localCacheItem.getPlainContent().equals(plainContent);
        }
        return false;
    }

    private boolean checkIfKmsCacheItemValidByDecrypt(KmsLocalCache.LocalCacheItem localCacheItem, String dataId, String encryptedDataKey, String encryptedContent) {
        String encryptedContentMd5 = MD5Utils.md5Hex(encryptedContent, AliyunConst.ENCODE_UTF8);
        if (dataId.startsWith("cipher-kms-aes-128-") || dataId.startsWith("cipher-kms-aes-256-")) {
            return !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedDataKey()) && !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedContentMD5()) && !StringUtils.isBlank((CharSequence)localCacheItem.getPlainDataKey()) && StringUtils.equals((CharSequence)localCacheItem.getEncryptedDataKey(), (CharSequence)encryptedDataKey) && StringUtils.equals((CharSequence)localCacheItem.getEncryptedContentMD5(), (CharSequence)encryptedContentMd5);
        }
        if (dataId.startsWith("cipher-")) {
            return !StringUtils.isBlank((CharSequence)localCacheItem.getEncryptedContentMD5()) && !StringUtils.isBlank((CharSequence)localCacheItem.getPlainContent()) && StringUtils.equals((CharSequence)localCacheItem.getEncryptedContentMD5(), (CharSequence)encryptedContentMd5);
        }
        return false;
    }

    private void checkIfKmsClientIsReady() throws Exception {
        if (this.kmsClient == null) {
            if (this.localInitException != null) {
                throw this.localInitException;
            }
            throw new RuntimeException("kms client isn't initialized. For more information, please check: https://help.aliyun.com/zh/mse/user-guide/create-and-use-encrypted-configurations?spm=a2c4g.11186623.0.0.55587becdOW3jf");
        }
    }

    private void throwExceptionIfStringBlankWithErrorKey(String s, String groupKey, String errorMsg, String errorKey) throws Exception {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new BlankStringException(String.format("[config: %s] %s. %s is null or empty.", groupKey, errorMsg, errorKey) + "For more information, please check: " + "https://help.aliyun.com/zh/mse/user-guide/create-and-use-encrypted-configurations?spm=a2c4g.11186623.0.0.55587becdOW3jf");
        }
    }

    private boolean isLocalCacheAvailable() {
        return this.isUseLocalCache() && this.getKmsLocalCache() != null;
    }

    public int getOrder() {
        return 1;
    }

    public String getFilterName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private static class BlankStringException
    extends RuntimeException {
        public BlankStringException(String message) {
            super(message);
        }
    }
}

