/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.auth.ram.identify;

import com.alibaba.nacos.client.auth.ram.identify.CredentialService;
import com.alibaba.nacos.client.auth.ram.identify.Credentials;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialWatcher.class);
    private static final long REFRESH_INTERVAL = 10000L;
    private final CredentialService serviceInstance;
    private final String appName;
    private String propertyPath;
    private boolean stopped;
    private final ScheduledExecutorService executor;

    public CredentialWatcher(String appName, CredentialService serviceInstance) {
        this.appName = appName;
        this.serviceInstance = serviceInstance;
        this.loadCredential(true);
        this.executor = ExecutorFactory.newSingleScheduledExecutorService((ThreadFactory)new NameThreadFactory("com.alibaba.nacos.client.auth.ram.identify.watcher"));
        this.executor.scheduleWithFixedDelay(new Runnable(){
            private long modified = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (CredentialWatcher.this.stopped) {
                        return;
                    }
                    boolean reload = false;
                    if (CredentialWatcher.this.propertyPath == null) {
                        reload = true;
                    } else {
                        File file = new File(CredentialWatcher.this.propertyPath);
                        long lastModified = file.lastModified();
                        if (this.modified != lastModified) {
                            reload = true;
                            this.modified = lastModified;
                        }
                    }
                    if (reload) {
                        CredentialWatcher.this.loadCredential(false);
                    }
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.stopped) {
            return;
        }
        if (this.executor != null) {
            ScheduledExecutorService scheduledExecutorService = this.executor;
            synchronized (scheduledExecutorService) {
                this.stopped = true;
                this.executor.shutdown();
            }
        }
        LOGGER.info("[{}] {} is stopped", (Object)this.appName, (Object)this.getClass().getSimpleName());
    }

    private void loadCredential(boolean init) {
        boolean loadResult;
        this.loadPropertyPath(init);
        InputStream propertiesIs = this.loadPropertyPathToStream();
        Credentials credentials = new Credentials();
        boolean bl = loadResult = Objects.isNull(propertiesIs) ? this.loadCredentialFromEnv(init, credentials) : this.loadCredentialFromProperties(propertiesIs, init, credentials);
        if (!loadResult) {
            return;
        }
        if (!credentials.valid()) {
            LOGGER.warn("[1] Credential file missing required property {} Credential file missing {} or {}", new Object[]{this.appName, "accessKey", "secretKey"});
            this.propertyPath = null;
        }
        this.serviceInstance.setCredential(credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadCredentialFromProperties(InputStream propertiesIs, boolean init, Credentials credentials) {
        Properties properties = new Properties();
        try {
            properties.load(propertiesIs);
        }
        catch (IOException e) {
            LOGGER.error("[26] Unable to load credential file, appName:" + this.appName + "Unable to load credential file " + this.propertyPath, (Throwable)e);
            this.propertyPath = null;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                propertiesIs.close();
            }
            catch (IOException e) {
                LOGGER.error("[27] Unable to close credential file, appName:" + this.appName + "Unable to close credential file " + this.propertyPath, (Throwable)e);
            }
        }
        if (init) {
            LOGGER.info("[{}] Load credential file {}", (Object)this.appName, (Object)this.propertyPath);
        }
        String accessKey = null;
        String secretKey = null;
        String tenantId = null;
        if (!"/etc/instanceInfo".equals(this.propertyPath)) {
            if (properties.containsKey("accessKey")) {
                accessKey = properties.getProperty("accessKey");
            }
            if (properties.containsKey("secretKey")) {
                secretKey = properties.getProperty("secretKey");
            }
            if (properties.containsKey("tenantId")) {
                tenantId = properties.getProperty("tenantId");
            }
        } else {
            if (properties.containsKey("env_spas_accessKey")) {
                accessKey = properties.getProperty("env_spas_accessKey");
            }
            if (properties.containsKey("env_spas_secretKey")) {
                secretKey = properties.getProperty("env_spas_secretKey");
            }
            if (properties.containsKey("ebv_spas_tenantId")) {
                tenantId = properties.getProperty("ebv_spas_tenantId");
            }
        }
        this.setAccessKey(credentials, accessKey);
        this.setSecretKey(credentials, secretKey);
        this.setTenantId(credentials, tenantId);
        return true;
    }

    private boolean loadCredentialFromEnv(boolean init, Credentials credentials) {
        this.propertyPath = null;
        String accessKey = NacosClientProperties.PROTOTYPE.getProperty("spas_accessKey");
        String secretKey = NacosClientProperties.PROTOTYPE.getProperty("spas_secretKey");
        if (accessKey == null && secretKey == null) {
            if (init) {
                LOGGER.info("{} No credential found", (Object)this.appName);
            }
            return false;
        }
        this.setAccessKey(credentials, accessKey);
        this.setSecretKey(credentials, secretKey);
        return true;
    }

    private void loadPropertyPath(boolean init) {
        if (this.propertyPath == null) {
            URL url = ClassLoader.getSystemResource("spas.properties");
            if (url != null) {
                this.propertyPath = url.getPath();
            }
            if (this.propertyPath == null || this.propertyPath.isEmpty()) {
                String value = NacosClientProperties.PROTOTYPE.getProperty("spas.identity");
                if (StringUtils.isNotEmpty((String)value)) {
                    this.propertyPath = value;
                }
                if (this.propertyPath == null || this.propertyPath.isEmpty()) {
                    this.propertyPath = "/home/admin/.spas_key/" + (this.appName == null ? "default" : this.appName);
                } else if (init) {
                    LOGGER.info("[{}] Defined credential file: -Dspas.identity={}", (Object)this.appName, (Object)this.propertyPath);
                }
            } else if (init) {
                LOGGER.info("[{}] Load credential file from classpath: {}", (Object)this.appName, (Object)"spas.properties");
            }
        }
    }

    private InputStream loadPropertyPathToStream() {
        FileInputStream propertiesIs = null;
        while (true) {
            try {
                propertiesIs = new FileInputStream(this.propertyPath);
            }
            catch (FileNotFoundException e) {
                if (this.appName != null && !this.appName.equals("default") && this.propertyPath.equals("/home/admin/.spas_key/" + this.appName)) {
                    this.propertyPath = "/home/admin/.spas_key/default";
                    continue;
                }
                if ("/etc/instanceInfo".equals(this.propertyPath)) break;
                this.propertyPath = "/etc/instanceInfo";
                continue;
            }
            break;
        }
        return propertiesIs;
    }

    private void setAccessKey(Credentials credentials, String accessKey) {
        if (!Objects.isNull(accessKey)) {
            credentials.setAccessKey(accessKey.trim());
        }
    }

    private void setSecretKey(Credentials credentials, String secretKey) {
        if (!Objects.isNull(secretKey)) {
            credentials.setSecretKey(secretKey.trim());
        }
    }

    private void setTenantId(Credentials credentials, String tenantId) {
        if (!Objects.isNull(tenantId)) {
            credentials.setTenantId(tenantId.trim());
        }
    }
}

