/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.remote.request;

import com.alibaba.nacos.api.ability.constant.AbilityKey;
import com.alibaba.nacos.api.ability.constant.AbilityStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RequestMeta {
    private String connectionId = "";
    private String clientIp = "";
    private String clientVersion = "";
    private Map<String, String> labels = new HashMap<String, String>();
    private Map<String, String> appLabels = new HashMap<String, String>();
    private Map<String, Boolean> abilityTable;

    public AbilityStatus getConnectionAbility(AbilityKey abilityKey) {
        if (this.abilityTable == null || !this.abilityTable.containsKey(abilityKey.getName())) {
            return AbilityStatus.UNKNOWN;
        }
        return this.abilityTable.get(abilityKey.getName()) != false ? AbilityStatus.SUPPORTED : AbilityStatus.NOT_SUPPORTED;
    }

    public void setAbilityTable(Map<String, Boolean> abilityTable) {
        this.abilityTable = abilityTable;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
        this.extractAppLabels();
    }

    private void extractAppLabels() {
        HashMap<String, String> applabelsMap = new HashMap<String, String>(8){
            {
                this.put("AppName", RequestMeta.this.labels.get("AppName"));
                this.put("ClientVersion", RequestMeta.this.clientVersion);
                this.put("ClientIp", RequestMeta.this.clientIp);
            }
        };
        this.labels.entrySet().stream().filter(Objects::nonNull).filter(e -> ((String)e.getKey()).startsWith("app_") && ((String)e.getKey()).length() > "app_".length() && !((String)e.getValue()).trim().isEmpty()).forEach(entry -> applabelsMap.putIfAbsent(((String)entry.getKey()).substring("app_".length()), (String)entry.getValue()));
        this.appLabels = applabelsMap;
    }

    public Map<String, String> getAppLabels() {
        return this.appLabels;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String toString() {
        return "RequestMeta{connectionId='" + this.connectionId + '\'' + ", clientIp='" + this.clientIp + '\'' + ", clientVersion='" + this.clientVersion + '\'' + ", labels=" + this.labels + '}';
    }
}

