/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.metrics.common;

import com.alibaba.metrics.BucketCounter;
import com.alibaba.metrics.ClusterHistogram;
import com.alibaba.metrics.Compass;
import com.alibaba.metrics.Counter;
import com.alibaba.metrics.FastCompass;
import com.alibaba.metrics.Gauge;
import com.alibaba.metrics.Histogram;
import com.alibaba.metrics.Meter;
import com.alibaba.metrics.MetricFilter;
import com.alibaba.metrics.MetricLevel;
import com.alibaba.metrics.MetricName;
import com.alibaba.metrics.Snapshot;
import com.alibaba.metrics.Timer;
import com.alibaba.metrics.common.MetricObject;
import com.alibaba.metrics.common.MetricsCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassifiedMetricsCollector
extends MetricsCollector {
    private static final int FASTCOMPASS_COUNT_OFFSET = 38;
    private static final long FASTCOMPASS_MASK = 0x3FFFFFFFFFL;
    private Map<MetricLevel, Map<Long, List<MetricObject>>> metrics;
    private Map<MetricLevel, Long> lastTimestamp = new HashMap<MetricLevel, Long>();
    private static final int CRITICAL_MAX_SAMPLE_NUM = 10;
    private static final int GENERAL_MAX_SAMPLE_NUM = 2;
    private int totalSize = 0;
    private int MAX_SIZE = MAX_COLLECT_NUM * 5;
    private boolean advancedMetricsReport = false;
    private static String COUNTER_NAME = "Counter";
    private static String GAUGE_NAME = "Gauge";
    private static String METER_NAME = "Meter";
    private static String HISTOGRAM_NAME = "Histogram";
    private static String TIMER_NAME = "Timer";
    private static String COMPASS_NAME = "Compass";
    private static String FASTCOMPASS_NAME = "FastCompass";
    private static String CLUSTER_HISTOGRAM_NAME = "ClusterHistogram";

    ClassifiedMetricsCollector(Map<String, String> globalTags, double rateFactor, double durationFactor, MetricFilter filter) {
        super(globalTags, rateFactor, durationFactor, filter);
        this.metrics = new HashMap<MetricLevel, Map<Long, List<MetricObject>>>();
    }

    public void collect(MetricName name, Counter counter, long timestamp) {
        int interval = this.metricsCollectPeriodConfig.period(name.getMetricLevel()) * 1000;
        long startTime = this.lastTimestamp.get(name.getMetricLevel()) + (long)interval;
        long endTime = (timestamp / (long)interval - 1L) * (long)interval;
        long guageTimestamp = startTime = this.adjustStartTime(startTime, endTime, interval, name.getMetricLevel());
        if (counter instanceof BucketCounter) {
            Map totalCounts = ((BucketCounter)counter).getBucketCounts(startTime);
            for (long time = startTime; time <= endTime; time += (long)interval) {
                long metricValue = 0L;
                if (totalCounts.containsKey(time)) {
                    metricValue = (Long)totalCounts.get(time);
                }
                this.addMetric(name, "bucket_count", (Object)metricValue, time, MetricObject.MetricType.DELTA, COUNTER_NAME);
            }
        }
        String normalizedName = name.getKey().endsWith("count") ? name.getKey() : name.resolve("count").getKey();
        MetricObject metricObject = MetricObject.named(normalizedName).withTimestamp(guageTimestamp).withType(MetricObject.MetricType.COUNTER).withValue(counter.getCount()).withLevel(name.getMetricLevel()).withTags(this.merge(this.globalTags, name.getTags())).withMeterName(COUNTER_NAME).build();
        this.addMetric(metricObject);
    }

    public void collect(MetricName name, Gauge gauge, long timestamp) {
        int interval = this.metricsCollectPeriodConfig.period(name.getMetricLevel()) * 1000;
        long startTime = this.lastTimestamp.get(name.getMetricLevel()) + (long)interval;
        long endTime = (timestamp / (long)interval - 1L) * (long)interval;
        long guageTimestamp = startTime = this.adjustStartTime(startTime, endTime, interval, name.getMetricLevel());
        MetricObject metricObject = MetricObject.named(name.getKey()).withValue(gauge.getValue()).withTimestamp(guageTimestamp).withType(MetricObject.MetricType.GAUGE).withLevel(name.getMetricLevel()).withTags(this.merge(this.globalTags, name.getTags())).withMeterName(GAUGE_NAME).build();
        this.addMetric(metricObject);
    }

    public void collect(MetricName name, Meter meter, long timestamp) {
        Map totalCounts = meter.getInstantCount(this.lastTimestamp.get(name.getMetricLevel()).longValue());
        int interval = this.metricsCollectPeriodConfig.period(name.getMetricLevel()) * 1000;
        long startTime = this.lastTimestamp.get(name.getMetricLevel()) + (long)interval;
        long endTime = (timestamp / (long)interval - 1L) * (long)interval;
        long guageTimestamp = startTime = this.adjustStartTime(startTime, endTime, interval, name.getMetricLevel());
        for (long time = startTime; time <= endTime; time += (long)interval) {
            long metricValue = 0L;
            if (totalCounts.containsKey(time)) {
                metricValue = (Long)totalCounts.get(time);
            }
            this.addMetric(name, "bucket_count", (Object)metricValue, time, MetricObject.MetricType.DELTA, METER_NAME);
        }
        this.addMetric(name, "count", (Object)meter.getCount(), guageTimestamp, MetricObject.MetricType.COUNTER, METER_NAME);
        this.addMetric(name, "m1", (Object)this.convertRate(meter.getOneMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, METER_NAME);
        if (this.advancedMetricsReport) {
            this.addMetric(name, "m5", (Object)this.convertRate(meter.getFiveMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, METER_NAME);
            this.addMetric(name, "m15", (Object)this.convertRate(meter.getFifteenMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, METER_NAME);
        }
    }

    public void collect(MetricName name, Histogram histogram, long timestamp) {
        Snapshot snapshot = histogram.getSnapshot();
        int interval = this.metricsCollectPeriodConfig.period(name.getMetricLevel()) * 1000;
        long startTime = this.lastTimestamp.get(name.getMetricLevel()) + (long)interval;
        long endTime = (timestamp / (long)interval - 1L) * (long)interval;
        long guageTimestamp = startTime = this.adjustStartTime(startTime, endTime, interval, name.getMetricLevel());
        this.addMetric(name, "mean", (Object)this.convertDuration(snapshot.getMean()), guageTimestamp, MetricObject.MetricType.GAUGE, HISTOGRAM_NAME);
        if (this.advancedMetricsReport) {
            this.addMetric(name, "max", (Object)snapshot.getMax(), guageTimestamp, MetricObject.MetricType.GAUGE, HISTOGRAM_NAME);
            this.addMetric(name, "min", (Object)snapshot.getMin(), guageTimestamp, MetricObject.MetricType.GAUGE, HISTOGRAM_NAME);
            this.addMetric(name, "stddev", (Object)snapshot.getStdDev(), guageTimestamp, MetricObject.MetricType.GAUGE, HISTOGRAM_NAME);
            this.addMetric(name, "median", (Object)snapshot.getMedian(), guageTimestamp, MetricObject.MetricType.GAUGE, HISTOGRAM_NAME);
            this.addMetric(name, "p75", (Object)snapshot.get75thPercentile(), guageTimestamp, MetricObject.MetricType.GAUGE, HISTOGRAM_NAME);
            this.addMetric(name, "p95", (Object)snapshot.get95thPercentile(), guageTimestamp, MetricObject.MetricType.GAUGE, HISTOGRAM_NAME);
            this.addMetric(name, "p99", (Object)snapshot.get99thPercentile(), guageTimestamp, MetricObject.MetricType.GAUGE, HISTOGRAM_NAME);
        }
    }

    public void collect(MetricName name, Timer timer, long timestamp) {
        Snapshot snapshot = timer.getSnapshot();
        Map totalCounts = timer.getInstantCount(this.lastTimestamp.get(name.getMetricLevel()).longValue());
        int interval = this.metricsCollectPeriodConfig.period(name.getMetricLevel()) * 1000;
        long startTime = this.lastTimestamp.get(name.getMetricLevel()) + (long)interval;
        long endTime = (timestamp / (long)interval - 1L) * (long)interval;
        long guageTimestamp = startTime = this.adjustStartTime(startTime, endTime, interval, name.getMetricLevel());
        for (long time = startTime; time <= endTime; time += (long)interval) {
            long metricValue = 0L;
            if (totalCounts.containsKey(time)) {
                metricValue = (Long)totalCounts.get(time);
            }
            this.addMetric(name, "bucket_count", (Object)metricValue, time, MetricObject.MetricType.DELTA, TIMER_NAME);
        }
        this.addMetric(name, "count", (Object)timer.getCount(), guageTimestamp, MetricObject.MetricType.COUNTER, TIMER_NAME);
        this.addMetric(name, "m1", (Object)this.convertRate(timer.getOneMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
        this.addMetric(name, "mean", (Object)this.convertDuration(snapshot.getMean()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
        if (this.advancedMetricsReport) {
            this.addMetric(name, "m5", (Object)this.convertRate(timer.getFiveMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
            this.addMetric(name, "m15", (Object)this.convertRate(timer.getFifteenMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
            this.addMetric(name, "max", (Object)this.convertDuration(snapshot.getMax()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
            this.addMetric(name, "min", (Object)this.convertDuration(snapshot.getMin()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
            this.addMetric(name, "stddev", (Object)this.convertDuration(snapshot.getStdDev()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
            this.addMetric(name, "median", (Object)this.convertDuration(snapshot.getMedian()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
            this.addMetric(name, "p75", (Object)this.convertDuration(snapshot.get75thPercentile()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
            this.addMetric(name, "p95", (Object)this.convertDuration(snapshot.get95thPercentile()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
            this.addMetric(name, "p99", (Object)this.convertDuration(snapshot.get99thPercentile()), guageTimestamp, MetricObject.MetricType.GAUGE, TIMER_NAME);
        }
    }

    public void collect(MetricName name, Compass compass, long timestamp) {
        BucketCounter metricValue;
        Snapshot snapshot = compass.getSnapshot();
        int interval = this.metricsCollectPeriodConfig.period(name.getMetricLevel()) * 1000;
        long startTime = this.lastTimestamp.get(name.getMetricLevel()) + (long)interval;
        long endTime = (timestamp / (long)interval - 1L) * (long)interval;
        long guageTimestamp = startTime = this.adjustStartTime(startTime, endTime, interval, name.getMetricLevel());
        Map totalCounts = compass.getInstantCount(this.lastTimestamp.get(name.getMetricLevel()).longValue());
        Map successCounts = compass.getBucketSuccessCount().getBucketCounts(this.lastTimestamp.get(name.getMetricLevel()).longValue());
        Map errorCounts = compass.getErrorCodeCounts();
        Map extraCounts = compass.getAddonCounts();
        for (long time = startTime; time <= endTime; time += (long)interval) {
            long total = 0L;
            long success = 0L;
            double successRate = 0.0;
            if (totalCounts.containsKey(time)) {
                total = (Long)totalCounts.get(time);
            }
            if (successCounts.containsKey(time)) {
                success = (Long)successCounts.get(time);
            }
            if (total == 0L) {
                successRate = 0.0;
            } else {
                successRate = 1.0 * (double)success / (double)total;
                if (successRate > 1.0) {
                    successRate = 1.0;
                }
            }
            this.addMetric(name, "success_bucket_count", (Object)success, time, MetricObject.MetricType.DELTA, COMPASS_NAME);
            this.addMetric(name, "bucket_count", (Object)total, time, MetricObject.MetricType.DELTA, COMPASS_NAME);
            this.addMetric(name, "qps", (Object)(1.0 * (double)total / (double)this.metricsCollectPeriodConfig.period(name.getMetricLevel())), time, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "success_rate", (Object)successRate, time, MetricObject.MetricType.GAUGE, COMPASS_NAME);
        }
        if (errorCounts != null && errorCounts.size() > 0) {
            for (Map.Entry entry : errorCounts.entrySet()) {
                String errorCode = (String)entry.getKey();
                metricValue = (BucketCounter)entry.getValue();
                Map errors = metricValue.getBucketCounts(this.lastTimestamp.get(name.getMetricLevel()).longValue());
                for (long time = startTime; time <= endTime; time += (long)interval) {
                    long metricValue1 = 0L;
                    if (errors.containsKey(time)) {
                        metricValue1 = (Long)errors.get(time);
                    }
                    this.addMetric(name.tagged(new String[]{"error", errorCode}), "error_bucket_count", (Object)metricValue1, time, MetricObject.MetricType.DELTA, COMPASS_NAME);
                }
                this.addMetric(name.tagged(new String[]{"error", errorCode}), "error.count", (Object)metricValue.getCount(), guageTimestamp, MetricObject.MetricType.COUNTER, COMPASS_NAME);
            }
        }
        if (extraCounts != null && extraCounts.size() > 0) {
            for (Map.Entry entry : extraCounts.entrySet()) {
                String extraField = (String)entry.getKey();
                metricValue = (BucketCounter)entry.getValue();
                Map extra = metricValue.getBucketCounts(this.lastTimestamp.get(name.getMetricLevel()).longValue());
                String suffix = extraField + "_bucket_count";
                for (long time = startTime; time <= endTime; time += (long)interval) {
                    long metricValue1 = 0L;
                    if (extra.containsKey(time)) {
                        metricValue1 = (Long)extra.get(time);
                    }
                    this.addMetric(name, suffix, (Object)metricValue1, time, MetricObject.MetricType.DELTA, COMPASS_NAME);
                }
            }
        }
        this.addMetric(name, "m1", (Object)this.convertRate(compass.getOneMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
        this.addMetric(name, "mean", (Object)this.convertDuration(snapshot.getMean()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
        this.addMetric(name, "rt", (Object)this.convertDuration(snapshot.getMean()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
        if (this.advancedMetricsReport) {
            this.addMetric(name, "m5", (Object)this.convertRate(compass.getFiveMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "m15", (Object)this.convertRate(compass.getFifteenMinuteRate()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "max", (Object)this.convertDuration(snapshot.getMax()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "min", (Object)this.convertDuration(snapshot.getMin()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "stddev", (Object)this.convertDuration(snapshot.getStdDev()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "median", (Object)this.convertDuration(snapshot.getMedian()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "p75", (Object)this.convertDuration(snapshot.get75thPercentile()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "p95", (Object)this.convertDuration(snapshot.get95thPercentile()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
            this.addMetric(name, "p99", (Object)this.convertDuration(snapshot.get99thPercentile()), guageTimestamp, MetricObject.MetricType.GAUGE, COMPASS_NAME);
        }
    }

    @Override
    public void collect(MetricName name, FastCompass fastCompass, long timestamp) {
        int intervalSeconds = this.metricsCollectPeriodConfig.period(name.getMetricLevel());
        int interval = this.metricsCollectPeriodConfig.period(name.getMetricLevel()) * 1000;
        long startTime = this.lastTimestamp.get(name.getMetricLevel()) + (long)interval;
        long endTime = (timestamp / (long)interval - 1L) * (long)interval;
        long guageTimestamp = startTime = this.adjustStartTime(startTime, endTime, interval, name.getMetricLevel());
        Map countAndRtPerCategory = fastCompass.getCountAndRtPerCategory(startTime);
        for (long time = startTime; time <= endTime; time += (long)interval) {
            Long errorNum;
            Long successNum;
            Long hitNum;
            long totalCount = 0L;
            long totalRt = 0L;
            long successCount = 0L;
            long hitCount = 0L;
            long errorCount = 0L;
            Map hits = (Map)countAndRtPerCategory.get("hit");
            Map successes = (Map)countAndRtPerCategory.get("success");
            Map errors = (Map)countAndRtPerCategory.get("error");
            if (hits != null && (hitNum = (Long)hits.get(time)) != null) {
                hitCount = this.getFastCompassCount(hitNum);
                totalCount += hitCount;
                totalRt += this.getFastCompassRt(hitNum);
            }
            if (successes != null && (successNum = (Long)successes.get(time)) != null) {
                successCount = this.getFastCompassCount(successNum);
                totalCount += successCount;
                totalRt += this.getFastCompassRt(successNum);
            }
            if (errors != null && (errorNum = (Long)errors.get(time)) != null) {
                errorCount = this.getFastCompassCount(errorNum);
                totalCount += errorCount;
                totalRt += this.getFastCompassRt(errorNum);
            }
            successCount += hitCount;
            this.addMetric(name, "bucket_count", (Object)totalCount, time, MetricObject.MetricType.DELTA, FASTCOMPASS_NAME);
            this.addMetric(name, "bucket_sum", (Object)totalRt, time, MetricObject.MetricType.DELTA, FASTCOMPASS_NAME);
            this.addMetric(name, "hit_bucket_count", (Object)hitCount, time, MetricObject.MetricType.DELTA, FASTCOMPASS_NAME);
            this.addMetric(name, "success_bucket_count", (Object)successCount, time, MetricObject.MetricType.DELTA, FASTCOMPASS_NAME);
            this.addMetric(name, "error_bucket_count", (Object)errorCount, time, MetricObject.MetricType.DELTA, FASTCOMPASS_NAME);
            this.addMetric(name, "qps", (Object)this.rate(totalCount, intervalSeconds), time, MetricObject.MetricType.GAUGE, FASTCOMPASS_NAME);
            this.addMetric(name, "rt", (Object)this.rate(totalRt, totalCount), time, MetricObject.MetricType.GAUGE, FASTCOMPASS_NAME);
            this.addMetric(name, "success_rate", (Object)this.ratio(successCount, totalCount), time, MetricObject.MetricType.GAUGE, FASTCOMPASS_NAME);
            if (hitCount < 0L) continue;
            this.addMetric(name, "hit_rate", (Object)this.ratio(hitCount, successCount), time, MetricObject.MetricType.GAUGE, FASTCOMPASS_NAME);
        }
    }

    @Override
    public void collect(MetricName name, ClusterHistogram clusterHistogram, long timestamp) {
        int interval = this.metricsCollectPeriodConfig.period(name.getMetricLevel()) * 1000;
        long startTime = this.lastTimestamp.get(name.getMetricLevel()) + (long)interval;
        long endTime = (timestamp / (long)interval - 1L) * (long)interval;
        startTime = this.adjustStartTime(startTime, endTime, interval, name.getMetricLevel());
        Map bucketValues = clusterHistogram.getBucketValues(startTime);
        for (long curTime = startTime; curTime <= endTime; curTime += (long)interval) {
            long[] buckets;
            if (!bucketValues.containsKey(curTime)) continue;
            Map bucketAndValues = (Map)bucketValues.get(curTime);
            for (long bucket : buckets = clusterHistogram.getBuckets()) {
                this.addMetric(name.tagged(new String[]{"bucket", bucket == Long.MAX_VALUE ? "+Inf" : Long.toString(bucket)}), "cluster_percentile", (Object)(bucketAndValues.containsKey(bucket) ? (Long)bucketAndValues.get(bucket) : 0L), curTime, MetricObject.MetricType.PERCENTILE);
            }
        }
    }

    public MetricsCollector addMetric(MetricName name, String suffix, Object value, long timestamp, MetricObject.MetricType type, String meterName) {
        MetricName fullName = name.resolve(suffix);
        return this.addMetric(fullName, value, timestamp, type, meterName);
    }

    @Override
    public MetricsCollector addMetric(MetricObject object) {
        if (this.totalSize >= this.MAX_SIZE) {
            return this;
        }
        if ((this.filter == null || this.filter.matches(MetricName.build((String[])new String[]{object.getMetric()}), null)) && object.getValue() != null) {
            List<MetricObject> metricObjects;
            MetricLevel level = object.getMetricLevel();
            int interval = this.metricsCollectPeriodConfig.period(level) * 1000;
            long timestamp = object.getTimestamp() / (long)interval * (long)interval;
            Map<Long, List<MetricObject>> metricsLevelUnit = this.metrics.get(level);
            if (metricsLevelUnit == null) {
                this.metrics.put(level, new HashMap());
            }
            if ((metricObjects = this.metrics.get(level).get(timestamp)) == null) {
                this.metrics.get(level).put(timestamp, new ArrayList());
            }
            List<MetricObject> lst = this.metrics.get(level).get(timestamp);
            lst.add(object);
            ++this.totalSize;
        }
        return this;
    }

    private MetricsCollector addMetric(MetricName fullName, Object value, long timestamp, MetricObject.MetricType type, String meterName) {
        MetricObject obj = MetricObject.named(fullName.getKey()).withType(type).withTimestamp(timestamp).withValue(value).withTags(this.merge(this.globalTags, fullName.getTags())).withLevel(fullName.getMetricLevel()).withMeterName(meterName).build();
        return this.addMetric(obj);
    }

    public Map<MetricLevel, Map<Long, List<MetricObject>>> getMetrics() {
        return this.metrics;
    }

    public void setLastTimestamp(Map<MetricLevel, Long> lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    public long adjustStartTime(long startTime, long endTime, int interval, MetricLevel level) {
        int sampleNum = (int)((endTime - startTime) / (long)interval);
        int maxSampleNum = 2;
        if (level == MetricLevel.CRITICAL) {
            maxSampleNum = 10;
        }
        if (sampleNum > maxSampleNum) {
            startTime = endTime - (long)(interval * maxSampleNum);
        }
        return startTime;
    }

    private long getFastCompassCount(long num) {
        return num >> 38;
    }

    private long getFastCompassRt(long num) {
        return num & 0x3FFFFFFFFFL;
    }

    public void setAdvancedMetricsReport(boolean enable) {
        this.advancedMetricsReport = enable;
    }
}

