/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TypeUtils {
    public static int intValue(BigDecimal decimal) {
        if (decimal == null) {
            return 0;
        }
        int scale = decimal.scale();
        if (scale >= -100 && scale <= 100) {
            return decimal.intValue();
        }
        return decimal.intValueExact();
    }

    public static <T> T cast(Object obj, Class<T> clazz, ParserConfig config) {
        return (T)com.alibaba.fastjson2.util.TypeUtils.cast((Object)obj, clazz);
    }

    public static <T> T cast(Object obj, Type type, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, mapping);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(obj, (ParameterizedType)type, mapping);
        }
        if (obj instanceof String && ((strVal = (String)obj).length() == 0 || "null".equals(strVal) || "NULL".equals(strVal))) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)obj;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T cast(Object obj, ParameterizedType type, ParserConfig mapping) {
        Type argType;
        String strVal;
        Type itemType;
        Type rawTye = type.getRawType();
        if (rawTye == List.class || rawTye == ArrayList.class) {
            itemType = type.getActualTypeArguments()[0];
            if (obj instanceof List) {
                List listObj = (List)obj;
                ArrayList<T> arrayList = new ArrayList<T>(listObj.size());
                for (int i = 0; i < listObj.size(); ++i) {
                    Object item = listObj.get(i);
                    T itemValue = itemType instanceof Class ? (item != null && item.getClass() == JSONObject.class ? ((JSONObject)item).toJavaObject((Class)itemType, mapping, 0) : TypeUtils.cast(item, (Class)itemType, mapping)) : TypeUtils.cast(item, itemType, mapping);
                    arrayList.add(itemValue);
                }
                return (T)arrayList;
            }
        }
        if (rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == Collection.class || rawTye == List.class || rawTye == ArrayList.class) {
            itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                AbstractCollection collection = rawTye == Set.class || rawTye == HashSet.class ? new HashSet() : (rawTye == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object item : (Iterable)obj) {
                    T itemValue = itemType instanceof Class ? (item != null && item.getClass() == JSONObject.class ? ((JSONObject)item).toJavaObject((Class)itemType, mapping, 0) : TypeUtils.cast(item, (Class)itemType, mapping)) : TypeUtils.cast(item, itemType, mapping);
                    collection.add(itemValue);
                }
                return (T)collection;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtils.cast(entry.getKey(), keyType, mapping);
                    T value = TypeUtils.cast(entry.getValue(), valueType, mapping);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type.getActualTypeArguments().length == 1 && (argType = type.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtils.cast(obj, rawTye, mapping);
        }
        if (rawTye == Map.Entry.class && obj instanceof Map && ((Map)obj).size() == 1) {
            Map.Entry entry = ((Map)obj).entrySet().iterator().next();
            return (T)entry;
        }
        if (rawTye instanceof Class) {
            if (mapping == null) {
                mapping = ParserConfig.global;
            }
            throw new JSONException("TODO : " + type);
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig config) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : (value instanceof BigDecimal ? ((BigDecimal)value).intValueExact() : value.intValue());
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get(JSON.DEFAULT_TYPE_KEY);
            if (iClassObject instanceof String) {
                String className = (String)iClassObject;
                if (config == null) {
                    config = ParserConfig.global;
                }
                throw new JSONException("TODO");
            }
            if (clazz.isInterface()) {
                JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                if (config == null) {
                    config = ParserConfig.getGlobalInstance();
                }
                throw new JSONException("TODO");
            }
            if (clazz == Locale.class) {
                Object arg0 = map.get("language");
                Object arg1 = map.get("country");
                if (arg0 instanceof String) {
                    String language = (String)arg0;
                    if (arg1 instanceof String) {
                        String country = (String)arg1;
                        return (T)new Locale(language, country);
                    }
                    if (arg1 == null) {
                        return (T)new Locale(language);
                    }
                }
            }
            if (clazz == String.class && map instanceof JSONObject) {
                return (T)map.toString();
            }
            if (clazz == LinkedHashMap.class && map instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)map;
                Map<String, Object> innerMap = jsonObject.getInnerMap();
                if (innerMap instanceof LinkedHashMap) {
                    return (T)innerMap;
                }
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                linkedHashMap.putAll(innerMap);
            }
            ObjectReader objectReader = JSONFactory.getDefaultObjectReaderProvider().getObjectReader(clazz);
            return (T)objectReader.createInstance(map, 0L);
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName, Field[] declaredFields) {
        for (Field field : declaredFields) {
            char c1;
            char c0;
            String itemName = field.getName();
            if (fieldName.equals(itemName)) {
                return field;
            }
            if (fieldName.length() <= 2 || (c0 = fieldName.charAt(0)) < 'a' || c0 > 'z' || (c1 = fieldName.charAt(1)) < 'A' || c1 > 'Z' || !fieldName.equalsIgnoreCase(itemName)) continue;
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return TypeUtils.getField(superClass, fieldName, superClass.getDeclaredFields());
        }
        return null;
    }

    public static Type checkPrimitiveArray(GenericArrayType genericArrayType) {
        Class ck;
        Type clz = genericArrayType;
        Type genericComponentType = genericArrayType.getGenericComponentType();
        String prefix = "[";
        while (genericComponentType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericComponentType).getGenericComponentType();
            prefix = prefix + prefix;
        }
        if (genericComponentType instanceof Class && (ck = (Class)genericComponentType).isPrimitive()) {
            try {
                if (ck == Boolean.TYPE) {
                    clz = Class.forName(prefix + "Z");
                } else if (ck == Character.TYPE) {
                    clz = Class.forName(prefix + "C");
                } else if (ck == Byte.TYPE) {
                    clz = Class.forName(prefix + "B");
                } else if (ck == Short.TYPE) {
                    clz = Class.forName(prefix + "S");
                } else if (ck == Integer.TYPE) {
                    clz = Class.forName(prefix + "I");
                } else if (ck == Long.TYPE) {
                    clz = Class.forName(prefix + "J");
                } else if (ck == Float.TYPE) {
                    clz = Class.forName(prefix + "F");
                } else if (ck == Double.TYPE) {
                    clz = Class.forName(prefix + "D");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clz;
    }

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> item : clazz.getInterfaces()) {
            String interfaceName = item.getName();
            if ("net.sf.cglib.proxy.Factory".equals(interfaceName) || "org.springframework.cglib.proxy.Factory".equals(interfaceName)) {
                return true;
            }
            if ("javassist.util.proxy.ProxyObject".equals(interfaceName) || "org.apache.ibatis.javassist.util.proxy.ProxyObject".equals(interfaceName)) {
                return true;
            }
            if (!"org.hibernate.proxy.HibernateProxy".equals(interfaceName)) continue;
            return true;
        }
        return false;
    }
}

