/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.edas.dubbo;

import com.alibaba.acm.shaded.com.google.common.collect.Lists;
import com.alibaba.cloud.context.cs.AliCloudCsInitializer;
import com.alibaba.cloud.context.cs.CsHandledConfiguration;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.UrlUtils;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.support.FailbackRegistry;
import com.alibaba.edas.acm.ConfigService;
import com.alibaba.edas.acm.listener.ConfigChangeListener;
import com.alibaba.edas.acm.listener.ConfigChangeListenerAdapter;
import com.taobao.config.client.Publisher;
import com.taobao.config.client.PublisherRegistrar;
import com.taobao.config.client.PublisherRegistration;
import com.taobao.config.client.Subscriber;
import com.taobao.config.client.SubscriberDataObserver;
import com.taobao.config.client.SubscriberRegistrar;
import com.taobao.config.client.SubscriberRegistration;
import com.taobao.config.client.utils.StringUtils;
import com.taobao.diamond.client.Diamond;
import com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.taobao.diamond.manager.ManagerListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdasRegistry
extends FailbackRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdasRegistry.class);
    private final CsHandledConfiguration csHandledConfiguration;
    private final String root;
    private static final String DEFAULT_ROOT = "dubbo";
    private static final String PREFIX = "dubbo://";
    private static final String ACM_SEPARATOR = ":";
    private static final int RETRY_TIMES = 5;
    private static final String EMPTY = "empty_data";
    private static final String TIME_OUT_STRING = System.getProperty("edas.dubbo.subscribe.time");
    private static final long TIME_OUT = StringUtils.isBlank((String)TIME_OUT_STRING) ? 2500L : (long)Integer.parseInt(TIME_OUT_STRING);
    private final ConcurrentHashMap<URL, ConfigServerNotify> listeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, DiamondListener> diamondListeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<URL, List<Subscriber>> subscriberMap = new ConcurrentHashMap();

    public EdasRegistry(URL url, CsHandledConfiguration csHandledConfiguration) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getParameter("group", DEFAULT_ROOT);
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        if (!group.endsWith("/")) {
            group = group + "/";
        }
        this.root = group;
        this.csHandledConfiguration = csHandledConfiguration;
    }

    protected void doRegister(URL url) {
        if (null == url.getParameter("category") || url.getParameter("category").equals("consumers") || url.getParameter("category").equals("providers")) {
            this.registryToConfigServer(url);
        } else if (url.getParameter("category").equals("routers") || url.getParameter("category").equals("configurators")) {
            this.registryToAcm(url);
        }
    }

    protected void doUnregister(URL url) {
        if (null == url.getParameter("category") || url.getParameter("category").equals("consumers") || url.getParameter("category").equals("providers")) {
            this.unRegistryFromConfigServer(url);
        } else if (url.getParameter("category").equals("routers") || url.getParameter("category").equals("configurators")) {
            this.unRegistryFromAcm(url);
        }
    }

    protected void doSubscribe(URL url, NotifyListener notifyListener) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ConfigServerNotify configServerNotify = new ConfigServerNotify(countDownLatch, url, Arrays.asList(notifyListener), this);
        this.listeners.put(url, configServerNotify);
        this.subscribeDubboData(url, configServerNotify, notifyListener);
        if (null != url.getParameter("version") && null != url.getParameter("group")) {
            this.subscribeHsfData(url, configServerNotify);
        }
        try {
            countDownLatch.await(TIME_OUT, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("interrupted exception when waiting subscribe ", (Throwable)e);
        }
    }

    protected void doUnsubscribe(URL url, NotifyListener notifyListener) {
        this.unSubscribeFromConfigServer(url);
        this.unSubscribeFromAcm(url);
    }

    public boolean isAvailable() {
        return false;
    }

    public List<URL> lookup(URL url) {
        return null;
    }

    private void registryToConfigServer(URL url) {
        String dataId = this.toCategoryPath(url);
        String value = url.toFullString();
        String publisherName = url.getServiceName() + url.getParameter("pid");
        String datumId = this.getDataTumId(url);
        PublisherRegistration registration = new PublisherRegistration(publisherName, dataId, datumId);
        AliCloudCsInitializer.initialize((CsHandledConfiguration)this.csHandledConfiguration, (PublisherRegistration)registration);
        registration.setGroup(url.getParameter("group", ""));
        Publisher publisher = PublisherRegistrar.register((PublisherRegistration)registration);
        publisher.publish((Serializable)((Object)value));
    }

    private synchronized void registryToAcm(URL url) {
        String dataId = this.toCategoryPath(url);
        dataId = dataId.replace("/", ACM_SEPARATOR);
        ArrayList configs = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            try {
                String content;
                String originContent = content = ConfigService.getConfig((String)dataId, (String)"DEFAULT_GROUP", (long)3000L);
                if (content == null || StringUtils.isBlank((String)content)) {
                    if (i < 2) {
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    configs.add(url.toFullString());
                    if (!Diamond.publishSingle((String)dataId, (String)"DEFAULT_GROUP", (String)((Object)configs).toString())) continue;
                    return;
                }
                if (StringUtils.equals((String)content, (String)EMPTY)) {
                    configs.add(url.toFullString());
                    if (!Diamond.publishSingleCas((String)dataId, (String)"DEFAULT_GROUP", (String)EMPTY, (String)((Object)configs).toString())) continue;
                    return;
                }
                configs = Lists.newArrayList((Object[])(content = content.substring(1, content.length() - 1)).split(", "));
                if (configs.contains(url.toFullString())) {
                    return;
                }
                configs.add(url.toFullString());
                if (!Diamond.publishSingleCas((String)dataId, (String)"DEFAULT_GROUP", (String)originContent, (String)((Object)configs).toString())) continue;
                return;
            }
            catch (Exception e) {
                LOGGER.error("register to acm error,dataId:{},value:{},e:", new Object[]{dataId, url.toFullString(), e});
            }
        }
        LOGGER.error("fail to register to acm after {} retry,dataId:{},value:{},e:", new Object[]{5, dataId, url.toFullString()});
    }

    private void unRegistryFromConfigServer(URL url) {
    }

    private synchronized void unRegistryFromAcm(URL url) {
        String dataId = this.toCategoryPath(url);
        dataId = dataId.replace("/", ACM_SEPARATOR);
        for (int i = 0; i < 5; ++i) {
            try {
                String content;
                String originContent = content = ConfigService.getConfig((String)dataId, (String)"DEFAULT_GROUP", (long)3000L);
                if (content == null || StringUtils.isBlank((String)content) || StringUtils.equals((String)content, (String)EMPTY)) {
                    return;
                }
                content = content.substring(1, content.length() - 1);
                ArrayList configs = Lists.newArrayList((Object[])content.split(", "));
                configs.remove(url.toFullString());
                if (!(configs.size() == 0 ? Diamond.publishSingleCas((String)dataId, (String)"DEFAULT_GROUP", (String)originContent, (String)EMPTY) : Diamond.publishSingleCas((String)dataId, (String)"DEFAULT_GROUP", (String)originContent, (String)(content = ((Object)configs).toString())))) continue;
                return;
            }
            catch (Exception e) {
                LOGGER.error("unRegister from acm error,dataId:{},e:", (Object)dataId, (Object)e);
            }
        }
        LOGGER.error("fail to unregister from acm after {} retry,dataId:{},value:{},e:", new Object[]{5, dataId, url.toFullString()});
    }

    private void subscribeHsfData(URL url, ConfigServerNotify configServerNotify) {
        String service = url.getServiceInterface();
        String version = url.getParameter("version");
        String dataId = service + ACM_SEPARATOR + version;
        String subscriberName = url.getServiceName() + url.getParameter("pid");
        String datumId = this.getDataTumId(url);
        SubscriberRegistration registration = new SubscriberRegistration(subscriberName, dataId, datumId);
        AliCloudCsInitializer.initialize((CsHandledConfiguration)this.csHandledConfiguration, (SubscriberRegistration)registration);
        registration.setGroup(url.getParameter("group"));
        Subscriber subscriber = SubscriberRegistrar.register((SubscriberRegistration)registration);
        subscriber.setDataObserver((SubscriberDataObserver)configServerNotify);
        List<Subscriber> subscribers = this.subscriberMap.get(url);
        if (subscribers == null) {
            subscribers = new ArrayList<Subscriber>();
            this.subscriberMap.put(url, subscribers);
        }
        subscribers.add(subscriber);
    }

    private void subscribeDubboData(URL url, ConfigServerNotify configServerNotify, NotifyListener notifyListener) {
        String subscriberNameDubbo = url.getServiceName() + url.getParameter("pid");
        String datumIdDubbo = this.getDataTumId(url);
        for (String path : this.toCategoriesPath(url)) {
            int index = path.lastIndexOf("/");
            String category = path.substring(index + 1);
            if (category.equals("providers") || category.equals("consumers")) {
                SubscriberRegistration registration = new SubscriberRegistration(subscriberNameDubbo, path, datumIdDubbo);
                AliCloudCsInitializer.initialize((CsHandledConfiguration)this.csHandledConfiguration, (SubscriberRegistration)registration);
                registration.setGroup(url.getParameter("group", ""));
                Subscriber subscriber = SubscriberRegistrar.register((SubscriberRegistration)registration);
                subscriber.setDataObserver((SubscriberDataObserver)configServerNotify);
                List<Subscriber> subscribers = this.subscriberMap.get(url);
                if (subscribers == null) {
                    subscribers = new ArrayList<Subscriber>();
                    this.subscriberMap.put(url, subscribers);
                }
                subscribers.add(subscriber);
                continue;
            }
            this.subscribeFromAcm(url, path, notifyListener);
        }
    }

    private void unSubscribeFromConfigServer(URL url) {
        List<Subscriber> subscribers = this.subscriberMap.get(url);
        if (null == subscribers) {
            return;
        }
        for (Subscriber subscriber : subscribers) {
            SubscriberRegistrar.unregister((Subscriber)subscriber);
        }
    }

    private void unSubscribeFromAcm(URL url) {
        for (String path : this.toCategoriesPath(url)) {
            path = path.replace("/", ACM_SEPARATOR);
            ConfigChangeListener configChangeListener = this.diamondListeners.get(path);
            try {
                DiamondEnvRepo.getDefaultEnv().removeTenantListener(path, "DEFAULT_GROUP", (ManagerListener)configChangeListener);
            }
            catch (Exception e) {
                LOGGER.error("remove config listener from acm error,path:{},", (Object)path, (Object)e);
            }
        }
    }

    private void subscribeFromAcm(URL url, String path, NotifyListener notifyListener) {
        DiamondListener diamondListener = this.diamondListeners.get(path = path.replace("/", ACM_SEPARATOR));
        if (diamondListener == null) {
            diamondListener = new DiamondListener(url, this, Arrays.asList(notifyListener), path);
            this.diamondListeners.put(path, diamondListener);
        }
        ConfigService.addListener((String)path, (String)"DEFAULT_GROUP", (ConfigChangeListenerAdapter)diamondListener);
    }

    private String toCategoryPath(URL url) {
        return this.toServicePath(url) + "/" + url.getParameter("category", "providers");
    }

    private String toServicePath(String categoryPath) {
        int i = categoryPath.startsWith(this.root) ? categoryPath.indexOf("/", this.root.length()) : categoryPath.indexOf("/");
        return i > 0 ? categoryPath.substring(0, i) : categoryPath;
    }

    private String toServicePath(URL url) {
        return this.root + url.getServiceInterface();
    }

    private String[] toCategoriesPath(URL url) {
        String[] categories = "*".equals(url.getParameter("category")) ? new String[]{"providers", "consumers", "routers", "configurators"} : url.getParameter("category", new String[]{"providers"});
        String[] paths = new String[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            paths[i] = this.toServicePath(url) + "/" + categories[i];
        }
        return paths;
    }

    private String getDataTumId(URL url) {
        String datumId = System.getProperty("JM.CONTAINER.ID");
        if (StringUtils.isEmpty((String)datumId)) {
            String appNameId = System.getProperty("project.name");
            datumId = StringUtils.isNotEmpty((String)appNameId) ? "ecu:" + appNameId + ACM_SEPARATOR + url.getHost() : "ecu:" + url.getHost();
        }
        return datumId;
    }

    public class DiamondListener
    extends ConfigChangeListener {
        private final URL url;
        private final EdasRegistry registry;
        private final Collection<NotifyListener> listeners;
        private final String dataId;

        public DiamondListener(URL url, EdasRegistry registry, Collection<NotifyListener> listeners, String dataId) {
            this.url = url;
            this.registry = registry;
            this.listeners = listeners;
            this.dataId = dataId;
        }

        private List<URL> getEmptyUrls() {
            String subscribeStr = this.dataId.replace(EdasRegistry.ACM_SEPARATOR, "/");
            String service = this.url.getServiceInterface();
            String group = this.url.getParameter("group");
            String version = this.url.getParameter("version");
            String category = subscribeStr.substring(subscribeStr.lastIndexOf("/") + 1);
            URL emptyUrl = URL.valueOf((String)("empty://0.0.0.0/" + service + "?" + "category" + "=" + category + (group == null ? "" : "&group=" + group) + (version == null ? "" : "&version=" + version)));
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(emptyUrl);
            return urls;
        }

        public void receiveConfigInfo(String configInfo) {
            if (StringUtils.isBlank((String)configInfo)) {
                List<URL> urls = this.getEmptyUrls();
                for (NotifyListener listener : this.listeners) {
                    this.registry.notify(this.url, listener, urls);
                }
                return;
            }
            String content = configInfo.substring(1, configInfo.length() - 1);
            ArrayList configs = Lists.newArrayList((Object[])content.split(", "));
            List<Object> urls = new ArrayList();
            for (String tmp : configs) {
                URL url = URL.valueOf((String)tmp);
                urls.add(url);
            }
            if (urls.size() == 0) {
                urls = this.getEmptyUrls();
            }
            for (NotifyListener listener : this.listeners) {
                this.registry.notify(this.url, listener, urls);
            }
        }
    }

    class ConfigServerNotify
    implements SubscriberDataObserver {
        private CountDownLatch countDownLatch;
        private URL url;
        private Collection<NotifyListener> listeners;
        private EdasRegistry registry;
        private List<URL> lastHsfUrls;
        private List<URL> lastDubboUrls;

        public ConfigServerNotify(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public ConfigServerNotify(CountDownLatch countDownLatch, URL url, List<NotifyListener> notifyListeners, EdasRegistry edasConfigServerRegistry) {
            this.countDownLatch = countDownLatch;
            this.url = url;
            this.listeners = notifyListeners;
            this.registry = edasConfigServerRegistry;
            this.lastDubboUrls = Collections.emptyList();
            this.lastHsfUrls = Collections.emptyList();
        }

        public void handleData(String dataId, List<Object> data) {
            LOGGER.info("New issues from ConfigServer arrived: " + data);
            ArrayList<URL> result = new ArrayList<URL>();
            if (dataId.contains("/")) {
                this.processDubboData(dataId, data);
            } else {
                this.processHsfData(dataId, data);
            }
            result.addAll(this.lastDubboUrls);
            result.addAll(this.lastHsfUrls);
            for (NotifyListener listener : this.listeners) {
                this.registry.notify(this.url, listener, result);
            }
            if (result.size() > 0) {
                this.countDownLatch.countDown();
            }
        }

        private void processHsfData(String dataId, List<Object> data) {
            String consumerService = this.url.getServiceInterface();
            String providerService = dataId.substring(0, dataId.indexOf(EdasRegistry.ACM_SEPARATOR));
            if (!"*".equals(consumerService) && !providerService.equals(consumerService)) {
                return;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object obj : data) {
                String str = (String)obj;
                URL u = this.convertHsfDataToDubboURL(str, dataId);
                urls.add(u);
            }
            this.lastHsfUrls = urls;
        }

        private void processDubboData(String dataId, List<Object> data) {
            String providerService;
            String consumerService = this.url.getServiceInterface();
            String servicePath = EdasRegistry.this.toServicePath(dataId);
            String string = providerService = servicePath.startsWith(EdasRegistry.this.root) ? servicePath.substring(EdasRegistry.this.root.length()) : servicePath;
            if (!"*".equals(consumerService) && !providerService.equals(consumerService)) {
                return;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object obj : data) {
                String str = (String)obj;
                str = EdasRegistry.PREFIX + str;
                URL u = URL.valueOf((String)str);
                if (!UrlUtils.isMatch((URL)this.url, (URL)u)) continue;
                urls.add(u);
            }
            this.lastDubboUrls = urls;
        }

        private String toCategoryName(String categoryPath) {
            int i = categoryPath.lastIndexOf("/");
            return i > 0 ? categoryPath.substring(i + 1) : categoryPath;
        }

        private URL convertHsfDataToDubboURL(String data, String dataId) {
            String service = dataId.substring(0, dataId.indexOf(EdasRegistry.ACM_SEPARATOR));
            String version = dataId.substring(dataId.indexOf(EdasRegistry.ACM_SEPARATOR) + 1);
            String host = data.substring(0, data.indexOf(EdasRegistry.ACM_SEPARATOR));
            int port = Integer.parseInt(StringUtils.substringBetween((String)data, (String)EdasRegistry.ACM_SEPARATOR, (String)"?"));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("side", "provider");
            params.put("interface", service);
            params.put("version", version);
            params.put("group", this.url.getParameter("group"));
            return new URL(EdasRegistry.DEFAULT_ROOT, host, port, service, params);
        }
    }
}

