package com.alibaba.edas.dubbo;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.AliCloudSdk;
import com.alibaba.cloud.context.AliCloudServerMode;
import com.alibaba.cloud.context.SimpleAliCloudConfiguration;
import com.alibaba.cloud.context.acm.AcmConfiguration;
import com.alibaba.cloud.context.acm.AliCloudAcmInitializer;
import com.alibaba.cloud.context.acm.SimpleAcmConfiguration;
import com.alibaba.cloud.context.cs.*;
import com.alibaba.cloud.context.edas.AliCloudEdasSdk;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.alibaba.cloud.context.edas.SimpleEdasConfiguration;
import com.alibaba.cloud.context.statistics.StatisticsTask;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.registry.Registry;
import com.alibaba.dubbo.registry.support.AbstractRegistryFactory;

import com.aliyuncs.edas.model.v20170801.GetSecureTokenResponse;
import com.taobao.config.client.ConfigClientPerfCtrl;

import java.io.File;
import java.util.Arrays;

/**
 * @author edas
 */
public class EdasRegistryFactory extends AbstractRegistryFactory {

    private static final int MAX_LENGTH = 2048;

    @Override
    protected Registry createRegistry(URL url) {

        AliCloudConfiguration cloudConfiguration = getAliCloudConfiguration(url);

        EdasConfiguration edasConfiguration = getEdasConfiguration(url);

        CsConfiguration csConfiguration = getCsConfiguration(url);

        CsHandledConfiguration csHandledConfiguration = AliCloudCsInitializer.handleCsConfiguration(cloudConfiguration,
            edasConfiguration, csConfiguration);

        AcmConfiguration acmConfiguration = getAcmConfiguration(url, cloudConfiguration, edasConfiguration);

        AliCloudAcmInitializer.initialize(cloudConfiguration, edasConfiguration, acmConfiguration);

        ConfigClientPerfCtrl.setDataIdLengthMax(MAX_LENGTH);
        ConfigClientPerfCtrl.setDataContentLengthMax(MAX_LENGTH);

        if (csHandledConfiguration.getServerMode() == AliCloudServerMode.LOCAL) {
            ((SimpleCsHandledConfiguration)csHandledConfiguration).setProjectName(resolveAppName(url));
        }
        StatisticsTask statisticsTask = new StatisticsTask(cloudConfiguration, edasConfiguration,
            Arrays.asList("DUBBO-RPC"));
        statisticsTask.start();
        return new EdasRegistry(url, csHandledConfiguration);

    }

    private CsConfiguration getCsConfiguration(URL url) {
        SimpleCsConfiguration csConfiguration = new SimpleCsConfiguration();
        if (StringUtils.isEmpty(url.getParameter("endpoint"))) {
            csConfiguration.setServerList(url.getHost());
        }
        return csConfiguration;
    }

    private AliCloudConfiguration getAliCloudConfiguration(URL url) {

        String alicloudAccessKey = System.getProperty("alicloud.accessKey");
        String alicloudSecretKey = System.getProperty("alicloud.secretKey");

        if (StringUtils.isEmpty(alicloudAccessKey)) {
            alicloudAccessKey = url.getParameter("alicloud.accessKey");
        }

        if (StringUtils.isEmpty(alicloudSecretKey)) {
            alicloudSecretKey = url.getParameter("alicloud.secretKey");
        }

        SimpleAliCloudConfiguration cloudConfiguration = new SimpleAliCloudConfiguration();
        cloudConfiguration.setAccessKey(alicloudAccessKey);
        cloudConfiguration.setSecretKey(alicloudSecretKey);
        return cloudConfiguration;
    }

    private EdasConfiguration getEdasConfiguration(URL url) {

        String applicationName = resolveAppName(url);

        String edasEnabledStr = System.getProperty("alicloud.edas.enabled");
        String edasNamespace = System.getProperty("alicloud.edas.namespace");
        if (StringUtils.isEmpty(edasEnabledStr)) {
            edasEnabledStr = url.getParameter("alicloud.edas.enabled");
        }
        if (StringUtils.isEmpty(edasNamespace)) {
            edasNamespace = url.getParameter("alicloud.edas.namespace");
        }
        SimpleEdasConfiguration edasConfiguration = new SimpleEdasConfiguration();
        edasConfiguration.setApplicationName(applicationName);
        edasConfiguration.setEnabled(Boolean.valueOf(edasEnabledStr));
        edasConfiguration.setNamespace(edasNamespace);

        return edasConfiguration;
    }

    private AcmConfiguration getAcmConfiguration(URL url, AliCloudConfiguration cloudConfiguration,
                                                 EdasConfiguration edasConfiguration) {

        SimpleAcmConfiguration acmConfiguration = new SimpleAcmConfiguration();
        if (!edasConfiguration.isEnabled()) {
            if (StringUtils.isEmpty(url.getParameter("endpoint"))) {
                acmConfiguration.setServerList(url.getHost());
                acmConfiguration.setServerPort(url.getPort() + "");
            }
            return acmConfiguration;
        }
        AliCloudSdk aliCloudSdk = new AliCloudSdk(cloudConfiguration, edasConfiguration);
        AliCloudEdasSdk aliCloudEdasSdk = new AliCloudEdasSdk(aliCloudSdk);
        GetSecureTokenResponse.SecureToken secureToken = aliCloudEdasSdk.getSecureToken(
            edasConfiguration.getNamespace());
        secureToken.getAddressServerHost();

        acmConfiguration.setEndpoint(secureToken.getAddressServerHost());
        acmConfiguration.setNamespace(secureToken.getTenantId());
        return acmConfiguration;
    }

    public static String resolveAppName(URL url) {
        String app = System.getProperty("project.name");
        if (!StringUtils.isEmpty(app)) {
            return app;
        } else if (!StringUtils.isEmpty(url.getParameter("application"))) {
            return url.getParameter("application");
        } else {
            String command = System.getProperty("sun.java.command");
            if (!StringUtils.isEmpty(command)) {
                command = command.split("\\s")[0];
                String separator = File.separator;
                if (command.contains(separator)) {
                    String[] strs;
                    if ("\\".equals(separator)) {
                        strs = command.split("\\\\");
                    } else {
                        strs = command.split(separator);
                    }

                    command = strs[strs.length - 1];
                }

                if (command.endsWith(".jar") || command.endsWith(".JAR")) {
                    command = command.substring(0, command.length() - 4);
                }

                return command;
            }
        }
        throw new RuntimeException("can't resolve project.name!");
    }

}
