/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

class ServerAddressIterator
implements Iterator<String> {
    final List<RandomizedServerAddress> sorted = new ArrayList<RandomizedServerAddress>();
    final Iterator<RandomizedServerAddress> iter;

    public ServerAddressIterator(List<String> source) {
        for (String address : source) {
            this.sorted.add(new RandomizedServerAddress(address));
        }
        Collections.sort(this.sorted);
        this.iter = this.sorted.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public String next() {
        return this.iter.next().serverIp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static class RandomizedServerAddress
    implements Comparable<RandomizedServerAddress> {
        static Random random = new Random();
        String serverIp;
        int priority = 0;
        int seed;

        public RandomizedServerAddress(String ip) {
            try {
                this.serverIp = ip;
                this.seed = random.nextInt(Integer.MAX_VALUE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int compareTo(RandomizedServerAddress other) {
            if (this.priority != other.priority) {
                return other.priority - this.priority;
            }
            return other.seed - this.seed;
        }
    }
}

