/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.middleware.tls;

import com.alibaba.middleware.tls.log.TlsLogger;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class SelfHostnameVerifier
implements HostnameVerifier {
    private static final int IPV4_LENGTH = 4;
    private final HostnameVerifier hv;
    private static ConcurrentHashMap<String, Boolean> hosts = new ConcurrentHashMap();

    public SelfHostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        if (SelfHostnameVerifier.isIPv4(hostname)) {
            return true;
        }
        return this.hv.verify(hostname, session);
    }

    private static boolean isIPv4(String host) {
        if (host == null || host.isEmpty()) {
            TlsLogger.warn("host is empty, isIPv4 = false");
            return false;
        }
        Boolean isIp = hosts.get(host);
        if (isIp != null) {
            return isIp;
        }
        String[] sections = host.split("\\.");
        isIp = SelfHostnameVerifier.verifySections(sections);
        hosts.putIfAbsent(host, isIp);
        return isIp;
    }

    private static boolean verifySections(String[] sections) {
        if (sections.length != 4) {
            String msg = "invalid section length, isIPv4 = false len(section): " + sections.length;
            TlsLogger.warn(msg);
        }
        for (String section : sections) {
            int value = Integer.MAX_VALUE;
            try {
                value = Integer.parseInt(section);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (value >= 0 && value <= 256) continue;
            String msg = "invalid ipv4 digit, isIPv4 = false section: " + section;
            TlsLogger.warn(msg);
            return false;
        }
        return true;
    }
}

