/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.acm.shaded.com.aliyuncs.profile;

import com.alibaba.acm.shaded.com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.alibaba.acm.shaded.com.aliyuncs.auth.Credential;
import com.alibaba.acm.shaded.com.aliyuncs.auth.CredentialsBackupCompatibilityAdaptor;
import com.alibaba.acm.shaded.com.aliyuncs.auth.ICredentialProvider;
import com.alibaba.acm.shaded.com.aliyuncs.auth.ISigner;
import com.alibaba.acm.shaded.com.aliyuncs.exceptions.ClientException;
import com.alibaba.acm.shaded.com.aliyuncs.http.FormatType;
import com.alibaba.acm.shaded.com.aliyuncs.profile.IClientProfile;
import com.alibaba.acm.shaded.com.aliyuncs.regions.CustomizedEndpointsParser;
import com.alibaba.acm.shaded.com.aliyuncs.regions.Endpoint;
import com.alibaba.acm.shaded.com.aliyuncs.regions.IEndpointsProvider;
import com.alibaba.acm.shaded.com.aliyuncs.regions.InternalEndpointsParser;
import com.alibaba.acm.shaded.com.aliyuncs.regions.LocationConfig;
import com.alibaba.acm.shaded.com.aliyuncs.regions.ProductDomain;
import com.alibaba.acm.shaded.com.aliyuncs.regions.RemoteEndpointsParser;
import com.alibaba.acm.shaded.com.aliyuncs.utils.CacheTimeHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultProfile
implements IClientProfile {
    private static DefaultProfile profile = null;
    private static List<Endpoint> endpoints = null;
    private String regionId = null;
    private FormatType acceptFormat = null;
    private IEndpointsProvider iendpoints = null;
    private IEndpointsProvider remoteProvider = null;
    private ICredentialProvider icredential = null;
    private Credential credential;
    private LocationConfig locationConfig = new LocationConfig();

    private DefaultProfile() {
        this.locationConfig = new LocationConfig();
        this.iendpoints = new InternalEndpointsParser();
        this.remoteProvider = RemoteEndpointsParser.initRemoteEndpointsParser();
    }

    private DefaultProfile(String regionId) {
        this();
        this.regionId = regionId;
    }

    private DefaultProfile(String region, Credential creden) {
        this.iendpoints = new InternalEndpointsParser();
        this.remoteProvider = RemoteEndpointsParser.initRemoteEndpointsParser();
        this.credential = creden;
        this.regionId = region;
        this.locationConfig = new LocationConfig();
    }

    private DefaultProfile(String region, Credential creden, IEndpointsProvider provider) {
        this.iendpoints = provider;
        this.credential = creden;
        this.regionId = region;
        this.locationConfig = new LocationConfig();
        this.remoteProvider = RemoteEndpointsParser.initRemoteEndpointsParser();
    }

    private DefaultProfile(ICredentialProvider icredential) {
        this.icredential = icredential;
        this.iendpoints = new InternalEndpointsParser();
        this.remoteProvider = RemoteEndpointsParser.initRemoteEndpointsParser();
        this.locationConfig = new LocationConfig();
    }

    private DefaultProfile(String region, ICredentialProvider icredential) {
        this.regionId = region;
        this.icredential = icredential;
        this.iendpoints = new InternalEndpointsParser();
        this.locationConfig = new LocationConfig();
        this.remoteProvider = RemoteEndpointsParser.initRemoteEndpointsParser();
    }

    private DefaultProfile(ICredentialProvider icredential, String region, FormatType format) {
        this.regionId = region;
        this.acceptFormat = format;
        this.icredential = icredential;
        this.iendpoints = new InternalEndpointsParser();
        this.remoteProvider = RemoteEndpointsParser.initRemoteEndpointsParser();
        this.locationConfig = new LocationConfig();
    }

    @Override
    public synchronized String getRegionId() {
        return this.regionId;
    }

    @Override
    public synchronized FormatType getFormat() {
        return this.acceptFormat;
    }

    @Override
    public synchronized Credential getCredential() {
        if (null == this.credential && null != this.icredential) {
            this.credential = this.icredential.fresh();
        }
        return this.credential;
    }

    @Override
    @Deprecated
    public ISigner getSigner() {
        return null;
    }

    @Override
    public synchronized void setLocationConfig(String regionId, String product, String endpoint) {
        this.locationConfig = LocationConfig.createLocationConfig(regionId, product, endpoint);
    }

    @Override
    public List<Endpoint> getEndpoints() throws ClientException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized List<Endpoint> getEndpoints(String regionId, String product) throws ClientException {
        Endpoint endpoint;
        if (null == endpoints && (endpoint = this.iendpoints.getEndpoint(regionId, product)) != null) {
            endpoints = new ArrayList<Endpoint>();
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    @Override
    public synchronized List<Endpoint> getEndpoints(String product, String regionId, String serviceCode, String endpointType) throws ClientException {
        if (product == null) {
            return endpoints;
        }
        if (null == endpoints) {
            Endpoint endpoint = null;
            if (serviceCode != null) {
                endpoint = this.remoteProvider.getEndpoint(regionId, product, serviceCode, endpointType, this.credential, this.locationConfig);
            }
            if (endpoint == null) {
                endpoint = this.iendpoints.getEndpoint(regionId, product);
            }
            if (endpoint != null) {
                endpoints = new ArrayList<Endpoint>();
                endpoints.add(endpoint);
                CacheTimeHelper.addLastClearTimePerProduct(product, regionId, new Date());
            }
        } else if (Endpoint.findProductDomain(regionId, product, endpoints) == null || CacheTimeHelper.CheckEndPointCacheIsExpire(product, regionId)) {
            Endpoint endpoint = null;
            if (serviceCode != null) {
                endpoint = this.remoteProvider.getEndpoint(regionId, product, serviceCode, endpointType, this.credential, this.locationConfig);
            }
            if (endpoint == null) {
                endpoint = this.iendpoints.getEndpoint(regionId, product);
            }
            if (endpoint != null) {
                for (String region : endpoint.getRegionIds()) {
                    for (ProductDomain productDomain : endpoint.getProductDomains()) {
                        DefaultProfile.addEndpoint(endpoint.getName(), region, product, productDomain.getDomianName(), false);
                        CacheTimeHelper.addLastClearTimePerProduct(product, region, new Date());
                    }
                }
            }
        }
        return endpoints;
    }

    public static synchronized DefaultProfile getProfile() {
        if (null == profile) {
            profile = new DefaultProfile();
        }
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, ICredentialProvider icredential) {
        profile = new DefaultProfile(regionId, icredential);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, String accessKeyId, String secret) {
        Credential creden = new Credential(accessKeyId, secret);
        profile = new DefaultProfile(regionId, creden);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, String accessKeyId, String secret, String stsToken) {
        Credential creden = new Credential(accessKeyId, secret, stsToken);
        profile = new DefaultProfile(regionId, creden);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, Map<String, String> productDomainMap, String accessKeyId, String secret) {
        Credential creden = new Credential(accessKeyId, secret);
        CustomizedEndpointsParser provider = CustomizedEndpointsParser.initParser(regionId, productDomainMap);
        profile = new DefaultProfile(regionId, creden, provider);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, Map<String, String> productDomainMap, String accessKeyId, String secret, String stsToken) {
        Credential creden = new Credential(accessKeyId, secret, stsToken);
        CustomizedEndpointsParser provider = CustomizedEndpointsParser.initParser(regionId, productDomainMap);
        profile = new DefaultProfile(regionId, creden, provider);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, IEndpointsProvider provider, String accessKeyId, String secret) {
        Credential creden = new Credential(accessKeyId, secret);
        profile = new DefaultProfile(regionId, creden, provider);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, IEndpointsProvider provider, String accessKeyId, String secret, String stsToken) {
        Credential creden = new Credential(accessKeyId, secret, stsToken);
        profile = new DefaultProfile(regionId, creden, provider);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId) {
        return new DefaultProfile(regionId);
    }

    public static synchronized void addEndpoint(String endpointName, String regionId, String product, String domain) throws ClientException {
        DefaultProfile.addEndpoint(endpointName, regionId, product, domain, true);
    }

    public static synchronized void addEndpoint(String endpointName, String regionId, String product, String domain, boolean isNeverExpire) throws ClientException {
        Endpoint endpoint;
        if (null == endpoints) {
            endpoints = DefaultProfile.getProfile().getEndpoints(regionId, product);
        }
        if (null == (endpoint = DefaultProfile.findEndpointByRegionId(regionId))) {
            DefaultProfile.addEndpoint_(endpointName, regionId, product, domain);
        } else {
            DefaultProfile.updateEndpoint(regionId, product, domain, endpoint);
        }
        if (isNeverExpire) {
            Date date = new Date(32472115200000L);
            CacheTimeHelper.addLastClearTimePerProduct(product, regionId, date);
        }
    }

    private static void addEndpoint_(String endpointName, String regionId, String product, String domain) {
        HashSet<String> regions = new HashSet<String>();
        regions.add(regionId);
        ArrayList<ProductDomain> productDomains = new ArrayList<ProductDomain>();
        productDomains.add(new ProductDomain(product, domain));
        Endpoint endpoint = new Endpoint(endpointName, regions, productDomains);
        if (endpoints == null) {
            endpoints = new ArrayList<Endpoint>();
        }
        endpoints.add(endpoint);
    }

    private static void updateEndpoint(String regionId, String product, String domain, Endpoint endpoint) {
        Set<String> regionIds = endpoint.getRegionIds();
        regionIds.add(regionId);
        List<ProductDomain> productDomains = endpoint.getProductDomains();
        ProductDomain productDomain = DefaultProfile.findProductDomain(productDomains, product);
        if (null == productDomain) {
            ProductDomain newProductDomain = new ProductDomain(product, domain);
            productDomains.add(newProductDomain);
        } else {
            productDomain.setDomianName(domain);
        }
    }

    private static Endpoint findEndpointByRegionId(String regionId) {
        if (null == endpoints) {
            return null;
        }
        for (Endpoint endpoint : endpoints) {
            if (!endpoint.getRegionIds().contains(regionId)) continue;
            return endpoint;
        }
        return null;
    }

    private static ProductDomain findProductDomain(List<ProductDomain> productDomains, String product) {
        for (ProductDomain productDomain : productDomains) {
            if (!productDomain.getProductName().equals(product)) continue;
            return productDomain;
        }
        return null;
    }

    public void mockRemoteProvider(IEndpointsProvider remoteProvider) {
        this.remoteProvider = remoteProvider;
    }

    @Override
    public void setCredentialsProvider(AlibabaCloudCredentialsProvider credentialsProvider) {
        if (this.credential != null) {
            return;
        }
        this.credential = new CredentialsBackupCompatibilityAdaptor(credentialsProvider);
    }
}

