/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.metadata.holder;

import com.alibaba.excel.cache.ReadCache;
import com.alibaba.excel.cache.selector.EternalReadCacheSelector;
import com.alibaba.excel.cache.selector.ReadCacheSelector;
import com.alibaba.excel.cache.selector.SimpleReadCacheSelector;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.enums.HolderEnum;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import com.alibaba.excel.read.metadata.holder.AbstractReadHolder;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReadWorkbookHolder
extends AbstractReadHolder {
    private ReadWorkbook readWorkbook;
    private InputStream inputStream;
    private File file;
    private Boolean mandatoryUseInputStream;
    private Boolean autoCloseStream;
    private ExcelTypeEnum excelType;
    private Object customObject;
    private Boolean ignoreEmptyRow;
    private ReadCache readCache;
    private ReadCacheSelector readCacheSelector;
    private File tempFile;
    private String password;
    private Set<CellExtraTypeEnum> extraReadSet;
    private List<ReadSheet> actualSheetDataList;
    private List<ReadSheet> parameterSheetDataList;
    private Boolean readAll;
    private Set<Integer> hasReadSheet;

    public ReadWorkbookHolder(ReadWorkbook readWorkbook) {
        super(readWorkbook, null);
        this.readWorkbook = readWorkbook;
        if (readWorkbook.getInputStream() != null) {
            this.inputStream = readWorkbook.getInputStream();
        }
        this.file = readWorkbook.getFile();
        this.mandatoryUseInputStream = readWorkbook.getMandatoryUseInputStream() == null ? Boolean.FALSE : readWorkbook.getMandatoryUseInputStream();
        this.autoCloseStream = readWorkbook.getAutoCloseStream() == null ? Boolean.TRUE : readWorkbook.getAutoCloseStream();
        this.customObject = readWorkbook.getCustomObject();
        this.ignoreEmptyRow = readWorkbook.getIgnoreEmptyRow() == null ? Boolean.TRUE : readWorkbook.getIgnoreEmptyRow();
        if (readWorkbook.getReadCache() != null) {
            if (readWorkbook.getReadCacheSelector() != null) {
                throw new ExcelAnalysisException("'readCache' and 'readCacheSelector' only one choice.");
            }
            this.readCacheSelector = new EternalReadCacheSelector(readWorkbook.getReadCache());
        } else {
            this.readCacheSelector = readWorkbook.getReadCacheSelector() == null ? new SimpleReadCacheSelector() : readWorkbook.getReadCacheSelector();
        }
        this.extraReadSet = readWorkbook.getExtraReadSet() == null ? new HashSet<CellExtraTypeEnum>() : readWorkbook.getExtraReadSet();
        this.hasReadSheet = new HashSet<Integer>();
        this.password = readWorkbook.getPassword();
    }

    @Override
    public HolderEnum holderType() {
        return HolderEnum.WORKBOOK;
    }

    public ReadWorkbook getReadWorkbook() {
        return this.readWorkbook;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public File getFile() {
        return this.file;
    }

    public Boolean getMandatoryUseInputStream() {
        return this.mandatoryUseInputStream;
    }

    public Boolean getAutoCloseStream() {
        return this.autoCloseStream;
    }

    public ExcelTypeEnum getExcelType() {
        return this.excelType;
    }

    public Object getCustomObject() {
        return this.customObject;
    }

    public Boolean getIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public ReadCache getReadCache() {
        return this.readCache;
    }

    public ReadCacheSelector getReadCacheSelector() {
        return this.readCacheSelector;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<CellExtraTypeEnum> getExtraReadSet() {
        return this.extraReadSet;
    }

    public List<ReadSheet> getActualSheetDataList() {
        return this.actualSheetDataList;
    }

    public List<ReadSheet> getParameterSheetDataList() {
        return this.parameterSheetDataList;
    }

    public Boolean getReadAll() {
        return this.readAll;
    }

    public Set<Integer> getHasReadSheet() {
        return this.hasReadSheet;
    }

    public void setReadWorkbook(ReadWorkbook readWorkbook) {
        this.readWorkbook = readWorkbook;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setMandatoryUseInputStream(Boolean mandatoryUseInputStream) {
        this.mandatoryUseInputStream = mandatoryUseInputStream;
    }

    public void setAutoCloseStream(Boolean autoCloseStream) {
        this.autoCloseStream = autoCloseStream;
    }

    public void setExcelType(ExcelTypeEnum excelType) {
        this.excelType = excelType;
    }

    public void setCustomObject(Object customObject) {
        this.customObject = customObject;
    }

    public void setIgnoreEmptyRow(Boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
    }

    public void setReadCache(ReadCache readCache) {
        this.readCache = readCache;
    }

    public void setReadCacheSelector(ReadCacheSelector readCacheSelector) {
        this.readCacheSelector = readCacheSelector;
    }

    public void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setExtraReadSet(Set<CellExtraTypeEnum> extraReadSet) {
        this.extraReadSet = extraReadSet;
    }

    public void setActualSheetDataList(List<ReadSheet> actualSheetDataList) {
        this.actualSheetDataList = actualSheetDataList;
    }

    public void setParameterSheetDataList(List<ReadSheet> parameterSheetDataList) {
        this.parameterSheetDataList = parameterSheetDataList;
    }

    public void setReadAll(Boolean readAll) {
        this.readAll = readAll;
    }

    public void setHasReadSheet(Set<Integer> hasReadSheet) {
        this.hasReadSheet = hasReadSheet;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadWorkbookHolder)) {
            return false;
        }
        ReadWorkbookHolder other = (ReadWorkbookHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$mandatoryUseInputStream = this.getMandatoryUseInputStream();
        Boolean other$mandatoryUseInputStream = other.getMandatoryUseInputStream();
        if (this$mandatoryUseInputStream == null ? other$mandatoryUseInputStream != null : !((Object)this$mandatoryUseInputStream).equals(other$mandatoryUseInputStream)) {
            return false;
        }
        Boolean this$autoCloseStream = this.getAutoCloseStream();
        Boolean other$autoCloseStream = other.getAutoCloseStream();
        if (this$autoCloseStream == null ? other$autoCloseStream != null : !((Object)this$autoCloseStream).equals(other$autoCloseStream)) {
            return false;
        }
        Boolean this$ignoreEmptyRow = this.getIgnoreEmptyRow();
        Boolean other$ignoreEmptyRow = other.getIgnoreEmptyRow();
        if (this$ignoreEmptyRow == null ? other$ignoreEmptyRow != null : !((Object)this$ignoreEmptyRow).equals(other$ignoreEmptyRow)) {
            return false;
        }
        Boolean this$readAll = this.getReadAll();
        Boolean other$readAll = other.getReadAll();
        if (this$readAll == null ? other$readAll != null : !((Object)this$readAll).equals(other$readAll)) {
            return false;
        }
        ReadWorkbook this$readWorkbook = this.getReadWorkbook();
        ReadWorkbook other$readWorkbook = other.getReadWorkbook();
        if (this$readWorkbook == null ? other$readWorkbook != null : !((Object)this$readWorkbook).equals(other$readWorkbook)) {
            return false;
        }
        InputStream this$inputStream = this.getInputStream();
        InputStream other$inputStream = other.getInputStream();
        if (this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        ExcelTypeEnum this$excelType = this.getExcelType();
        ExcelTypeEnum other$excelType = other.getExcelType();
        if (this$excelType == null ? other$excelType != null : !((Object)((Object)this$excelType)).equals((Object)other$excelType)) {
            return false;
        }
        Object this$customObject = this.getCustomObject();
        Object other$customObject = other.getCustomObject();
        if (this$customObject == null ? other$customObject != null : !this$customObject.equals(other$customObject)) {
            return false;
        }
        ReadCache this$readCache = this.getReadCache();
        ReadCache other$readCache = other.getReadCache();
        if (this$readCache == null ? other$readCache != null : !this$readCache.equals(other$readCache)) {
            return false;
        }
        ReadCacheSelector this$readCacheSelector = this.getReadCacheSelector();
        ReadCacheSelector other$readCacheSelector = other.getReadCacheSelector();
        if (this$readCacheSelector == null ? other$readCacheSelector != null : !this$readCacheSelector.equals(other$readCacheSelector)) {
            return false;
        }
        File this$tempFile = this.getTempFile();
        File other$tempFile = other.getTempFile();
        if (this$tempFile == null ? other$tempFile != null : !((Object)this$tempFile).equals(other$tempFile)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Set<CellExtraTypeEnum> this$extraReadSet = this.getExtraReadSet();
        Set<CellExtraTypeEnum> other$extraReadSet = other.getExtraReadSet();
        if (this$extraReadSet == null ? other$extraReadSet != null : !((Object)this$extraReadSet).equals(other$extraReadSet)) {
            return false;
        }
        List<ReadSheet> this$actualSheetDataList = this.getActualSheetDataList();
        List<ReadSheet> other$actualSheetDataList = other.getActualSheetDataList();
        if (this$actualSheetDataList == null ? other$actualSheetDataList != null : !((Object)this$actualSheetDataList).equals(other$actualSheetDataList)) {
            return false;
        }
        List<ReadSheet> this$parameterSheetDataList = this.getParameterSheetDataList();
        List<ReadSheet> other$parameterSheetDataList = other.getParameterSheetDataList();
        if (this$parameterSheetDataList == null ? other$parameterSheetDataList != null : !((Object)this$parameterSheetDataList).equals(other$parameterSheetDataList)) {
            return false;
        }
        Set<Integer> this$hasReadSheet = this.getHasReadSheet();
        Set<Integer> other$hasReadSheet = other.getHasReadSheet();
        return !(this$hasReadSheet == null ? other$hasReadSheet != null : !((Object)this$hasReadSheet).equals(other$hasReadSheet));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadWorkbookHolder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $mandatoryUseInputStream = this.getMandatoryUseInputStream();
        result = result * 59 + ($mandatoryUseInputStream == null ? 43 : ((Object)$mandatoryUseInputStream).hashCode());
        Boolean $autoCloseStream = this.getAutoCloseStream();
        result = result * 59 + ($autoCloseStream == null ? 43 : ((Object)$autoCloseStream).hashCode());
        Boolean $ignoreEmptyRow = this.getIgnoreEmptyRow();
        result = result * 59 + ($ignoreEmptyRow == null ? 43 : ((Object)$ignoreEmptyRow).hashCode());
        Boolean $readAll = this.getReadAll();
        result = result * 59 + ($readAll == null ? 43 : ((Object)$readAll).hashCode());
        ReadWorkbook $readWorkbook = this.getReadWorkbook();
        result = result * 59 + ($readWorkbook == null ? 43 : ((Object)$readWorkbook).hashCode());
        InputStream $inputStream = this.getInputStream();
        result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        ExcelTypeEnum $excelType = this.getExcelType();
        result = result * 59 + ($excelType == null ? 43 : ((Object)((Object)$excelType)).hashCode());
        Object $customObject = this.getCustomObject();
        result = result * 59 + ($customObject == null ? 43 : $customObject.hashCode());
        ReadCache $readCache = this.getReadCache();
        result = result * 59 + ($readCache == null ? 43 : $readCache.hashCode());
        ReadCacheSelector $readCacheSelector = this.getReadCacheSelector();
        result = result * 59 + ($readCacheSelector == null ? 43 : $readCacheSelector.hashCode());
        File $tempFile = this.getTempFile();
        result = result * 59 + ($tempFile == null ? 43 : ((Object)$tempFile).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Set<CellExtraTypeEnum> $extraReadSet = this.getExtraReadSet();
        result = result * 59 + ($extraReadSet == null ? 43 : ((Object)$extraReadSet).hashCode());
        List<ReadSheet> $actualSheetDataList = this.getActualSheetDataList();
        result = result * 59 + ($actualSheetDataList == null ? 43 : ((Object)$actualSheetDataList).hashCode());
        List<ReadSheet> $parameterSheetDataList = this.getParameterSheetDataList();
        result = result * 59 + ($parameterSheetDataList == null ? 43 : ((Object)$parameterSheetDataList).hashCode());
        Set<Integer> $hasReadSheet = this.getHasReadSheet();
        result = result * 59 + ($hasReadSheet == null ? 43 : ((Object)$hasReadSheet).hashCode());
        return result;
    }

    public ReadWorkbookHolder() {
    }
}

