/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.style.column;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;

public class LongestMatchColumnWidthStyleStrategy
extends AbstractColumnWidthStyleStrategy {
    private static final int MAX_COLUMN_WIDTH = 255;
    private Map<Integer, Map<Integer, Integer>> cache = new HashMap<Integer, Map<Integer, Integer>>(8);

    @Override
    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        Integer maxColumnWidth;
        Integer columnWidth;
        boolean needSetWidth;
        boolean bl = needSetWidth = isHead != false || !CollectionUtils.isEmpty(cellDataList);
        if (!needSetWidth) {
            return;
        }
        Map<Integer, Integer> maxColumnWidthMap = this.cache.get(writeSheetHolder.getSheetNo());
        if (maxColumnWidthMap == null) {
            maxColumnWidthMap = new HashMap<Integer, Integer>(16);
            this.cache.put(writeSheetHolder.getSheetNo(), maxColumnWidthMap);
        }
        if ((columnWidth = this.dataLength(cellDataList, cell, isHead)) < 0) {
            return;
        }
        if (columnWidth > 255) {
            columnWidth = 255;
        }
        if ((maxColumnWidth = maxColumnWidthMap.get(cell.getColumnIndex())) == null || columnWidth > maxColumnWidth) {
            maxColumnWidthMap.put(cell.getColumnIndex(), columnWidth);
            writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), columnWidth * 256);
        }
    }

    private Integer dataLength(List<CellData> cellDataList, Cell cell, Boolean isHead) {
        if (isHead.booleanValue()) {
            return cell.getStringCellValue().getBytes().length;
        }
        CellData cellData = cellDataList.get(0);
        CellDataTypeEnum type = cellData.getType();
        if (type == null) {
            return -1;
        }
        switch (type) {
            case STRING: {
                return cellData.getStringValue().getBytes().length;
            }
            case BOOLEAN: {
                return cellData.getBooleanValue().toString().getBytes().length;
            }
            case NUMBER: {
                return cellData.getNumberValue().toString().getBytes().length;
            }
        }
        return -1;
    }
}

