/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v03.handlers;

import com.alibaba.excel.analysis.v03.AbstractXlsRecordHandler;
import com.alibaba.excel.metadata.CellData;
import java.math.BigDecimal;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;

public class NumberRecordHandler
extends AbstractXlsRecordHandler {
    private FormatTrackingHSSFListener formatListener;

    public NumberRecordHandler(FormatTrackingHSSFListener formatListener) {
        this.formatListener = formatListener;
    }

    @Override
    public boolean support(Record record) {
        return 515 == record.getSid();
    }

    @Override
    public void processRecord(Record record) {
        NumberRecord numrec = (NumberRecord)record;
        this.row = numrec.getRow();
        this.column = numrec.getColumn();
        this.cellData = new CellData(BigDecimal.valueOf(numrec.getValue()));
        this.cellData.setDataFormat(this.formatListener.getFormatIndex((CellValueRecordInterface)numrec));
        this.cellData.setDataFormatString(this.formatListener.getFormatString((CellValueRecordInterface)numrec));
    }

    @Override
    public void init() {
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

