/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write;

import com.alibaba.excel.context.GenerateContext;
import com.alibaba.excel.context.GenerateContextImpl;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.ExcelColumnProperty;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.metadata.Table;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.POITempFile;
import com.alibaba.excel.util.TypeUtil;
import com.alibaba.excel.write.ExcelBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ExcelBuilderImpl
implements ExcelBuilder {
    private GenerateContext context;

    @Override
    public void init(InputStream templateInputStream, OutputStream out, ExcelTypeEnum excelType, boolean needHead) {
        try {
            POITempFile.createPOIFilesDirectory();
            this.context = new GenerateContextImpl(templateInputStream, out, excelType, needHead);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addContent(List data, int startRow) {
        if (data != null && data.size() > 0) {
            Row row;
            int rowNum = this.context.getCurrentSheet().getLastRowNum();
            if (!(rowNum != 0 || (row = this.context.getCurrentSheet().getRow(0)) != null || this.context.getExcelHeadProperty() != null && this.context.needHead())) {
                rowNum = -1;
            }
            if (rowNum < startRow) {
                rowNum = startRow;
            }
            for (int i = 0; i < data.size(); ++i) {
                int n = i + rowNum + 1;
                this.addOneRowOfDataToExcel(data.get(i), n);
            }
        }
    }

    @Override
    public void addContent(List data, Sheet sheetParam) {
        this.context.buildCurrentSheet(sheetParam);
        this.addContent(data, sheetParam.getStartRow());
    }

    @Override
    public void addContent(List data, Sheet sheetParam, Table table) {
        this.context.buildCurrentSheet(sheetParam);
        this.context.buildTable(table);
        this.addContent(data, sheetParam.getStartRow());
    }

    @Override
    public void finish() {
        try {
            this.context.getWorkbook().write(this.context.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addOneRowOfDataToExcel(List<Object> oneRowData, Row row) {
        if (oneRowData != null && oneRowData.size() > 0) {
            for (int i = 0; i < oneRowData.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(this.context.getCurrentContentStyle());
                Object cellValue = oneRowData.get(i);
                if (cellValue != null) {
                    if (cellValue instanceof String) {
                        cell.setCellValue((String)cellValue);
                        continue;
                    }
                    if (cellValue instanceof Integer) {
                        cell.setCellValue(Double.parseDouble(cellValue.toString()));
                        continue;
                    }
                    if (cellValue instanceof Double) {
                        cell.setCellValue(((Double)cellValue).doubleValue());
                        continue;
                    }
                    if (!(cellValue instanceof Short)) continue;
                    cell.setCellValue(Double.parseDouble(cellValue.toString()));
                    continue;
                }
                cell.setCellValue((String)null);
            }
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, Row row) {
        int i = 0;
        for (ExcelColumnProperty excelHeadProperty : this.context.getExcelHeadProperty().getColumnPropertyList()) {
            Cell cell = row.createCell(i);
            BaseRowModel baseRowModel = (BaseRowModel)oneRowData;
            if (baseRowModel.getStyle(i) != null) {
                cell.setCellStyle(baseRowModel.getStyle(i));
            } else {
                cell.setCellStyle(this.context.getCurrentContentStyle());
            }
            String cellValue = null;
            try {
                Object value = BeanUtilsBean.getInstance().getPropertyUtils().getNestedProperty(oneRowData, excelHeadProperty.getField().getName());
                cellValue = value instanceof Date ? TypeUtil.formatDate((Date)value, excelHeadProperty.getFormat()) : BeanUtilsBean.getInstance().getConvertUtils().convert(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (TypeUtil.isNotEmpty(cellValue).booleanValue()) {
                if (TypeUtil.isNum(excelHeadProperty.getField()).booleanValue()) {
                    cell.setCellValue(Double.parseDouble(cellValue));
                } else {
                    cell.setCellValue(cellValue);
                }
            } else {
                cell.setCellValue("");
            }
            ++i;
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n) {
        Row row = this.context.getCurrentSheet().createRow(n);
        if (oneRowData instanceof List) {
            this.addOneRowOfDataToExcel((List)oneRowData, row);
        } else {
            this.addOneRowOfDataToExcel(oneRowData, row);
        }
    }
}

