/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.format.NumberFormat;
import com.alibaba.excel.annotation.write.style.ContentFontStyle;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.converters.AutoConverter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.exception.ExcelCommonException;
import com.alibaba.excel.metadata.ConfigurationHolder;
import com.alibaba.excel.metadata.FieldCache;
import com.alibaba.excel.metadata.FieldWrapper;
import com.alibaba.excel.metadata.property.DateTimeFormatProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.metadata.property.FontProperty;
import com.alibaba.excel.metadata.property.NumberFormatProperty;
import com.alibaba.excel.metadata.property.StyleProperty;
import com.alibaba.excel.support.cglib.beans.BeanMap;
import com.alibaba.excel.util.FieldUtils;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.util.MapUtils;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;

public class ClassUtils {
    public static final ConcurrentHashMap<Class<?>, FieldCache> FIELD_CACHE = new ConcurrentHashMap();
    private static final ThreadLocal<Map<Class<?>, FieldCache>> FIELD_THREAD_LOCAL = new ThreadLocal();
    public static final ConcurrentHashMap<Class<?>, Map<String, ExcelContentProperty>> CLASS_CONTENT_CACHE = new ConcurrentHashMap();
    private static final ThreadLocal<Map<Class<?>, Map<String, ExcelContentProperty>>> CLASS_CONTENT_THREAD_LOCAL = new ThreadLocal();
    public static final ConcurrentHashMap<ContentPropertyKey, ExcelContentProperty> CONTENT_CACHE = new ConcurrentHashMap();
    private static final ThreadLocal<Map<ContentPropertyKey, ExcelContentProperty>> CONTENT_THREAD_LOCAL = new ThreadLocal();

    public static ExcelContentProperty declaredExcelContentProperty(Map<?, ?> dataMap, Class<?> headClazz, String fieldName, ConfigurationHolder configurationHolder) {
        Object bean;
        Class<?> clazz = null;
        if (dataMap instanceof BeanMap && (bean = ((BeanMap)dataMap).getBean()) != null) {
            clazz = bean.getClass();
        }
        return ClassUtils.getExcelContentProperty(clazz, headClazz, fieldName, configurationHolder);
    }

    private static ExcelContentProperty getExcelContentProperty(Class<?> clazz, Class<?> headClass, String fieldName, ConfigurationHolder configurationHolder) {
        switch (configurationHolder.globalConfiguration().getFiledCacheLocation()) {
            case THREAD_LOCAL: {
                Map<ContentPropertyKey, ExcelContentProperty> contentCacheMap = CONTENT_THREAD_LOCAL.get();
                if (contentCacheMap == null) {
                    contentCacheMap = MapUtils.newHashMap();
                    CONTENT_THREAD_LOCAL.set(contentCacheMap);
                }
                return contentCacheMap.computeIfAbsent(ClassUtils.buildKey(clazz, headClass, fieldName), key -> ClassUtils.doGetExcelContentProperty(clazz, headClass, fieldName, configurationHolder));
            }
            case MEMORY: {
                return CONTENT_CACHE.computeIfAbsent(ClassUtils.buildKey(clazz, headClass, fieldName), key -> ClassUtils.doGetExcelContentProperty(clazz, headClass, fieldName, configurationHolder));
            }
            case NONE: {
                return ClassUtils.doGetExcelContentProperty(clazz, headClass, fieldName, configurationHolder);
            }
        }
        throw new UnsupportedOperationException("unsupported enum");
    }

    private static ExcelContentProperty doGetExcelContentProperty(Class<?> clazz, Class<?> headClass, String fieldName, ConfigurationHolder configurationHolder) {
        ExcelContentProperty excelContentProperty = Optional.ofNullable(ClassUtils.declaredFieldContentMap(clazz, configurationHolder)).map(map -> (ExcelContentProperty)map.get(fieldName)).orElse(null);
        ExcelContentProperty headExcelContentProperty = Optional.ofNullable(ClassUtils.declaredFieldContentMap(headClass, configurationHolder)).map(map -> (ExcelContentProperty)map.get(fieldName)).orElse(null);
        ExcelContentProperty combineExcelContentProperty = new ExcelContentProperty();
        ClassUtils.combineExcelContentProperty(combineExcelContentProperty, headExcelContentProperty);
        if (clazz != headClass) {
            ClassUtils.combineExcelContentProperty(combineExcelContentProperty, excelContentProperty);
        }
        return combineExcelContentProperty;
    }

    public static void combineExcelContentProperty(ExcelContentProperty combineExcelContentProperty, ExcelContentProperty excelContentProperty) {
        if (excelContentProperty == null) {
            return;
        }
        if (excelContentProperty.getField() != null) {
            combineExcelContentProperty.setField(excelContentProperty.getField());
        }
        if (excelContentProperty.getConverter() != null) {
            combineExcelContentProperty.setConverter(excelContentProperty.getConverter());
        }
        if (excelContentProperty.getDateTimeFormatProperty() != null) {
            combineExcelContentProperty.setDateTimeFormatProperty(excelContentProperty.getDateTimeFormatProperty());
        }
        if (excelContentProperty.getNumberFormatProperty() != null) {
            combineExcelContentProperty.setNumberFormatProperty(excelContentProperty.getNumberFormatProperty());
        }
        if (excelContentProperty.getContentStyleProperty() != null) {
            combineExcelContentProperty.setContentStyleProperty(excelContentProperty.getContentStyleProperty());
        }
        if (excelContentProperty.getContentFontProperty() != null) {
            combineExcelContentProperty.setContentFontProperty(excelContentProperty.getContentFontProperty());
        }
    }

    private static ContentPropertyKey buildKey(Class<?> clazz, Class<?> headClass, String fieldName) {
        return new ContentPropertyKey(clazz, headClass, fieldName);
    }

    private static Map<String, ExcelContentProperty> declaredFieldContentMap(Class<?> clazz, ConfigurationHolder configurationHolder) {
        if (clazz == null) {
            return null;
        }
        switch (configurationHolder.globalConfiguration().getFiledCacheLocation()) {
            case THREAD_LOCAL: {
                Map<Class<?>, Map<String, ExcelContentProperty>> classContentCacheMap = CLASS_CONTENT_THREAD_LOCAL.get();
                if (classContentCacheMap == null) {
                    classContentCacheMap = MapUtils.newHashMap();
                    CLASS_CONTENT_THREAD_LOCAL.set(classContentCacheMap);
                }
                return classContentCacheMap.computeIfAbsent(clazz, key -> ClassUtils.doDeclaredFieldContentMap(clazz));
            }
            case MEMORY: {
                return CLASS_CONTENT_CACHE.computeIfAbsent(clazz, key -> ClassUtils.doDeclaredFieldContentMap(clazz));
            }
            case NONE: {
                return ClassUtils.doDeclaredFieldContentMap(clazz);
            }
        }
        throw new UnsupportedOperationException("unsupported enum");
    }

    private static Map<String, ExcelContentProperty> doDeclaredFieldContentMap(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        ArrayList tempFieldList = new ArrayList();
        for (Class<?> tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            Collections.addAll(tempFieldList, tempClass.getDeclaredFields());
        }
        ContentStyle parentContentStyle = clazz.getAnnotation(ContentStyle.class);
        ContentFontStyle parentContentFontStyle = clazz.getAnnotation(ContentFontStyle.class);
        HashMap<String, ExcelContentProperty> fieldContentMap = MapUtils.newHashMapWithExpectedSize(tempFieldList.size());
        for (Field field : tempFieldList) {
            ContentStyle contentStyle;
            Class<Converter<?>> convertClazz;
            ExcelContentProperty excelContentProperty = new ExcelContentProperty();
            excelContentProperty.setField(field);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty != null && (convertClazz = excelProperty.converter()) != AutoConverter.class) {
                try {
                    Converter<?> converter = convertClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    excelContentProperty.setConverter(converter);
                }
                catch (Exception e) {
                    throw new ExcelCommonException("Can not instance custom converter:" + convertClazz.getName());
                }
            }
            if ((contentStyle = field.getAnnotation(ContentStyle.class)) == null) {
                contentStyle = parentContentStyle;
            }
            excelContentProperty.setContentStyleProperty(StyleProperty.build(contentStyle));
            ContentFontStyle contentFontStyle = field.getAnnotation(ContentFontStyle.class);
            if (contentFontStyle == null) {
                contentFontStyle = parentContentFontStyle;
            }
            excelContentProperty.setContentFontProperty(FontProperty.build(contentFontStyle));
            excelContentProperty.setDateTimeFormatProperty(DateTimeFormatProperty.build(field.getAnnotation(DateTimeFormat.class)));
            excelContentProperty.setNumberFormatProperty(NumberFormatProperty.build(field.getAnnotation(NumberFormat.class)));
            fieldContentMap.put(field.getName(), excelContentProperty);
        }
        return fieldContentMap;
    }

    public static FieldCache declaredFields(Class<?> clazz, ConfigurationHolder configurationHolder) {
        switch (configurationHolder.globalConfiguration().getFiledCacheLocation()) {
            case THREAD_LOCAL: {
                Map<Class<?>, FieldCache> fieldCacheMap = FIELD_THREAD_LOCAL.get();
                if (fieldCacheMap == null) {
                    fieldCacheMap = MapUtils.newHashMap();
                    FIELD_THREAD_LOCAL.set(fieldCacheMap);
                }
                return fieldCacheMap.computeIfAbsent(clazz, key -> ClassUtils.doDeclaredFields(clazz, configurationHolder));
            }
            case MEMORY: {
                return FIELD_CACHE.computeIfAbsent(clazz, key -> ClassUtils.doDeclaredFields(clazz, configurationHolder));
            }
            case NONE: {
                return ClassUtils.doDeclaredFields(clazz, configurationHolder);
            }
        }
        throw new UnsupportedOperationException("unsupported enum");
    }

    private static FieldCache doDeclaredFields(Class<?> clazz, ConfigurationHolder configurationHolder) {
        boolean needIgnore;
        ArrayList tempFieldList = new ArrayList();
        for (Class<?> tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            Collections.addAll(tempFieldList, tempClass.getDeclaredFields());
        }
        TreeMap<Integer, List<FieldWrapper>> orderFieldMap = new TreeMap<Integer, List<FieldWrapper>>();
        TreeMap<Integer, FieldWrapper> indexFieldMap = new TreeMap<Integer, FieldWrapper>();
        HashSet<String> ignoreSet = new HashSet<String>();
        ExcelIgnoreUnannotated excelIgnoreUnannotated = clazz.getAnnotation(ExcelIgnoreUnannotated.class);
        for (Field field : tempFieldList) {
            ClassUtils.declaredOneField(field, orderFieldMap, indexFieldMap, ignoreSet, excelIgnoreUnannotated);
        }
        Map<Integer, FieldWrapper> sortedFieldMap = ClassUtils.buildSortedAllFieldMap(orderFieldMap, indexFieldMap);
        FieldCache fieldCache = new FieldCache(sortedFieldMap, indexFieldMap);
        if (!(configurationHolder instanceof WriteHolder)) {
            return fieldCache;
        }
        WriteHolder writeHolder = (WriteHolder)configurationHolder;
        boolean bl = needIgnore = !CollectionUtils.isEmpty(writeHolder.excludeColumnFieldNames()) || !CollectionUtils.isEmpty(writeHolder.excludeColumnIndexes()) || !CollectionUtils.isEmpty(writeHolder.includeColumnFieldNames()) || !CollectionUtils.isEmpty(writeHolder.includeColumnIndexes());
        if (!needIgnore) {
            return fieldCache;
        }
        HashMap<Integer, FieldWrapper> tempSortedFieldMapp = MapUtils.newHashMap();
        int index = 0;
        for (Map.Entry<Integer, FieldWrapper> entry : sortedFieldMap.entrySet()) {
            Integer key = entry.getKey();
            FieldWrapper field = entry.getValue();
            if (writeHolder.ignore(field.getFieldName(), entry.getKey())) {
                if (ignoreSet != null) {
                    ignoreSet.add(field.getFieldName());
                }
                indexFieldMap.remove(index);
                continue;
            }
            if (ignoreSet.contains(key)) {
                tempSortedFieldMapp.put(key, field);
                continue;
            }
            while (tempSortedFieldMapp.containsKey(index)) {
                ++index;
            }
            tempSortedFieldMapp.put(index++, field);
        }
        fieldCache.setSortedFieldMap(tempSortedFieldMapp);
        ClassUtils.resortField(writeHolder, fieldCache);
        return fieldCache;
    }

    private static void resortField(WriteHolder writeHolder, FieldCache fieldCache) {
        if (!writeHolder.orderByIncludeColumn()) {
            return;
        }
        Map<Integer, FieldWrapper> indexFieldMap = fieldCache.getIndexFieldMap();
        Collection<String> includeColumnFieldNames = writeHolder.includeColumnFieldNames();
        if (!CollectionUtils.isEmpty(includeColumnFieldNames)) {
            HashMap<String, Integer> filedIndexMap = MapUtils.newHashMap();
            int fieldIndex = 0;
            for (String includeColumnFieldName : includeColumnFieldNames) {
                filedIndexMap.put(includeColumnFieldName, fieldIndex++);
            }
            HashMap<Integer, FieldWrapper> tempSortedFieldMap = MapUtils.newHashMap();
            fieldCache.getSortedFieldMap().forEach((index, field) -> {
                Integer tempFieldIndex = (Integer)filedIndexMap.get(field.getFieldName());
                if (tempFieldIndex != null) {
                    tempSortedFieldMap.put(tempFieldIndex, (FieldWrapper)field);
                    if (!tempFieldIndex.equals(index)) {
                        indexFieldMap.remove(index);
                    }
                }
            });
            fieldCache.setSortedFieldMap(tempSortedFieldMap);
            return;
        }
        Collection<Integer> includeColumnIndexes = writeHolder.includeColumnIndexes();
        if (!CollectionUtils.isEmpty(includeColumnIndexes)) {
            HashMap<Integer, Integer> filedIndexMap = MapUtils.newHashMap();
            int fieldIndex = 0;
            for (Integer includeColumnIndexe : includeColumnIndexes) {
                filedIndexMap.put(includeColumnIndexe, fieldIndex++);
            }
            HashMap<Integer, FieldWrapper> tempSortedFieldMap = MapUtils.newHashMap();
            fieldCache.getSortedFieldMap().forEach((index, field) -> {
                Integer tempFieldIndex = (Integer)filedIndexMap.get(index);
                if (tempFieldIndex != null) {
                    tempSortedFieldMap.put(tempFieldIndex, (FieldWrapper)field);
                }
            });
            fieldCache.setSortedFieldMap(tempSortedFieldMap);
        }
    }

    private static Map<Integer, FieldWrapper> buildSortedAllFieldMap(Map<Integer, List<FieldWrapper>> orderFieldMap, Map<Integer, FieldWrapper> indexFieldMap) {
        HashMap<Integer, FieldWrapper> sortedAllFieldMap = new HashMap<Integer, FieldWrapper>((orderFieldMap.size() + indexFieldMap.size()) * 4 / 3 + 1);
        HashMap<Integer, FieldWrapper> tempIndexFieldMap = new HashMap<Integer, FieldWrapper>(indexFieldMap);
        int index = 0;
        for (List<FieldWrapper> fieldList : orderFieldMap.values()) {
            for (FieldWrapper field : fieldList) {
                while (tempIndexFieldMap.containsKey(index)) {
                    sortedAllFieldMap.put(index, (FieldWrapper)tempIndexFieldMap.get(index));
                    tempIndexFieldMap.remove(index);
                    ++index;
                }
                sortedAllFieldMap.put(index, field);
                ++index;
            }
        }
        sortedAllFieldMap.putAll(tempIndexFieldMap);
        return sortedAllFieldMap;
    }

    private static void declaredOneField(Field field, Map<Integer, List<FieldWrapper>> orderFieldMap, Map<Integer, FieldWrapper> indexFieldMap, Set<String> ignoreSet, ExcelIgnoreUnannotated excelIgnoreUnannotated) {
        boolean isStaticFinalOrTransient;
        boolean noExcelProperty;
        String fieldName = FieldUtils.resolveCglibFieldName(field);
        FieldWrapper fieldWrapper = new FieldWrapper();
        fieldWrapper.setField(field);
        fieldWrapper.setFieldName(fieldName);
        ExcelIgnore excelIgnore = field.getAnnotation(ExcelIgnore.class);
        if (excelIgnore != null) {
            ignoreSet.add(fieldName);
            return;
        }
        ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
        boolean bl = noExcelProperty = excelProperty == null && excelIgnoreUnannotated != null;
        if (noExcelProperty) {
            ignoreSet.add(fieldName);
            return;
        }
        boolean bl2 = isStaticFinalOrTransient = Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
        if (excelProperty == null && isStaticFinalOrTransient) {
            ignoreSet.add(fieldName);
            return;
        }
        if (excelProperty != null) {
            fieldWrapper.setHeads(excelProperty.value());
        }
        if (excelProperty != null && excelProperty.index() >= 0) {
            if (indexFieldMap.containsKey(excelProperty.index())) {
                throw new ExcelCommonException("The index of '" + indexFieldMap.get(excelProperty.index()).getFieldName() + "' and '" + field.getName() + "' must be inconsistent");
            }
            indexFieldMap.put(excelProperty.index(), fieldWrapper);
            return;
        }
        int order = Integer.MAX_VALUE;
        if (excelProperty != null) {
            order = excelProperty.order();
        }
        List orderFieldList = orderFieldMap.computeIfAbsent(order, key -> ListUtils.newArrayList());
        orderFieldList.add(fieldWrapper);
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ClassUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                ClassUtils.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static void removeThreadLocalCache() {
        FIELD_THREAD_LOCAL.remove();
        CLASS_CONTENT_THREAD_LOCAL.remove();
        CONTENT_THREAD_LOCAL.remove();
    }

    public static class ContentPropertyKey {
        private Class<?> clazz;
        private Class<?> headClass;
        private String fieldName;

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Class<?> getHeadClass() {
            return this.headClass;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setHeadClass(Class<?> headClass) {
            this.headClass = headClass;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentPropertyKey)) {
                return false;
            }
            ContentPropertyKey other = (ContentPropertyKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            Class<?> this$headClass = this.getHeadClass();
            Class<?> other$headClass = other.getHeadClass();
            if (this$headClass == null ? other$headClass != null : !this$headClass.equals(other$headClass)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContentPropertyKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            Class<?> $headClass = this.getHeadClass();
            result = result * 59 + ($headClass == null ? 43 : $headClass.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            return result;
        }

        public ContentPropertyKey(Class<?> clazz, Class<?> headClass, String fieldName) {
            this.clazz = clazz;
            this.headClass = headClass;
            this.fieldName = fieldName;
        }
    }
}

