/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.dubbo.config.spring.util.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

class AnnotationBeanNameBuilder {
    private static final String SEPARATOR = ":";
    private final String category;
    private final String protocol;
    private final String interfaceClassName;
    private String version;
    private String group;
    private Environment environment;

    private AnnotationBeanNameBuilder(String category, String protocol, String interfaceClassName) {
        this.category = category;
        this.protocol = protocol;
        this.interfaceClassName = interfaceClassName;
    }

    private AnnotationBeanNameBuilder(Service service, Class<?> interfaceClass) {
        this("providers", AnnotationBeanNameBuilder.resolveProtocol(service.protocol()), AnnotationUtils.resolveInterfaceName(service, interfaceClass));
        this.group(service.group());
        this.version(service.version());
    }

    private AnnotationBeanNameBuilder(Reference reference, Class<?> interfaceClass) {
        this("consumers", AnnotationBeanNameBuilder.resolveProtocol(reference.protocol()), AnnotationUtils.resolveInterfaceName(reference, interfaceClass));
        this.group(reference.group());
        this.version(reference.version());
    }

    public static AnnotationBeanNameBuilder create(Service service, Class<?> interfaceClass) {
        return new AnnotationBeanNameBuilder(service, interfaceClass);
    }

    public static AnnotationBeanNameBuilder create(Reference reference, Class<?> interfaceClass) {
        return new AnnotationBeanNameBuilder(reference, interfaceClass);
    }

    private static void append(StringBuilder builder, String value) {
        if (StringUtils.hasText((String)value)) {
            builder.append(SEPARATOR).append(value);
        }
    }

    public AnnotationBeanNameBuilder group(String group) {
        this.group = group;
        return this;
    }

    public AnnotationBeanNameBuilder version(String version) {
        this.version = version;
        return this;
    }

    public AnnotationBeanNameBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    private static String resolveProtocol(String ... protocols) {
        String protocol = StringUtils.arrayToCommaDelimitedString((Object[])protocols);
        return StringUtils.hasText((String)protocol) ? protocol : "dubbo";
    }

    public String build() {
        StringBuilder beanNameBuilder = new StringBuilder(this.category);
        AnnotationBeanNameBuilder.append(beanNameBuilder, this.protocol);
        AnnotationBeanNameBuilder.append(beanNameBuilder, this.interfaceClassName);
        AnnotationBeanNameBuilder.append(beanNameBuilder, this.version);
        AnnotationBeanNameBuilder.append(beanNameBuilder, this.group);
        String beanName = beanNameBuilder.toString();
        return this.environment != null ? this.environment.resolvePlaceholders(beanName) : beanName;
    }
}

