/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.netty4.logging;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.remoting.transport.netty4.logging.FormattingTuple;
import com.alibaba.dubbo.remoting.transport.netty4.logging.MessageFormatter;
import io.netty.util.internal.logging.AbstractInternalLogger;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class NettyHelper {
    public static void setNettyLoggerFactory() {
        InternalLoggerFactory factory = InternalLoggerFactory.getDefaultFactory();
        if (factory == null || !(factory instanceof DubboLoggerFactory)) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new DubboLoggerFactory());
        }
    }

    static class DubboLogger
    extends AbstractInternalLogger {
        private Logger logger;

        DubboLogger(Logger logger) {
            super(logger.getClass().getName());
            this.logger = logger;
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        public void trace(String msg) {
            if (this.isTraceEnabled()) {
                this.logger.trace(msg);
            }
        }

        public void trace(String format, Object arg) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.logger.trace(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String format, Object argA, Object argB) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.logger.trace(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String format, Object ... arguments) {
            if (this.isTraceEnabled()) {
                FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
                this.logger.trace(ft.getMessage(), ft.getThrowable());
            }
        }

        public void trace(String msg, Throwable t) {
            if (this.isTraceEnabled()) {
                this.logger.trace(msg, t);
            }
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String msg) {
            if (this.isDebugEnabled()) {
                this.logger.debug(msg);
            }
        }

        public void debug(String format, Object arg) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.logger.debug(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String format, Object argA, Object argB) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.logger.debug(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String format, Object ... arguments) {
            if (this.isDebugEnabled()) {
                FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
                this.logger.debug(ft.getMessage(), ft.getThrowable());
            }
        }

        public void debug(String msg, Throwable t) {
            if (this.isDebugEnabled()) {
                this.logger.debug(msg, t);
            }
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public void info(String msg) {
            if (this.isInfoEnabled()) {
                this.logger.info(msg);
            }
        }

        public void info(String format, Object arg) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.logger.info(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String format, Object argA, Object argB) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.logger.info(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String format, Object ... arguments) {
            if (this.isInfoEnabled()) {
                FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
                this.logger.info(ft.getMessage(), ft.getThrowable());
            }
        }

        public void info(String msg, Throwable t) {
            if (this.isInfoEnabled()) {
                this.logger.info(msg, t);
            }
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void warn(String msg) {
            if (this.isWarnEnabled()) {
                this.logger.warn(msg);
            }
        }

        public void warn(String format, Object arg) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.logger.warn(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String format, Object ... arguments) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
                this.logger.warn(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String format, Object argA, Object argB) {
            if (this.isWarnEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.logger.warn(ft.getMessage(), ft.getThrowable());
            }
        }

        public void warn(String msg, Throwable t) {
            if (this.isWarnEnabled()) {
                this.logger.warn(msg, t);
            }
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public void error(String msg) {
            if (this.isErrorEnabled()) {
                this.logger.error(msg);
            }
        }

        public void error(String format, Object arg) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, arg);
                this.logger.error(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String format, Object argA, Object argB) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.format(format, argA, argB);
                this.logger.error(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String format, Object ... arguments) {
            if (this.isErrorEnabled()) {
                FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
                this.logger.error(ft.getMessage(), ft.getThrowable());
            }
        }

        public void error(String msg, Throwable t) {
            if (this.isErrorEnabled()) {
                this.logger.error(msg, t);
            }
        }
    }

    static class DubboLoggerFactory
    extends InternalLoggerFactory {
        DubboLoggerFactory() {
        }

        public InternalLogger newInstance(String name) {
            return new DubboLogger(LoggerFactory.getLogger(name));
        }
    }
}

