/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.nacos;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.registry.support.Registration;
import com.alibaba.dubbo.registry.support.ServiceInstanceRegistry;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NacosRegistry
extends ServiceInstanceRegistry<Instance> {
    private static final int PAGINATION_SIZE = Integer.getInteger("nacos.service.names.pagination.size", 100);
    private final NamingService namingService;
    private final ConcurrentMap<String, EventListener> nacosListeners;

    public NacosRegistry(URL url, NamingService namingService) {
        super(url);
        this.namingService = namingService;
        this.nacosListeners = new ConcurrentHashMap<String, EventListener>();
    }

    protected Instance toServiceInstance(Registration registration) {
        Instance instance = new Instance();
        instance.setServiceName(registration.getServiceName());
        instance.setIp(registration.getIp());
        instance.setPort(registration.getPort());
        instance.setMetadata(registration.getMetadata());
        return instance;
    }

    protected Registration toRegistration(final Instance serviceInstance) {
        return new Registration(){

            public String getServiceName() {
                return serviceInstance.getServiceName();
            }

            public String getIp() {
                return serviceInstance.getIp();
            }

            public int getPort() {
                return serviceInstance.getPort();
            }

            public Map<String, String> getMetadata() {
                return serviceInstance.getMetadata();
            }
        };
    }

    protected void register(final String serviceName, final Instance serviceInstance, URL url) {
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                namingService.registerInstance(serviceName, serviceInstance);
            }
        });
    }

    protected void deregister(final String serviceName, final Instance serviceInstance, URL url) {
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                namingService.deregisterInstance(serviceName, serviceInstance.getIp(), serviceInstance.getPort());
            }
        });
    }

    protected Collection<Instance> findServiceInstances(final String serviceName) {
        final LinkedList<Instance> instances = new LinkedList<Instance>();
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                instances.addAll(namingService.getAllInstances(serviceName));
            }
        });
        return instances;
    }

    protected boolean filterHealthyRegistration(Instance serviceInstance) {
        return serviceInstance.isEnabled();
    }

    protected Set<String> findAllServiceNames() {
        final LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                int pageIndex = 1;
                ListView listView = namingService.getServicesOfServer(pageIndex, PAGINATION_SIZE);
                List firstPageData = listView.getData();
                serviceNames.addAll(firstPageData);
                int count = listView.getCount();
                int pageNumbers = count / PAGINATION_SIZE;
                int remainder = count % PAGINATION_SIZE;
                if (remainder > 0) {
                    ++pageNumbers;
                }
                while (pageIndex < pageNumbers) {
                    listView = namingService.getServicesOfServer(++pageIndex, PAGINATION_SIZE);
                    serviceNames.addAll(listView.getData());
                }
            }
        });
        return serviceNames;
    }

    public boolean isAvailable() {
        return "UP".equals(this.namingService.getServerStatus());
    }

    private void execute(NamingServiceCallback callback) {
        block2: {
            try {
                callback.callback(this.namingService);
            }
            catch (NacosException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getErrMsg(), (Throwable)e);
            }
        }
    }

    static interface NamingServiceCallback {
        public void callback(NamingService var1) throws NacosException;
    }
}

