/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.DbType;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.HexBin;
import com.alibaba.druid.util.JdbcConstants;
import com.alibaba.druid.util.MySqlUtils;
import com.alibaba.druid.util.OracleUtils;
import com.alibaba.druid.util.PGUtils;
import com.alibaba.druid.util.ResultSetConsumer;
import com.alibaba.druid.util.Utils;
import java.io.Closeable;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class JdbcUtils
implements JdbcConstants {
    private static final Log LOG;
    private static final Properties DRIVER_URL_MAPPING;
    private static Boolean mysql_driver_version_6;

    public static void close(Connection x) {
        if (x == null) {
            return;
        }
        try {
            if (x.isClosed()) {
                return;
            }
            x.close();
        }
        catch (SQLRecoverableException sQLRecoverableException) {
        }
        catch (Exception e) {
            LOG.debug("close connection error", e);
        }
    }

    public static void close(Statement x) {
        block4: {
            if (x == null) {
                return;
            }
            try {
                x.close();
            }
            catch (Exception e) {
                boolean printError = true;
                if (e instanceof SQLRecoverableException && "Closed Connection".equals(e.getMessage())) {
                    printError = false;
                }
                if (!printError) break block4;
                LOG.debug("close statement error", e);
            }
        }
    }

    public static void close(ResultSet x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception e) {
            LOG.debug("close result set error", e);
        }
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception e) {
            LOG.debug("close error", e);
        }
    }

    public static void close(Blob x) {
        if (x == null) {
            return;
        }
        try {
            x.free();
        }
        catch (Exception e) {
            LOG.debug("close error", e);
        }
    }

    public static void close(Clob x) {
        if (x == null) {
            return;
        }
        try {
            x.free();
        }
        catch (Exception e) {
            LOG.debug("close error", e);
        }
    }

    public static void printResultSet(ResultSet rs) throws SQLException {
        JdbcUtils.printResultSet(rs, System.out);
    }

    public static void printResultSet(ResultSet rs, PrintStream out) throws SQLException {
        JdbcUtils.printResultSet(rs, out, true, "\t");
    }

    public static void printResultSet(ResultSet rs, PrintStream out, boolean printHeader, String seperator) throws SQLException {
        int columnIndex;
        ResultSetMetaData metadata = rs.getMetaData();
        int columnCount = metadata.getColumnCount();
        if (printHeader) {
            for (columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                if (columnIndex != 1) {
                    out.print(seperator);
                }
                out.print(metadata.getColumnName(columnIndex));
            }
        }
        out.println();
        while (rs.next()) {
            for (columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                Object object;
                int type;
                if (columnIndex != 1) {
                    out.print(seperator);
                }
                if ((type = metadata.getColumnType(columnIndex)) == 12 || type == 1 || type == -9 || type == -15) {
                    out.print(rs.getString(columnIndex));
                    continue;
                }
                if (type == 91) {
                    Date date = rs.getDate(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(date.toString());
                    continue;
                }
                if (type == -7) {
                    boolean value = rs.getBoolean(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Boolean.toString(value));
                    continue;
                }
                if (type == 16) {
                    boolean value = rs.getBoolean(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Boolean.toString(value));
                    continue;
                }
                if (type == -6) {
                    byte value = rs.getByte(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Byte.toString(value));
                    continue;
                }
                if (type == 5) {
                    short value = rs.getShort(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Short.toString(value));
                    continue;
                }
                if (type == 4) {
                    int value = rs.getInt(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Integer.toString(value));
                    continue;
                }
                if (type == -5) {
                    long value = rs.getLong(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Long.toString(value));
                    continue;
                }
                if (type == 93 || type == 2014) {
                    out.print(String.valueOf(rs.getTimestamp(columnIndex)));
                    continue;
                }
                if (type == 3) {
                    out.print(String.valueOf(rs.getBigDecimal(columnIndex)));
                    continue;
                }
                if (type == 2005) {
                    out.print(String.valueOf(rs.getString(columnIndex)));
                    continue;
                }
                if (type == 2000) {
                    object = rs.getObject(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(String.valueOf(object));
                    continue;
                }
                if (type == -1) {
                    object = rs.getString(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(String.valueOf(object));
                    continue;
                }
                if (type == 0) {
                    out.print("null");
                    continue;
                }
                object = rs.getObject(columnIndex);
                if (rs.wasNull()) {
                    out.print("null");
                    continue;
                }
                if (object instanceof byte[]) {
                    byte[] bytes = (byte[])object;
                    String text = HexBin.encode(bytes);
                    out.print(text);
                    continue;
                }
                out.print(String.valueOf(object));
            }
            out.println();
        }
    }

    public static String getTypeName(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -15: {
                return "NCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2014: {
                return "TIMESTAMP_WITH_TIMEZONE";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "OTHER";
    }

    public static String getDriverClassName(String rawUrl) throws SQLException {
        if (rawUrl == null) {
            return null;
        }
        if (rawUrl.startsWith("jdbc:derby:")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        if (rawUrl.startsWith("jdbc:mysql:")) {
            if (mysql_driver_version_6 == null) {
                mysql_driver_version_6 = Utils.loadClass("com.mysql.cj.jdbc.Driver") != null;
            }
            if (mysql_driver_version_6.booleanValue()) {
                return "com.mysql.cj.jdbc.Driver";
            }
            return "com.mysql.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:log4jdbc:")) {
            return "net.sf.log4jdbc.DriverSpy";
        }
        if (rawUrl.startsWith("jdbc:mariadb:")) {
            return "org.mariadb.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:tidb:")) {
            return "io.tidb.bigdata.jdbc.TiDBDriver";
        }
        if (rawUrl.startsWith("jdbc:oracle:") || rawUrl.startsWith("JDBC:oracle:")) {
            return "oracle.jdbc.OracleDriver";
        }
        if (rawUrl.startsWith("jdbc:alibaba:oracle:")) {
            return "com.alibaba.jdbc.AlibabaDriver";
        }
        if (rawUrl.startsWith("jdbc:oceanbase:")) {
            return "com.alipay.oceanbase.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:microsoft:")) {
            return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        }
        if (rawUrl.startsWith("jdbc:sqlserver:")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (rawUrl.startsWith("jdbc:sybase:Tds:")) {
            return "com.sybase.jdbc2.jdbc.SybDriver";
        }
        if (rawUrl.startsWith("jdbc:jtds:")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:fake:") || rawUrl.startsWith("jdbc:mock:")) {
            return "com.alibaba.druid.mock.MockDriver";
        }
        if (rawUrl.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        if (rawUrl.startsWith("jdbc:edb:")) {
            return "com.edb.Driver";
        }
        if (rawUrl.startsWith("jdbc:odps:")) {
            return "com.aliyun.odps.jdbc.OdpsDriver";
        }
        if (rawUrl.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbcDriver";
        }
        if (rawUrl.startsWith("jdbc:db2:")) {
            String prefix = "jdbc:db2:";
            if (rawUrl.startsWith(prefix + "//")) {
                return "com.ibm.db2.jcc.DB2Driver";
            }
            String suffix = rawUrl.substring(prefix.length());
            if (suffix.indexOf(58) > 0) {
                return "COM.ibm.db2.jdbc.net.DB2Driver";
            }
            return "COM.ibm.db2.jdbc.app.DB2Driver";
        }
        if (rawUrl.startsWith("jdbc:sqlite:")) {
            return "org.sqlite.JDBC";
        }
        if (rawUrl.startsWith("jdbc:ingres:")) {
            return "com.ingres.jdbc.IngresDriver";
        }
        if (rawUrl.startsWith("jdbc:h2:")) {
            return "org.h2.Driver";
        }
        if (rawUrl.startsWith("jdbc:mckoi:")) {
            return "com.mckoi.JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:cloudscape:")) {
            return "COM.cloudscape.core.JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:informix-sqli:")) {
            return "com.informix.jdbc.IfxDriver";
        }
        if (rawUrl.startsWith("jdbc:timesten:")) {
            return "com.timesten.jdbc.TimesTenDriver";
        }
        if (rawUrl.startsWith("jdbc:as400:")) {
            return "com.ibm.as400.access.AS400JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:sapdb:")) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }
        if (rawUrl.startsWith("jdbc:JSQLConnect:")) {
            return "com.jnetdirect.jsql.JSQLDriver";
        }
        if (rawUrl.startsWith("jdbc:JTurbo:")) {
            return "com.newatlanta.jturbo.driver.Driver";
        }
        if (rawUrl.startsWith("jdbc:firebirdsql:")) {
            return "org.firebirdsql.jdbc.FBDriver";
        }
        if (rawUrl.startsWith("jdbc:interbase:")) {
            return "interbase.interclient.Driver";
        }
        if (rawUrl.startsWith("jdbc:pointbase:")) {
            return "com.pointbase.jdbc.jdbcUniversalDriver";
        }
        if (rawUrl.startsWith("jdbc:edbc:")) {
            return "ca.edbc.jdbc.EdbcDriver";
        }
        if (rawUrl.startsWith("jdbc:mimer:multi1:")) {
            return "com.mimer.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:dm:")) {
            return "dm.jdbc.driver.DmDriver";
        }
        if (rawUrl.startsWith("jdbc:kingbase:")) {
            return "com.kingbase.Driver";
        }
        if (rawUrl.startsWith("jdbc:kingbase8:")) {
            return "com.kingbase8.Driver";
        }
        if (rawUrl.startsWith("jdbc:gbase:")) {
            return "com.gbase.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:xugu:")) {
            return "com.xugu.cloudjdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:hive:")) {
            return "org.apache.hive.jdbc.HiveDriver";
        }
        if (rawUrl.startsWith("jdbc:hive2:")) {
            return "org.apache.hive.jdbc.HiveDriver";
        }
        if (rawUrl.startsWith("jdbc:phoenix:thin:")) {
            return "org.apache.phoenix.queryserver.client.Driver";
        }
        if (rawUrl.startsWith("jdbc:phoenix://")) {
            return "org.apache.phoenix.jdbc.PhoenixDriver";
        }
        if (rawUrl.startsWith("jdbc:kylin:")) {
            return "org.apache.kylin.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:elastic:")) {
            return "com.alibaba.xdriver.elastic.jdbc.ElasticDriver";
        }
        if (rawUrl.startsWith("jdbc:clickhouse:")) {
            return "ru.yandex.clickhouse.ClickHouseDriver";
        }
        if (rawUrl.startsWith("jdbc:presto:")) {
            return "com.facebook.presto.jdbc.PrestoDriver";
        }
        if (rawUrl.startsWith("jdbc:trino:")) {
            return "io.trino.jdbc.TrinoDriver";
        }
        if (rawUrl.startsWith("jdbc:inspur:")) {
            return "com.inspur.jdbc.KdDriver";
        }
        if (rawUrl.startsWith("jdbc:polardb")) {
            return "com.aliyun.polardb.Driver";
        }
        if (rawUrl.startsWith("jdbc:highgo:")) {
            return "com.highgo.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:oscar")) {
            return "com.oscar.Driver";
        }
        throw new SQLException("unknown jdbc driver : " + rawUrl);
    }

    public static DbType getDbTypeRaw(String rawUrl, String driverClassName) {
        if (rawUrl == null) {
            return null;
        }
        if (rawUrl.startsWith("jdbc:derby:") || rawUrl.startsWith("jdbc:log4jdbc:derby:")) {
            return DbType.derby;
        }
        if (rawUrl.startsWith("jdbc:mysql:") || rawUrl.startsWith("jdbc:cobar:") || rawUrl.startsWith("jdbc:log4jdbc:mysql:")) {
            return DbType.mysql;
        }
        if (rawUrl.startsWith("jdbc:mariadb:")) {
            return DbType.mariadb;
        }
        if (rawUrl.startsWith("jdbc:tidb:")) {
            return DbType.tidb;
        }
        if (rawUrl.startsWith("jdbc:oracle:") || rawUrl.startsWith("jdbc:log4jdbc:oracle:")) {
            return DbType.oracle;
        }
        if (rawUrl.startsWith("jdbc:alibaba:oracle:")) {
            return DbType.ali_oracle;
        }
        if (rawUrl.startsWith("jdbc:oceanbase:oracle:")) {
            return DbType.oceanbase_oracle;
        }
        if (rawUrl.startsWith("jdbc:oceanbase:")) {
            return DbType.oceanbase;
        }
        if (rawUrl.startsWith("jdbc:microsoft:") || rawUrl.startsWith("jdbc:log4jdbc:microsoft:")) {
            return DbType.sqlserver;
        }
        if (rawUrl.startsWith("jdbc:sqlserver:") || rawUrl.startsWith("jdbc:log4jdbc:sqlserver:")) {
            return DbType.sqlserver;
        }
        if (rawUrl.startsWith("jdbc:sybase:Tds:") || rawUrl.startsWith("jdbc:log4jdbc:sybase:")) {
            return DbType.sybase;
        }
        if (rawUrl.startsWith("jdbc:jtds:") || rawUrl.startsWith("jdbc:log4jdbc:jtds:")) {
            return DbType.jtds;
        }
        if (rawUrl.startsWith("jdbc:fake:") || rawUrl.startsWith("jdbc:mock:")) {
            return DbType.mock;
        }
        if (rawUrl.startsWith("jdbc:postgresql:") || rawUrl.startsWith("jdbc:log4jdbc:postgresql:")) {
            return DbType.postgresql;
        }
        if (rawUrl.startsWith("jdbc:edb:")) {
            return DbType.edb;
        }
        if (rawUrl.startsWith("jdbc:hsqldb:") || rawUrl.startsWith("jdbc:log4jdbc:hsqldb:")) {
            return DbType.hsql;
        }
        if (rawUrl.startsWith("jdbc:odps:")) {
            return DbType.odps;
        }
        if (rawUrl.startsWith("jdbc:db2:")) {
            return DbType.db2;
        }
        if (rawUrl.startsWith("jdbc:sqlite:")) {
            return DbType.sqlite;
        }
        if (rawUrl.startsWith("jdbc:ingres:")) {
            return DbType.ingres;
        }
        if (rawUrl.startsWith("jdbc:h2:") || rawUrl.startsWith("jdbc:log4jdbc:h2:")) {
            return DbType.h2;
        }
        if (rawUrl.startsWith("jdbc:mckoi:")) {
            return DbType.mock;
        }
        if (rawUrl.startsWith("jdbc:cloudscape:")) {
            return DbType.cloudscape;
        }
        if (rawUrl.startsWith("jdbc:informix-sqli:") || rawUrl.startsWith("jdbc:log4jdbc:informix-sqli:")) {
            return DbType.informix;
        }
        if (rawUrl.startsWith("jdbc:timesten:")) {
            return DbType.timesten;
        }
        if (rawUrl.startsWith("jdbc:as400:")) {
            return DbType.as400;
        }
        if (rawUrl.startsWith("jdbc:sapdb:")) {
            return DbType.sapdb;
        }
        if (rawUrl.startsWith("jdbc:JSQLConnect:")) {
            return DbType.JSQLConnect;
        }
        if (rawUrl.startsWith("jdbc:JTurbo:")) {
            return DbType.JTurbo;
        }
        if (rawUrl.startsWith("jdbc:firebirdsql:")) {
            return DbType.firebirdsql;
        }
        if (rawUrl.startsWith("jdbc:interbase:")) {
            return DbType.interbase;
        }
        if (rawUrl.startsWith("jdbc:pointbase:")) {
            return DbType.pointbase;
        }
        if (rawUrl.startsWith("jdbc:edbc:")) {
            return DbType.edbc;
        }
        if (rawUrl.startsWith("jdbc:mimer:multi1:")) {
            return DbType.mimer;
        }
        if (rawUrl.startsWith("jdbc:dm:")) {
            return JdbcConstants.DM;
        }
        if (rawUrl.startsWith("jdbc:kingbase:") || rawUrl.startsWith("jdbc:kingbase8:")) {
            return JdbcConstants.KINGBASE;
        }
        if (rawUrl.startsWith("jdbc:gbase:")) {
            return JdbcConstants.GBASE;
        }
        if (rawUrl.startsWith("jdbc:xugu:")) {
            return JdbcConstants.XUGU;
        }
        if (rawUrl.startsWith("jdbc:log4jdbc:")) {
            return DbType.log4jdbc;
        }
        if (rawUrl.startsWith("jdbc:hive:")) {
            return DbType.hive;
        }
        if (rawUrl.startsWith("jdbc:hive2:")) {
            return DbType.hive;
        }
        if (rawUrl.startsWith("jdbc:phoenix:")) {
            return DbType.phoenix;
        }
        if (rawUrl.startsWith("jdbc:kylin:")) {
            return DbType.kylin;
        }
        if (rawUrl.startsWith("jdbc:elastic:")) {
            return DbType.elastic_search;
        }
        if (rawUrl.startsWith("jdbc:clickhouse:")) {
            return DbType.clickhouse;
        }
        if (rawUrl.startsWith("jdbc:presto:")) {
            return DbType.presto;
        }
        if (rawUrl.startsWith("jdbc:trino:")) {
            return DbType.trino;
        }
        if (rawUrl.startsWith("jdbc:inspur:")) {
            return DbType.kdb;
        }
        if (rawUrl.startsWith("jdbc:polardb")) {
            return DbType.polardb;
        }
        if (rawUrl.startsWith("jdbc:highgo:")) {
            return DbType.highgo;
        }
        if (rawUrl.startsWith("jdbc:pivotal:greenplum:") || rawUrl.startsWith("jdbc:datadirect:greenplum:")) {
            return DbType.greenplum;
        }
        return null;
    }

    public static String getDbType(String rawUrl, String driverClassName) {
        DbType dbType = JdbcUtils.getDbTypeRaw(rawUrl, driverClassName);
        if (dbType == null) {
            return null;
        }
        return dbType.name();
    }

    public static Driver createDriver(String driverClassName) throws SQLException {
        return JdbcUtils.createDriver(null, driverClassName);
    }

    public static Driver createDriver(ClassLoader classLoader, String driverClassName) throws SQLException {
        Class<?> clazz = null;
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(driverClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
                if (contextLoader != null) {
                    clazz = contextLoader.loadClass(driverClassName);
                }
            }
            catch (ClassNotFoundException contextLoader) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
        try {
            return (Driver)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    public static int executeUpdate(DataSource dataSource, String sql, Object ... parameters) throws SQLException {
        return JdbcUtils.executeUpdate(dataSource, sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(DataSource dataSource, String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            int n = JdbcUtils.executeUpdate(conn, sql, parameters);
            return n;
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection conn, String sql, List<Object> parameters) throws SQLException {
        int updateCount;
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            JdbcUtils.setParameters(stmt, parameters);
            updateCount = stmt.executeUpdate();
        }
        finally {
            JdbcUtils.close(stmt);
        }
        return updateCount;
    }

    public static void execute(DataSource dataSource, String sql, Object ... parameters) throws SQLException {
        JdbcUtils.execute(dataSource, sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DataSource dataSource, String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            JdbcUtils.execute(conn, sql, parameters);
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    public static void execute(Connection conn, String sql) throws SQLException {
        JdbcUtils.execute(conn, sql, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Connection conn, String sql, List<Object> parameters) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            JdbcUtils.setParameters(stmt, parameters);
            stmt.executeUpdate();
        }
        finally {
            JdbcUtils.close(stmt);
        }
    }

    public static List<Map<String, Object>> executeQuery(DataSource dataSource, String sql, Object ... parameters) throws SQLException {
        return JdbcUtils.executeQuery(dataSource, sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> executeQuery(DataSource dataSource, String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            List<Map<String, Object>> list = JdbcUtils.executeQuery(conn, sql, parameters);
            return list;
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> executeQuery(Connection conn, String sql, List<Object> parameters) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            JdbcUtils.setParameters(stmt, parameters);
            rs = stmt.executeQuery();
            ResultSetMetaData rsMeta = rs.getMetaData();
            while (rs.next()) {
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                int size = rsMeta.getColumnCount();
                for (int i = 0; i < size; ++i) {
                    String columName = rsMeta.getColumnLabel(i + 1);
                    Object value = rs.getObject(i + 1);
                    row.put(columName, value);
                }
                rows.add(row);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        return rows;
    }

    private static void setParameters(PreparedStatement stmt, List<Object> parameters) throws SQLException {
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            Object param = parameters.get(i);
            stmt.setObject(i + 1, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertToTable(DataSource dataSource, String tableName, Map<String, Object> data) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            JdbcUtils.insertToTable(conn, tableName, data);
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    public static void insertToTable(Connection conn, String tableName, Map<String, Object> data) throws SQLException {
        String sql = JdbcUtils.makeInsertToTableSql(tableName, data.keySet());
        ArrayList<Object> parameters = new ArrayList<Object>(data.values());
        JdbcUtils.execute(conn, sql, parameters);
    }

    public static String makeInsertToTableSql(String tableName, Collection<String> names) {
        StringBuilder sql = new StringBuilder().append("insert into ").append(tableName).append("(");
        int nameCount = 0;
        for (String name : names) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            ++nameCount;
        }
        sql.append(") values (");
        for (int i = 0; i < nameCount; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void executeQuery(DataSource dataSource, ResultSetConsumer<T> consumer, String sql, Object ... parameters) throws SQLException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            stmt = conn.prepareStatement(sql);
            for (int i = 0; i < parameters.length; ++i) {
                stmt.setObject(i + 1, parameters[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (consumer == null) continue;
                T object = consumer.apply(rs);
                consumer.accept(object);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
    }

    public static List<String> showTables(Connection conn, DbType dbType) throws SQLException {
        if (JdbcUtils.isMysqlDbType(dbType)) {
            return MySqlUtils.showTables(conn);
        }
        if (dbType == DbType.oracle || dbType == DbType.oceanbase_oracle) {
            return OracleUtils.showTables(conn);
        }
        if (dbType == DbType.postgresql) {
            return PGUtils.showTables(conn);
        }
        throw new SQLException("show tables dbType not support for " + (Object)((Object)dbType));
    }

    public static String getCreateTableScript(Connection conn, DbType dbType) throws SQLException {
        return JdbcUtils.getCreateTableScript(conn, dbType, true, true);
    }

    public static String getCreateTableScript(Connection conn, DbType dbType, boolean sorted, boolean simplify) throws SQLException {
        if (JdbcUtils.isMysqlDbType(dbType)) {
            return MySqlUtils.getCreateTableScript(conn, sorted, simplify);
        }
        if (dbType == DbType.oracle || dbType == DbType.oceanbase_oracle) {
            return OracleUtils.getCreateTableScript(conn, sorted, simplify);
        }
        throw new SQLException("getCreateTableScript dbType not support for " + (Object)((Object)dbType));
    }

    public static boolean isMySqlDriver(String driverClassName) {
        return driverClassName.equals("com.mysql.jdbc.Driver") || driverClassName.equals("com.mysql.cj.jdbc.Driver") || driverClassName.equals("com.mysql.jdbc.");
    }

    public static boolean isOracleDbType(String dbType) {
        return DbType.oracle.name().equals(dbType) || DbType.oceanbase_oracle.name().equals(dbType) || DbType.ali_oracle.name().equalsIgnoreCase(dbType);
    }

    public static boolean isOracleDbType(DbType dbType) {
        return DbType.oracle == dbType || DbType.oceanbase_oracle == dbType || DbType.ali_oracle == dbType;
    }

    public static boolean isMysqlDbType(String dbTypeName) {
        return JdbcUtils.isMysqlDbType(DbType.of(dbTypeName));
    }

    public static boolean isMysqlDbType(DbType dbType) {
        if (dbType == null) {
            return false;
        }
        switch (dbType) {
            case mysql: 
            case oceanbase: 
            case ads: 
            case drds: 
            case mariadb: 
            case tidb: 
            case h2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPgsqlDbType(String dbTypeName) {
        return JdbcUtils.isPgsqlDbType(DbType.of(dbTypeName));
    }

    public static boolean isPgsqlDbType(DbType dbType) {
        if (dbType == null) {
            return false;
        }
        switch (dbType) {
            case postgresql: 
            case edb: 
            case polardb: 
            case greenplum: 
            case gaussdb: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSqlserverDbType(String dbTypeName) {
        return JdbcUtils.isSqlserverDbType(DbType.of(dbTypeName));
    }

    public static boolean isSqlserverDbType(DbType dbType) {
        if (dbType == null) {
            return false;
        }
        switch (dbType) {
            case sqlserver: 
            case jtds: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block6: {
            LOG = LogFactory.getLog(JdbcUtils.class);
            DRIVER_URL_MAPPING = new Properties();
            mysql_driver_version_6 = null;
            try {
                ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
                if (ctxClassLoader == null) break block6;
                Enumeration<URL> e = ctxClassLoader.getResources("META-INF/druid-driver.properties");
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    Properties property = new Properties();
                    InputStream is = null;
                    try {
                        is = url.openStream();
                        property.load(is);
                    }
                    finally {
                        JdbcUtils.close(is);
                    }
                    DRIVER_URL_MAPPING.putAll((Map<?, ?>)property);
                }
            }
            catch (Exception e) {
                LOG.error("load druid-driver.properties error", e);
            }
        }
    }
}

