/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.repository;

import com.alibaba.druid.sql.ast.SQLDeclareItem;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLFetchStatement;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.repository.SchemaResolveVisitorFactory;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.HashMap;
import java.util.Map;

public interface SchemaResolveVisitor
extends SQLASTVisitor {
    public boolean isEnabled(Option var1);

    public int getOptions();

    public SchemaRepository getRepository();

    public Context getContext();

    public Context createContext(SQLObject var1);

    public void popContext();

    @Override
    default public boolean visit(SQLSelectStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x.getSelect());
        return false;
    }

    @Override
    default public boolean visit(SQLSelect x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLWithSubqueryClause x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLIfStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLCreateFunctionStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLExprTableSource x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLSelectQueryBlock x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLForeignKeyImpl x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLIdentifierExpr x) {
        SchemaResolveVisitorFactory.resolveIdent(this, x);
        return true;
    }

    @Override
    default public boolean visit(SQLPropertyExpr x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLBinaryOpExpr x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLAllColumnExpr x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLCreateTableStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLUpdateStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLDeleteStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLAlterTableStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLInsertStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLParameter x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLDeclareItem x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLOver x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLMethodInvokeExpr x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLUnionQuery x) {
        SchemaResolveVisitorFactory.resolveUnion(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLMergeStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLCreateProcedureStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLBlockStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLReplaceStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    @Override
    default public boolean visit(SQLCastExpr x) {
        x.getExpr().accept(this);
        return true;
    }

    @Override
    default public boolean visit(SQLFetchStatement x) {
        SchemaResolveVisitorFactory.resolve(this, x);
        return false;
    }

    public static class Context {
        public final Context parent;
        public final SQLObject object;
        private SQLTableSource tableSource;
        private SQLTableSource from;
        private Map<Long, SQLTableSource> tableSourceMap;
        protected Map<Long, SQLDeclareItem> declares;

        public Context(SQLObject object, Context parent) {
            this.object = object;
            this.parent = parent;
        }

        public SQLTableSource getFrom() {
            return this.from;
        }

        public void setFrom(SQLTableSource from) {
            this.from = from;
        }

        public SQLTableSource getTableSource() {
            return this.tableSource;
        }

        public void setTableSource(SQLTableSource tableSource) {
            this.tableSource = tableSource;
        }

        public void addTableSource(long alias_hash, SQLTableSource tableSource) {
            if (this.tableSourceMap == null) {
                this.tableSourceMap = new HashMap<Long, SQLTableSource>();
            }
            this.tableSourceMap.put(alias_hash, tableSource);
        }

        protected void declare(SQLDeclareItem x) {
            if (this.declares == null) {
                this.declares = new HashMap<Long, SQLDeclareItem>();
            }
            this.declares.put(x.getName().nameHashCode64(), x);
        }

        protected SQLDeclareItem findDeclare(long nameHash) {
            if (this.declares == null) {
                return null;
            }
            return this.declares.get(nameHash);
        }

        protected SQLTableSource findTableSource(long nameHash) {
            SQLTableSource table = null;
            if (this.tableSourceMap != null) {
                table = this.tableSourceMap.get(nameHash);
            }
            return table;
        }

        protected SQLTableSource findTableSourceRecursive(long nameHash) {
            Context ctx = this;
            while (ctx != null) {
                SQLTableSource table;
                if (ctx.tableSourceMap != null && (table = ctx.tableSourceMap.get(nameHash)) != null) {
                    return table;
                }
                ctx = ctx.parent;
            }
            return null;
        }
    }

    public static enum Option {
        ResolveAllColumn,
        ResolveIdentifierAlias,
        CheckColumnAmbiguous;

        public final int mask = 1 << this.ordinal();

        public static int of(Option ... options) {
            if (options == null) {
                return 0;
            }
            int value = 0;
            for (Option option : options) {
                value |= option.mask;
            }
            return value;
        }
    }
}

