/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.redshift.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGCreateTableParser;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftCreateTableStatement;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftSortKey;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class RedshiftCreateTableParser
extends PGCreateTableParser {
    public RedshiftCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.redshift;
    }

    @Override
    public SQLCreateTableStatement parseCreateTable() {
        List<String> comments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            comments = this.lexer.readAndResetComments();
        }
        RedshiftCreateTableStatement createTable = new RedshiftCreateTableStatement();
        if (comments != null) {
            createTable.addBeforeComment(comments);
        }
        createTable.setDbType(this.dbType);
        if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
            createTable.addBeforeComment(this.lexer.readAndResetComments());
        }
        this.accept(Token.CREATE);
        this.createTableBefore(createTable);
        this.accept(Token.TABLE);
        this.createTableBeforeName(createTable);
        createTable.setName(this.exprParser.name());
        this.createTableAfterName(createTable);
        this.createTableBody(createTable);
        this.createTableQuery(createTable);
        this.parseCreateTableRest(createTable);
        return createTable;
    }

    @Override
    public void parseCreateTableRest(SQLCreateTableStatement createTable) {
        if (createTable instanceof RedshiftCreateTableStatement) {
            RedshiftCreateTableStatement redshiftCreateTableStatement = (RedshiftCreateTableStatement)createTable;
            if (this.lexer.nextIf(Token.BACKUP)) {
                redshiftCreateTableStatement.setBackup(this.exprParser.expr());
            }
            if (this.lexer.nextIf(Token.DISTSTYLE)) {
                if (this.lexer.token() == Token.EVEN || this.lexer.token() == Token.KEY || this.lexer.token() == Token.AUTO || this.lexer.token() == Token.ALL) {
                    redshiftCreateTableStatement.setDistStyle(new SQLIdentifierExpr(this.lexer.token().name));
                    this.lexer.nextToken();
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if (this.lexer.nextIf(Token.DISTKEY)) {
                this.accept(Token.LPAREN);
                redshiftCreateTableStatement.setDistKey(this.exprParser.expr());
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.COMPOUND || this.lexer.token() == Token.INTERLEAVED) {
                RedshiftSortKey sortKey = new RedshiftSortKey();
                sortKey.setCompound(this.lexer.token() == Token.COMPOUND);
                sortKey.setInterleaved(this.lexer.token() == Token.INTERLEAVED);
                this.lexer.nextToken();
                this.accept(Token.SORTKEY);
                this.accept(Token.LPAREN);
                do {
                    sortKey.addColumn(this.exprParser.expr());
                } while (this.lexer.nextIf(Token.COMMA));
                this.accept(Token.RPAREN);
                redshiftCreateTableStatement.setSortKey(sortKey);
            } else if (this.lexer.nextIf(Token.SORTKEY)) {
                this.accept(Token.AUTO);
                RedshiftSortKey sortKey = new RedshiftSortKey();
                sortKey.setAuto(true);
                redshiftCreateTableStatement.setSortKey(sortKey);
            }
            if (this.lexer.nextIf(Token.ENCODE)) {
                this.accept(Token.AUTO);
                redshiftCreateTableStatement.setEncodeAuto(true);
            }
        } else {
            super.parseCreateTableRest(createTable);
        }
    }

    @Override
    protected void createTableBefore(SQLCreateTableStatement createTable) {
        if (this.lexer.nextIfIdentifier("TEMPORARY") || this.lexer.nextIfIdentifier("TEMP")) {
            createTable.config(SQLCreateTableStatement.Feature.Temporary);
        }
        super.createTableBefore(createTable);
    }
}

