/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.presto.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExplainStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLShowColumnsStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowDatabasesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowFunctionsStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowIndexesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowPartitionsStmt;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowViewsStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsert;
import com.alibaba.druid.sql.dialect.hive.ast.HiveInsertStatement;
import com.alibaba.druid.sql.dialect.hive.ast.HiveMultiInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MysqlDeallocatePrepareStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoAlterFunctionStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoAlterSchemaStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoExecuteStatement;
import com.alibaba.druid.sql.dialect.presto.ast.stmt.PrestoPrepareStatement;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoCreateTableParser;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoExprParser;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.List;

public class PrestoStatementParser
extends SQLStatementParser {
    public PrestoStatementParser(String sql) {
        super(new PrestoExprParser(sql, new SQLParserFeature[0]));
        this.dbType = DbType.presto;
    }

    public PrestoStatementParser(String sql, SQLParserFeature ... features) {
        super(new PrestoExprParser(sql, features));
        this.dbType = DbType.presto;
    }

    public PrestoStatementParser(SQLExprParser exprParser) {
        super(exprParser);
        this.dbType = DbType.presto;
    }

    public PrestoStatementParser(Lexer lexer) {
        super(new PrestoExprParser(lexer));
        this.dbType = DbType.presto;
    }

    @Override
    public PrestoSelectParser createSQLSelectParser() {
        return new PrestoSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public PGSelectStatement parseSelect() {
        PrestoSelectParser selectParser = this.createSQLSelectParser();
        SQLSelect select = selectParser.select();
        return new PGSelectStatement(select);
    }

    @Override
    protected void parseInsertColumns(SQLInsertInto insert) {
        if (this.lexer.token() == Token.RPAREN) {
            return;
        }
        while (true) {
            SQLName expr = this.exprParser.name();
            expr.setParent(insert);
            insert.getColumns().add(expr);
            if (this.lexer.token() == Token.IDENTIFIER) {
                String text = this.lexer.stringVal();
                if (text.equalsIgnoreCase("TINYINT") || text.equalsIgnoreCase("BIGINT") || text.equalsIgnoreCase("INTEGER") || text.equalsIgnoreCase("DOUBLE") || text.equalsIgnoreCase("DATE") || text.equalsIgnoreCase("VARCHAR")) {
                    expr.getAttributes().put("dataType", text);
                    this.lexer.nextToken();
                } else if (text.equalsIgnoreCase("CHAR")) {
                    String dataType = text;
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    SQLExpr char_len = this.exprParser.primary();
                    this.accept(Token.RPAREN);
                    dataType = dataType + "(" + char_len.toString() + ")";
                    expr.getAttributes().put("dataType", dataType);
                }
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new PrestoCreateTableParser(this.exprParser);
    }

    @Override
    protected SQLStatement parseAlterFunction() {
        this.accept(Token.ALTER);
        this.accept(Token.FUNCTION);
        PrestoAlterFunctionStatement stmt = new PrestoAlterFunctionStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        if (this.lexer.token() == Token.LPAREN) {
            StringBuilder needAppendName = new StringBuilder();
            needAppendName.append("(");
            while (true) {
                this.lexer.nextToken();
                needAppendName.append(this.lexer.stringVal());
                this.lexer.nextToken();
                if (this.lexer.token() == Token.RPAREN) break;
                if (this.lexer.token() != Token.COMMA) continue;
                needAppendName.append(",");
                Lexer.SavePoint mark = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.RPAREN) {
                    this.setErrorEndPos(this.lexer.pos());
                    throw new ParserException("syntax error, actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
                }
                this.lexer.reset(mark);
            }
            this.accept(Token.RPAREN);
            needAppendName.append(")");
            if (needAppendName.length() > 0) {
                if (name instanceof SQLPropertyExpr) {
                    SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)name;
                    sqlPropertyExpr.setName(sqlPropertyExpr.getName() + needAppendName);
                } else if (name instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)name;
                    sqlIdentifierExpr.setName(sqlIdentifierExpr.getName() + needAppendName);
                }
            }
        }
        stmt.setName(name);
        if (this.lexer.identifierEquals("CALLED")) {
            this.lexer.nextToken();
            stmt.setCalledOnNullInput(true);
        } else if (this.lexer.identifierEquals("RETURNS")) {
            this.lexer.nextToken();
            this.acceptIdentifier("NULL");
            stmt.setCalledOnNullInput(true);
        } else {
            this.setErrorEndPos(this.lexer.pos());
            throw new ParserException("syntax error, actual " + (Object)((Object)this.lexer.token()) + ", " + this.lexer.info());
        }
        this.accept(Token.ON);
        this.accept(Token.NULL);
        this.acceptIdentifier("INPUT");
        return stmt;
    }

    @Override
    protected SQLStatement alterSchema() {
        this.accept(Token.ALTER);
        this.accept(Token.SCHEMA);
        PrestoAlterSchemaStatement stmt = new PrestoAlterSchemaStatement();
        stmt.setDbType(this.dbType);
        SQLName name = this.exprParser.name();
        stmt.setSchemaName(name);
        this.acceptIdentifier("RENAME");
        this.accept(Token.TO);
        stmt.setNewName(this.exprParser.identifier());
        return stmt;
    }

    @Override
    public SQLStatement parseInsert() {
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            HiveMultiInsertStatement stmt = new HiveMultiInsertStatement();
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLName tableName = this.exprParser.name();
                SQLExprTableSource from = new SQLExprTableSource(tableName);
                SQLTableSource tableSource = this.createSQLSelectParser().parseTableSourceRest(from);
                stmt.setFrom(tableSource);
                if (this.lexer.token() == Token.IDENTIFIER) {
                    from.setAlias(this.lexer.stringVal());
                    this.lexer.nextToken();
                }
            } else {
                this.accept(Token.LPAREN);
                PrestoSelectParser selectParser = this.createSQLSelectParser();
                SQLSelect select = selectParser.select();
                this.accept(Token.RPAREN);
                String alias = this.lexer.stringVal();
                this.accept(Token.IDENTIFIER);
                SQLTableSource from = new SQLSubqueryTableSource(select, alias);
                switch (this.lexer.token()) {
                    case LEFT: 
                    case RIGHT: 
                    case FULL: 
                    case JOIN: {
                        from = selectParser.parseTableSourceRest(from);
                        break;
                    }
                }
                stmt.setFrom(from);
            }
            do {
                HiveInsert insert = this.parseHiveInsert();
                stmt.addItem(insert);
            } while (this.lexer.token() == Token.INSERT);
            return stmt;
        }
        return this.parseHiveInsertStmt();
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.identifierEquals("PREPARE")) {
            PrestoPrepareStatement stmt = this.parsePrepare();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("EXECUTE")) {
            this.acceptIdentifier("EXECUTE");
            if (this.lexer.identifierEquals("IMMEDIATE")) {
                this.acceptIdentifier("IMMEDIATE");
            }
            PrestoExecuteStatement stmt = this.parseExecute();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals("DEALLOCATE")) {
            MysqlDeallocatePrepareStatement stmt = this.parseDeallocatePrepare();
            statementList.add(stmt);
            return true;
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SHOW)) {
            SQLStatementImpl stmt;
            Lexer.SavePoint savePoint = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.VIEWS)) {
                this.lexer.nextToken();
                SQLShowViewsStatement stmt2 = new SQLShowViewsStatement();
                if (this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName db = this.exprParser.name();
                    stmt2.setDatabase(db);
                }
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr pattern = this.exprParser.expr();
                    stmt2.setLike(pattern);
                }
                statementList.add(stmt2);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.TABLES)) {
                this.lexer.reset(savePoint);
                SQLShowTablesStatement stmt3 = this.parseShowTables();
                statementList.add(stmt3);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.DATABASES) || this.lexer.identifierEquals(FnvHash.Constants.SCHEMAS)) {
                this.lexer.nextToken();
                SQLShowDatabasesStatement stmt4 = this.parseShowDatabases(false);
                statementList.add(stmt4);
                return true;
            }
            if (this.lexer.token() == Token.INDEX) {
                this.lexer.nextToken();
                SQLShowIndexesStatement stmt5 = new SQLShowIndexesStatement();
                stmt5.setType("INDEX");
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    SQLName table = this.exprParser.name();
                    stmt5.setTable(table);
                }
                if (this.lexer.token() == Token.HINT) {
                    stmt5.setHints(this.exprParser.parseHints());
                }
                statementList.add(stmt5);
                return true;
            }
            if (this.lexer.token() == Token.CREATE) {
                Lexer.SavePoint savePointCreateTable = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.reset(savePointCreateTable);
                    SQLShowCreateTableStatement stmt6 = this.parseShowCreateTable();
                    statementList.add(stmt6);
                    return true;
                }
                if (this.lexer.token() == Token.VIEW) {
                    this.lexer.nextToken();
                    SQLShowCreateViewStatement stmt7 = new SQLShowCreateViewStatement();
                    SQLName view = this.exprParser.name();
                    stmt7.setName(view);
                    statementList.add(stmt7);
                    return true;
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.PARTITIONS)) {
                this.lexer.nextToken();
                stmt = new SQLShowPartitionsStmt();
                if (this.lexer.token() == Token.FROM) {
                    this.lexer.nextToken();
                }
                SQLExpr expr = this.exprParser.expr();
                ((SQLShowPartitionsStmt)stmt).setTableSource(new SQLExprTableSource(expr));
                if (this.lexer.token() == Token.PARTITION) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    this.parseAssignItems(((SQLShowPartitionsStmt)stmt).getPartition(), stmt, false);
                    this.accept(Token.RPAREN);
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    ((SQLShowPartitionsStmt)stmt).setWhere(this.exprParser.expr());
                }
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.COLUMNS)) {
                this.lexer.nextToken();
                stmt = new SQLShowColumnsStatement();
                if (this.lexer.token() == Token.FROM || this.lexer.token() == Token.IN) {
                    this.lexer.nextToken();
                    SQLName table = this.exprParser.name();
                    if (this.lexer.token() == Token.SUB && table instanceof SQLIdentifierExpr) {
                        this.lexer.mark();
                        this.lexer.nextToken();
                        String strVal = this.lexer.stringVal();
                        this.lexer.nextToken();
                        if (table instanceof SQLIdentifierExpr) {
                            SQLIdentifierExpr ident = (SQLIdentifierExpr)table;
                            table = new SQLIdentifierExpr(ident.getName() + "-" + strVal);
                        }
                    }
                    ((SQLShowColumnsStatement)stmt).setTable(table);
                }
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr like = this.exprParser.expr();
                    ((SQLShowColumnsStatement)stmt).setLike(like);
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    SQLExpr where = this.exprParser.expr();
                    ((SQLShowColumnsStatement)stmt).setWhere(where);
                }
                statementList.add(stmt);
                return true;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.FUNCTIONS)) {
                this.lexer.nextToken();
                stmt = new SQLShowFunctionsStatement();
                if (this.lexer.token() == Token.LIKE) {
                    this.lexer.nextToken();
                    SQLExpr like = this.exprParser.expr();
                    ((SQLShowFunctionsStatement)stmt).setLike(like);
                }
                statementList.add(stmt);
                return true;
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        return false;
    }

    public PrestoPrepareStatement parsePrepare() {
        this.acceptIdentifier("PREPARE");
        SQLName name = this.exprParser.name();
        this.accept(Token.FROM);
        PrestoPrepareStatement stmt = new PrestoPrepareStatement(name);
        if (this.lexer.token() == Token.SELECT) {
            SQLSelect select = this.createSQLSelectParser().select();
            stmt.setSelect(select);
        } else if (this.lexer.token() == Token.INSERT) {
            SQLStatement sqlStatement = this.parseInsert();
            stmt.setInsert((HiveInsertStatement)sqlStatement);
        }
        return stmt;
    }

    @Override
    public PrestoExecuteStatement parseExecute() {
        PrestoExecuteStatement stmt = new PrestoExecuteStatement();
        SQLName statementName = this.exprParser.name();
        stmt.setStatementName(statementName);
        if (this.lexer.identifierEquals("USING")) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getParameters(), stmt);
        } else if (this.lexer.token() == Token.IDENTIFIER) {
            this.exprParser.exprList(stmt.getParameters(), stmt);
        }
        return stmt;
    }

    public MysqlDeallocatePrepareStatement parseDeallocatePrepare() {
        this.acceptIdentifier("DEALLOCATE");
        this.acceptIdentifier("PREPARE");
        MysqlDeallocatePrepareStatement stmt = new MysqlDeallocatePrepareStatement();
        SQLName statementName = this.exprParser.name();
        stmt.setStatementName(statementName);
        return stmt;
    }

    @Override
    public void parseCreateTableSupportSchema() {
        if (this.lexer.token() == Token.SCHEMA) {
            this.lexer.nextToken();
        } else {
            this.accept(Token.DATABASE);
        }
    }

    @Override
    public void parseExplainFormatType(SQLExplainStatement explain) {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("FORMAT")) {
                this.lexer.nextToken();
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals("TYPE")) {
                this.lexer.nextToken();
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
    }
}

