/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.parser;

import com.alibaba.druid.sql.ast.SQLArrayDataType;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStructDataType;
import com.alibaba.druid.sql.ast.expr.SQLArrayExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.clickhouse.ast.ClickhouseColumnCodec;
import com.alibaba.druid.sql.dialect.clickhouse.ast.ClickhouseColumnTTL;
import com.alibaba.druid.sql.dialect.clickhouse.parser.CKLexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;
import java.util.List;

public class CKExprParser
extends SQLExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;
    private static final List<String> NESTED_DATA_TYPE;

    public CKExprParser(String sql) {
        this(new CKLexer(sql, new SQLParserFeature[0]));
        this.lexer.nextToken();
    }

    public CKExprParser(String sql, SQLParserFeature ... features) {
        this(new CKLexer(sql, features));
        this.lexer.nextToken();
    }

    public CKExprParser(Lexer lexer) {
        super(lexer);
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
        this.nestedDataType = NESTED_DATA_TYPE;
    }

    @Override
    protected SQLExpr parseAliasExpr(String alias) {
        String chars = alias.substring(1, alias.length() - 1);
        return new SQLCharExpr(chars);
    }

    @Override
    public SQLExpr primaryRest(SQLExpr expr) {
        if (this.lexer.token() == Token.LBRACKET) {
            SQLArrayExpr array = new SQLArrayExpr();
            array.setExpr(expr);
            this.lexer.nextToken();
            this.exprList(array.getValues(), array);
            this.accept(Token.RBRACKET);
            return this.primaryRest(array);
        }
        return super.primaryRest(expr);
    }

    @Override
    protected SQLColumnDefinition parseColumnSpecific(SQLColumnDefinition column) {
        switch (this.lexer.token()) {
            case CODEC: {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLExpr codecExpr = this.expr();
                this.accept(Token.RPAREN);
                ClickhouseColumnCodec sqlColumnCodec = new ClickhouseColumnCodec();
                sqlColumnCodec.setExpr(codecExpr);
                column.addConstraint(sqlColumnCodec);
                return this.parseColumnRest(column);
            }
            case TTL: {
                this.lexer.nextToken();
                ClickhouseColumnTTL clickhouseColumnTTL = new ClickhouseColumnTTL();
                clickhouseColumnTTL.setExpr(this.expr());
                column.addConstraint(clickhouseColumnTTL);
                return this.parseColumnRest(column);
            }
        }
        return column;
    }

    @Override
    protected SQLExpr primaryDefaultRest() {
        return new SQLIdentifierExpr(this.lexer.stringVal());
    }

    @Override
    protected SQLDataType parseDataTypeNested() {
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        SQLStructDataType struct = new SQLStructDataType(this.dbType);
        while (true) {
            SQLName name;
            switch (this.lexer.token()) {
                case GROUP: 
                case ORDER: 
                case FROM: 
                case TO: {
                    name = new SQLIdentifierExpr(this.lexer.stringVal());
                    this.lexer.nextToken();
                    break;
                }
                default: {
                    name = this.name();
                }
            }
            SQLDataType dataType = this.parseDataType();
            SQLStructDataType.Field field = struct.addField(name, dataType);
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
                SQLCharExpr chars = (SQLCharExpr)this.primary();
                field.setComment(chars.getText());
            }
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        return struct;
    }

    @Override
    protected SQLArrayDataType parseArrayDataType() {
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        SQLDataType itemType = this.parseDataType();
        SQLArrayDataType array = new SQLArrayDataType(itemType, this.dbType);
        this.accept(Token.RPAREN);
        return array;
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "ROWNUMBER"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            CKExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
        NESTED_DATA_TYPE = Arrays.asList("array", "tuple", "nullable", "lowcardinality", "variant");
    }
}

