/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLKeep;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SQLAggregateExpr
extends SQLMethodInvokeExpr
implements Serializable,
SQLReplaceable {
    private static final long serialVersionUID = 1L;
    protected SQLAggregateOption option;
    protected SQLKeep keep;
    protected SQLExpr filter;
    protected SQLOver over;
    protected SQLName overRef;
    protected SQLOrderBy orderBy;
    protected SQLExpr limit;
    protected boolean withinGroup;
    protected boolean ignoreNulls;
    protected boolean respectNulls;

    public SQLAggregateExpr(String methodName) {
        this.methodName = methodName;
        this.ignoreNulls = false;
        this.respectNulls = false;
    }

    public SQLAggregateExpr(String methodName, SQLAggregateOption option) {
        this.methodName = methodName;
        this.option = option;
        this.ignoreNulls = false;
        this.respectNulls = false;
    }

    public SQLAggregateExpr(String methodName, SQLAggregateOption option, SQLExpr ... arguments) {
        this.methodName = methodName;
        this.option = option;
        this.ignoreNulls = false;
        this.respectNulls = false;
        if (arguments != null) {
            for (SQLExpr argument : arguments) {
                if (argument == null) continue;
                this.addArgument(argument);
            }
        }
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy x) {
        if (x != null) {
            x.setParent(this);
        }
        this.orderBy = x;
    }

    public SQLExpr getLimit() {
        return this.limit;
    }

    public void setLimit(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.limit = x;
    }

    public SQLAggregateOption getOption() {
        return this.option;
    }

    public void setOption(SQLAggregateOption option) {
        this.option = option;
    }

    public boolean isDistinct() {
        return this.option == SQLAggregateOption.DISTINCT;
    }

    public SQLOver getOver() {
        return this.over;
    }

    public void setOver(SQLOver x) {
        if (x != null) {
            x.setParent(this);
        }
        this.over = x;
    }

    public SQLName getOverRef() {
        return this.overRef;
    }

    public void setOverRef(SQLName x) {
        if (x != null) {
            x.setParent(this);
        }
        this.overRef = x;
    }

    public SQLKeep getKeep() {
        return this.keep;
    }

    public void setKeep(SQLKeep keep) {
        if (keep != null) {
            keep.setParent(this);
        }
        this.keep = keep;
    }

    public boolean isWithinGroup() {
        return this.withinGroup;
    }

    public void setWithinGroup(boolean withinGroup) {
        this.withinGroup = withinGroup;
    }

    @Deprecated
    public SQLOrderBy getWithinGroup() {
        return this.orderBy;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public boolean getIgnoreNulls() {
        return this.ignoreNulls;
    }

    public boolean isRespectNulls() {
        return this.respectNulls;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public void setRespectNulls(boolean respectNulls) {
        this.respectNulls = respectNulls;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this);
    }

    @Override
    protected void accept0(SQLASTVisitor v) {
        if (v.visit(this)) {
            if (this.owner != null) {
                this.owner.accept(v);
            }
            for (SQLExpr arg : this.arguments) {
                if (arg == null) continue;
                arg.accept(v);
            }
            if (this.keep != null) {
                this.keep.accept(v);
            }
            if (this.filter != null) {
                this.filter.accept(v);
            }
            if (this.over != null) {
                this.over.accept(v);
            }
            if (this.overRef != null) {
                this.overRef.accept(v);
            }
            this.acceptChild(v, this.orderBy);
            this.acceptChild(v, this.limit);
        }
        v.endVisit(this);
    }

    @Override
    public List getChildren() {
        ArrayList<SQLObjectImpl> children = new ArrayList<SQLObjectImpl>();
        children.addAll(this.arguments);
        if (this.keep != null) {
            children.add(this.keep);
        }
        if (this.over != null) {
            children.add(this.over);
        }
        if (this.orderBy != null) {
            children.add(this.orderBy);
        }
        return children;
    }

    public SQLExpr getFilter() {
        return this.filter;
    }

    public void setFilter(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.filter = x;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SQLAggregateExpr that = (SQLAggregateExpr)o;
        if (this.option != that.option) {
            return false;
        }
        if (this.keep != null ? !this.keep.equals(that.keep) : that.keep != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.over != null ? !this.over.equals(that.over) : that.over != null) {
            return false;
        }
        if (this.overRef != null ? !this.overRef.equals(that.overRef) : that.overRef != null) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(that.orderBy) : that.orderBy != null) {
            return false;
        }
        return this.ignoreNulls == that.ignoreNulls && this.respectNulls == that.respectNulls;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.option != null ? this.option.hashCode() : 0);
        result = 31 * result + (this.keep != null ? this.keep.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.over != null ? this.over.hashCode() : 0);
        result = 31 * result + (this.overRef != null ? this.overRef.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        return result;
    }

    @Override
    public SQLAggregateExpr clone() {
        SQLAggregateExpr x = new SQLAggregateExpr(this.methodName);
        x.option = this.option;
        for (SQLExpr sQLExpr : this.arguments) {
            x.addArgument(sQLExpr.clone());
        }
        if (this.keep != null) {
            x.setKeep(this.keep.clone());
        }
        if (this.over != null) {
            x.setOver(this.over.clone());
        }
        if (this.overRef != null) {
            x.setOverRef(this.overRef.clone());
        }
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        x.setWithinGroup(this.withinGroup);
        x.ignoreNulls = this.ignoreNulls;
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof SQLObject) {
                    value = ((SQLObject)value).clone();
                }
                x.putAttribute(key, value);
            }
        }
        return x;
    }

    @Override
    public SQLDataType computeDataType() {
        SQLDataType dataType;
        if (this.resolvedReturnDataType != null) {
            return this.resolvedReturnDataType;
        }
        long hash = this.methodNameHashCode64();
        if (hash == FnvHash.Constants.COUNT || hash == FnvHash.Constants.ROW_NUMBER) {
            return SQLIntegerExpr.DATA_TYPE;
        }
        if (this.arguments.size() > 0 && (dataType = ((SQLExpr)this.arguments.get(0)).computeDataType()) != null && dataType.nameHashCode64() != FnvHash.Constants.BOOLEAN) {
            return dataType;
        }
        if (hash == FnvHash.Constants.SUM) {
            return SQLNumberExpr.DATA_TYPE_DOUBLE;
        }
        if (hash == FnvHash.Constants.WM_CONCAT || hash == FnvHash.Constants.GROUP_CONCAT) {
            return SQLCharExpr.DATA_TYPE;
        }
        return null;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != expr) continue;
            this.arguments.set(i, target);
            target.setParent(this);
            return true;
        }
        if (this.overRef == expr) {
            this.setOverRef((SQLName)target);
            return true;
        }
        if (this.filter != null) {
            this.filter = target;
            target.setParent(this);
        }
        return false;
    }
}

