/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.redshift.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.redshift.parser.RedshiftLexer;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftColumnEncode;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftColumnKey;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class RedshiftExprParser
extends PGExprParser {
    public RedshiftExprParser(String sql, SQLParserFeature ... features) {
        super(new RedshiftLexer(sql, features));
        this.lexer.nextToken();
        this.dbType = DbType.redshift;
    }

    public RedshiftExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = DbType.redshift;
    }

    @Override
    protected SQLColumnDefinition parseColumnSpecific(SQLColumnDefinition column) {
        switch (this.lexer.token()) {
            case ENCODE: {
                SQLExpr codecExpr;
                this.lexer.nextToken();
                if (this.lexer.token() == Token.AUTO) {
                    codecExpr = new SQLIdentifierExpr("AUTO");
                    this.lexer.nextToken();
                } else {
                    codecExpr = this.expr();
                }
                RedshiftColumnEncode sqlColumnEncode = new RedshiftColumnEncode();
                sqlColumnEncode.setExpr(codecExpr);
                column.addConstraint(sqlColumnEncode);
                return this.parseColumnRest(column);
            }
            case SORTKEY: 
            case DISTKEY: {
                RedshiftColumnKey key = new RedshiftColumnKey();
                if (this.lexer.token() == Token.DISTKEY) {
                    key.setDistKey(true);
                } else {
                    key.setSortKey(true);
                }
                this.lexer.nextToken();
                column.addConstraint(key);
                return this.parseColumnRest(column);
            }
            case IDENTITY: {
                this.lexer.nextToken();
                SQLColumnDefinition.Identity identity = this.parseIdentity();
                column.setIdentity(identity);
                return this.parseColumnRest(column);
            }
        }
        return column;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.identifierEquals(FnvHash.Constants.GENERATED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.DEFAULT);
            this.accept(Token.AS);
            this.accept(Token.IDENTITY);
            SQLColumnDefinition.Identity id = this.parseIdentity();
            column.setGeneratedAlwaysAs(id);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
            this.lexer.nextToken();
            column.setCollateExpr(this.expr());
        }
        return super.parseColumnRest(column);
    }

    @Override
    protected SQLColumnDefinition.Identity parseIdentity() {
        this.accept(Token.LPAREN);
        SQLColumnDefinition.Identity ident = new SQLColumnDefinition.Identity();
        this.parseIdentifySpecific();
        if (this.lexer.token() != Token.LITERAL_INT) {
            throw new ParserException("TODO : " + this.lexer.info());
        }
        ident.setSeed(this.lexer.integerValue().intValue());
        this.lexer.nextToken();
        if (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.LITERAL_INT) {
                ident.setIncrement(this.lexer.integerValue().intValue());
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO : " + this.lexer.info());
            }
        }
        this.accept(Token.RPAREN);
        return ident;
    }
}

