/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.ads.parser.AdsStatementParser;
import com.alibaba.druid.sql.dialect.antspark.parser.AntsparkLexer;
import com.alibaba.druid.sql.dialect.antspark.parser.AntsparkStatementParser;
import com.alibaba.druid.sql.dialect.blink.parser.BlinkStatementParser;
import com.alibaba.druid.sql.dialect.clickhouse.parser.ClickhouseExprParser;
import com.alibaba.druid.sql.dialect.clickhouse.parser.ClickhouseLexer;
import com.alibaba.druid.sql.dialect.clickhouse.parser.ClickhouseStatementParser;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.parser.DB2ExprParser;
import com.alibaba.druid.sql.dialect.db2.parser.DB2Lexer;
import com.alibaba.druid.sql.dialect.db2.parser.DB2StatementParser;
import com.alibaba.druid.sql.dialect.h2.parser.H2ExprParser;
import com.alibaba.druid.sql.dialect.h2.parser.H2Lexer;
import com.alibaba.druid.sql.dialect.h2.parser.H2StatementParser;
import com.alibaba.druid.sql.dialect.hive.parser.HiveExprParser;
import com.alibaba.druid.sql.dialect.hive.parser.HiveStatementParser;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlExprParser;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlLexer;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsSelectQueryBlock;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsLexer;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsStatementParser;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleLexer;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.druid.sql.dialect.oscar.ast.stmt.OscarSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oscar.parser.OscarExprParser;
import com.alibaba.druid.sql.dialect.oscar.parser.OscarLexer;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixExprParser;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixLexer;
import com.alibaba.druid.sql.dialect.phoenix.parser.PhoenixStatementParser;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGLexer;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSQLStatementParser;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoExprParser;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoLexer;
import com.alibaba.druid.sql.dialect.presto.parser.PrestoStatementParser;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerSelectQueryBlock;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.alibaba.druid.sql.dialect.starrocks.parser.StarRocksExprParser;
import com.alibaba.druid.sql.dialect.starrocks.parser.StarRocksLexer;
import com.alibaba.druid.sql.dialect.starrocks.parser.StarRocksStatementParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.SQLType;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.VisitorFeature;
import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class SQLParserUtils {
    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType) {
        SQLParserFeature[] features = DbType.odps == dbType || DbType.mysql == dbType ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType, boolean keepComments) {
        SQLParserFeature[] features = keepComments ? new SQLParserFeature[]{SQLParserFeature.KeepComments} : new SQLParserFeature[]{};
        return SQLParserUtils.createSQLStatementParser(sql, dbType, features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, String dbType, SQLParserFeature ... features) {
        return SQLParserUtils.createSQLStatementParser(sql, dbType == null ? null : DbType.valueOf(dbType), features);
    }

    public static SQLStatementParser createSQLStatementParser(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: 
            case oceanbase_oracle: {
                return new OracleStatementParser(sql, features);
            }
            case mysql: 
            case tidb: 
            case mariadb: 
            case drds: {
                return new MySqlStatementParser(sql, features);
            }
            case elastic_search: {
                MySqlStatementParser parser = new MySqlStatementParser(sql, features);
                parser.dbType = dbType;
                parser.exprParser.dbType = dbType;
                return parser;
            }
            case postgresql: 
            case edb: {
                return new PGSQLStatementParser(sql, features);
            }
            case sqlserver: 
            case jtds: {
                return new SQLServerStatementParser(sql, features);
            }
            case h2: {
                return new H2StatementParser(sql, features);
            }
            case blink: {
                return new BlinkStatementParser(sql, features);
            }
            case db2: {
                return new DB2StatementParser(sql, features);
            }
            case odps: {
                return new OdpsStatementParser(sql, features);
            }
            case phoenix: {
                return new PhoenixStatementParser(sql);
            }
            case hive: {
                return new HiveStatementParser(sql, features);
            }
            case presto: 
            case trino: {
                return new PrestoStatementParser(sql);
            }
            case ads: {
                return new AdsStatementParser(sql);
            }
            case antspark: {
                return new AntsparkStatementParser(sql);
            }
            case clickhouse: {
                return new ClickhouseStatementParser(sql);
            }
            case starrocks: {
                return new StarRocksStatementParser(sql);
            }
        }
        return new SQLStatementParser(sql, dbType);
    }

    public static SQLExprParser createExprParser(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleExprParser(sql, features);
            }
            case mysql: 
            case mariadb: {
                return new MySqlExprParser(sql, features);
            }
            case elastic_search: {
                MySqlExprParser parser = new MySqlExprParser(sql, features);
                parser.dbType = dbType;
                return parser;
            }
            case h2: {
                return new H2ExprParser(sql, features);
            }
            case postgresql: 
            case edb: {
                return new PGExprParser(sql, features);
            }
            case sqlserver: 
            case jtds: {
                return new SQLServerExprParser(sql, features);
            }
            case db2: {
                return new DB2ExprParser(sql, features);
            }
            case odps: {
                return new OdpsExprParser(sql, features);
            }
            case phoenix: {
                return new PhoenixExprParser(sql, features);
            }
            case presto: 
            case trino: {
                return new PrestoExprParser(sql, features);
            }
            case hive: {
                return new HiveExprParser(sql, features);
            }
            case clickhouse: {
                return new ClickhouseExprParser(sql, features);
            }
            case oscar: {
                return new OscarExprParser(sql, features);
            }
            case starrocks: {
                return new StarRocksExprParser(sql, features);
            }
        }
        return new SQLExprParser(sql, dbType, features);
    }

    public static Lexer createLexer(String sql, DbType dbType) {
        return SQLParserUtils.createLexer(sql, dbType, new SQLParserFeature[0]);
    }

    public static Lexer createLexer(String sql, DbType dbType, SQLParserFeature ... features) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case oracle: {
                return new OracleLexer(sql, features);
            }
            case mysql: 
            case mariadb: {
                return new MySqlLexer(sql, features);
            }
            case elastic_search: {
                MySqlLexer lexer = new MySqlLexer(sql, features);
                lexer.dbType = dbType;
                return lexer;
            }
            case h2: {
                return new H2Lexer(sql, features);
            }
            case postgresql: 
            case edb: {
                return new PGLexer(sql, features);
            }
            case db2: {
                return new DB2Lexer(sql, features);
            }
            case odps: {
                return new OdpsLexer(sql, features);
            }
            case phoenix: {
                return new PhoenixLexer(sql, features);
            }
            case presto: 
            case trino: {
                return new PrestoLexer(sql, features);
            }
            case antspark: {
                return new AntsparkLexer(sql);
            }
            case oscar: {
                return new OscarLexer(sql, features);
            }
            case clickhouse: {
                return new ClickhouseLexer(sql, features);
            }
            case starrocks: {
                return new StarRocksLexer(sql, features);
            }
        }
        Lexer lexer = new Lexer(sql, null, dbType);
        for (SQLParserFeature feature : features) {
            lexer.config(feature, true);
        }
        return lexer;
    }

    public static SQLSelectQueryBlock createSelectQueryBlock(DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        switch (dbType) {
            case mysql: {
                return new MySqlSelectQueryBlock();
            }
            case oracle: {
                return new OracleSelectQueryBlock();
            }
            case db2: {
                return new DB2SelectQueryBlock();
            }
            case postgresql: {
                return new PGSelectQueryBlock();
            }
            case odps: {
                return new OdpsSelectQueryBlock();
            }
            case sqlserver: {
                return new SQLServerSelectQueryBlock();
            }
            case oscar: {
                return new OscarSelectQueryBlock();
            }
        }
        return new SQLSelectQueryBlock(dbType);
    }

    public static SQLType getSQLType(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        return lexer.scanSQLType();
    }

    public static SQLType getSQLTypeV2(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        return lexer.scanSQLTypeV2();
    }

    public static boolean startsWithHint(String sql, DbType dbType) {
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        return lexer.token() == Token.HINT;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token1, Token token2) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token1 && tok != token2);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token token1, Token token2, Token token3) {
        Token tok;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        do {
            lexer.nextToken();
            tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
        } while (tok != token1 && tok != token2 && tok != token3);
        return true;
    }

    public static boolean containsAny(String sql, DbType dbType, Token ... tokens) {
        if (tokens == null) {
            return false;
        }
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        block3: while (true) {
            lexer.nextToken();
            Token tok = lexer.token;
            switch (tok) {
                case EOF: 
                case ERROR: {
                    return false;
                }
            }
            int i = 0;
            while (true) {
                if (i >= tokens.length) continue block3;
                if (tokens[i] == tok) {
                    return true;
                }
                ++i;
            }
            break;
        }
    }

    public static Object getSimpleSelectValue(String sql, DbType dbType) {
        return SQLParserUtils.getSimpleSelectValue(sql, dbType, null);
    }

    public static Object getSimpleSelectValue(String sql, DbType dbType, SimpleValueEvalHandler handler) {
        Object value;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        if (lexer.token != Token.SELECT && lexer.token != Token.VALUES) {
            return null;
        }
        lexer.nextTokenValue();
        SQLExpr expr = null;
        switch (lexer.token) {
            case LITERAL_INT: {
                value = lexer.integerValue();
                break;
            }
            case LITERAL_CHARS: 
            case LITERAL_NCHARS: {
                value = lexer.stringVal();
                break;
            }
            case LITERAL_FLOAT: {
                value = lexer.decimalValue();
                break;
            }
            default: {
                if (handler == null) {
                    return null;
                }
                expr = new SQLExprParser(lexer).expr();
                try {
                    value = handler.eval(expr);
                    break;
                }
                catch (Exception error) {
                    value = null;
                }
            }
        }
        lexer.nextToken();
        if (lexer.token == Token.FROM) {
            lexer.nextToken();
            if (lexer.token == Token.DUAL) {
                lexer.nextToken();
            } else {
                return null;
            }
        }
        if (lexer.token != Token.EOF) {
            return null;
        }
        return value;
    }

    public static String replaceBackQuote(String sql, DbType dbType) {
        int i = sql.indexOf(96);
        if (i == -1) {
            return sql;
        }
        char[] chars = sql.toCharArray();
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        int len = chars.length;
        int off = 0;
        block4: while (true) {
            lexer.nextToken();
            switch (lexer.token) {
                case IDENTIFIER: {
                    int p0 = lexer.startPos + off;
                    int p1 = lexer.pos - 1 + off;
                    char c0 = chars[p0];
                    char c1 = chars[p1];
                    if (c0 != '`' || c1 != '`') continue block4;
                    if (p1 - p0 > 2 && chars[p0 + 1] == '\'' && chars[p1 - 1] == '\'') {
                        System.arraycopy(chars, p0 + 1, chars, p0, p1 - p0 - 1);
                        System.arraycopy(chars, p1 + 1, chars, p1 - 1, chars.length - p1 - 1);
                        len -= 2;
                        off -= 2;
                        continue block4;
                    }
                    chars[p0] = 34;
                    chars[p1] = 34;
                    continue block4;
                }
                case EOF: 
                case ERROR: {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        return new String(chars, 0, len);
    }

    public static String addBackQuote(String sql, DbType dbType) {
        if (StringUtils.isEmpty(sql)) {
            return sql;
        }
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        StringBuffer buf = new StringBuffer(sql.length() + 20);
        SQLASTOutputVisitor out = SQLUtils.createOutputVisitor(buf, DbType.mysql);
        out.config(VisitorFeature.OutputNameQuote, true);
        SQLType sqlType = SQLParserUtils.getSQLType(sql, dbType);
        if (sqlType == SQLType.INSERT) {
            parser.config(SQLParserFeature.InsertReader, true);
            SQLInsertStatement stmt = (SQLInsertStatement)parser.parseStatement();
            int startPos = parser.getLexer().startPos;
            stmt.accept(out);
            if (stmt.getQuery() == null) {
                buf.append(' ');
                buf.append(sql, startPos, sql.length());
            }
        } else {
            SQLStatement stmt = parser.parseStatement();
            stmt.accept(out);
        }
        return buf.toString();
    }

    public static List<String> split(String sql, DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        boolean script = false;
        if (dbType == DbType.odps && lexer.token == Token.VARIANT) {
            script = true;
        }
        if (script) {
            return Collections.singletonList(sql);
        }
        ArrayList<String> list = new ArrayList<String>();
        Lexer lexer2 = SQLParserUtils.createLexer(sql, dbType);
        lexer2.config(SQLParserFeature.SkipComments, false);
        lexer2.config(SQLParserFeature.KeepComments, true);
        boolean set = false;
        boolean paiOrJar = false;
        int start = 0;
        Token token = lexer2.token;
        while (lexer2.token != Token.EOF) {
            if (token == Token.SEMI) {
                int len = lexer2.startPos - start;
                if (len > 0) {
                    String lineSql = sql.substring(start, lexer2.startPos);
                    if (!(lineSql = lineSql.trim()).isEmpty()) {
                        list.add(lineSql);
                    }
                }
                start = lexer2.startPos + 1;
                set = false;
            } else {
                if (token == Token.CREATE) {
                    lexer2.nextToken();
                    if (lexer2.token == Token.FUNCTION || lexer2.identifierEquals("FUNCTION")) {
                        lexer2.nextToken();
                        lexer2.nextToken();
                        if (lexer2.token == Token.AS) {
                            lexer2.nextToken();
                            if (lexer2.token == Token.LITERAL_CHARS) {
                                lexer2.nextToken();
                                token = lexer2.token;
                                continue;
                            }
                        }
                        lexer2.startPos = sql.length();
                        break;
                    }
                    token = lexer2.token;
                    continue;
                }
                if (set && token == Token.EQ && dbType == DbType.odps) {
                    lexer2.nextTokenForSet();
                    token = lexer2.token;
                    continue;
                }
            }
            if (lexer2.identifierEquals("USING")) {
                lexer2.nextToken();
                if (lexer2.identifierEquals("jar")) {
                    lexer2.nextToken();
                }
            }
            if (lexer2.token == Token.SET) {
                set = true;
            }
            if (lexer2.identifierEquals("ADD") && (dbType == DbType.hive || dbType == DbType.odps)) {
                lexer2.nextToken();
                if (lexer2.identifierEquals("JAR")) {
                    lexer2.nextPath();
                }
            } else {
                lexer2.nextToken();
            }
            token = lexer2.token;
        }
        if (start != sql.length() && token != Token.SEMI) {
            int end = lexer2.startPos;
            if (end > sql.length()) {
                end = sql.length();
            }
            String splitSql = sql.substring(start, end).trim();
            if (!paiOrJar) {
                splitSql = SQLParserUtils.removeComment(splitSql, dbType).trim();
            } else if (splitSql.endsWith(";")) {
                splitSql = splitSql.substring(0, splitSql.length() - 1).trim();
            }
            if (!splitSql.isEmpty()) {
                list.add(splitSql);
            }
        }
        return list;
    }

    public static List<String> splitAndRemoveComment(String sql, DbType dbType) {
        String splitSql;
        if (dbType == null) {
            dbType = DbType.other;
        }
        boolean containsCommentAndSemi = false;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.config(SQLParserFeature.SkipComments, false);
        lexer.config(SQLParserFeature.KeepComments, true);
        while (lexer.token != Token.EOF) {
            if (lexer.token == Token.LINE_COMMENT || lexer.token == Token.MULTI_LINE_COMMENT || lexer.token == Token.SEMI) {
                containsCommentAndSemi = true;
                break;
            }
            lexer.nextToken();
        }
        if (!containsCommentAndSemi) {
            return Collections.singletonList(sql);
        }
        lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        boolean script = false;
        if (dbType == DbType.odps && lexer.token == Token.VARIANT) {
            script = true;
        }
        if (script || lexer.identifierEquals("pai") || lexer.identifierEquals("jar") || lexer.identifierEquals("copy")) {
            return Collections.singletonList(sql);
        }
        ArrayList<String> list = new ArrayList<String>();
        Lexer lexer2 = SQLParserUtils.createLexer(sql, dbType);
        lexer2.config(SQLParserFeature.SkipComments, false);
        lexer2.config(SQLParserFeature.KeepComments, true);
        lexer2.nextToken();
        boolean set = false;
        boolean paiOrJar = false;
        int start = 0;
        Token preToken = null;
        int prePos = 0;
        Token token = lexer2.token;
        Token startToken = lexer2.token;
        while (token == Token.LINE_COMMENT || token == Token.MULTI_LINE_COMMENT) {
            lexer2.nextToken();
            startToken = token = lexer2.token;
            start = lexer2.startPos;
        }
        while (lexer2.token != Token.EOF) {
            int len;
            if (token == Token.SEMI) {
                len = lexer2.startPos - start;
                if (len > 0) {
                    String splitSql2;
                    String lineSql = sql.substring(start, lexer2.startPos);
                    String string = splitSql2 = set ? SQLParserUtils.removeLeftComment(lineSql, dbType) : SQLParserUtils.removeComment(lineSql, dbType).trim();
                    if (!splitSql2.isEmpty()) {
                        list.add(splitSql2);
                    }
                }
                lexer2.nextToken();
                token = lexer2.token;
                start = lexer2.startPos;
                startToken = token;
                set = false;
                continue;
            }
            if (token == Token.MULTI_LINE_COMMENT) {
                len = lexer2.startPos - start;
                if (len > 0 && !(splitSql = SQLParserUtils.removeComment(sql.substring(start, lexer2.startPos), dbType).trim()).isEmpty()) {
                    list.add(splitSql);
                }
                lexer2.nextToken();
                token = lexer2.token;
                start = lexer2.startPos;
                startToken = token;
                continue;
            }
            if (token == Token.CREATE) {
                lexer2.nextToken();
                if (lexer2.token == Token.FUNCTION || lexer2.identifierEquals("FUNCTION")) {
                    lexer2.nextToken();
                    lexer2.nextToken();
                    if (lexer2.token == Token.AS) {
                        lexer2.nextToken();
                        if (lexer2.token == Token.LITERAL_CHARS) {
                            lexer2.nextToken();
                            token = lexer2.token;
                            continue;
                        }
                    }
                    lexer2.startPos = sql.length();
                    break;
                }
                token = lexer2.token;
                continue;
            }
            if (set && token == Token.EQ && dbType == DbType.odps) {
                lexer2.nextTokenForSet();
                token = lexer2.token;
                continue;
            }
            if (dbType == DbType.odps && (preToken == null || preToken == Token.LINE_COMMENT || preToken == Token.SEMI) && (lexer2.identifierEquals("pai") || lexer2.identifierEquals("jar") || lexer2.identifierEquals("copy"))) {
                lexer2.scanLineArgument();
                paiOrJar = true;
            }
            if (lexer2.identifierEquals("USING")) {
                lexer2.nextToken();
                if (lexer2.identifierEquals("jar")) {
                    lexer2.nextToken();
                }
            }
            if (lexer2.token == Token.SET) {
                set = true;
            }
            prePos = lexer2.pos;
            if (lexer2.identifierEquals("ADD") && (dbType == DbType.hive || dbType == DbType.odps)) {
                lexer2.nextToken();
                if (lexer2.identifierEquals("JAR")) {
                    lexer2.nextPath();
                }
            } else {
                lexer2.nextToken();
            }
            preToken = token;
            token = lexer2.token;
            if (token != Token.LINE_COMMENT || startToken != Token.SEMI && startToken != Token.LINE_COMMENT && startToken != Token.MULTI_LINE_COMMENT) continue;
            start = lexer2.pos;
            startToken = token;
        }
        if (start != sql.length() && token != Token.SEMI) {
            int end = lexer2.startPos;
            if (end > sql.length()) {
                end = sql.length();
            }
            splitSql = sql.substring(start, end).trim();
            if (!paiOrJar) {
                splitSql = SQLParserUtils.removeComment(splitSql, dbType).trim();
            } else if (splitSql.endsWith(";")) {
                splitSql = splitSql.substring(0, splitSql.length() - 1).trim();
            }
            if (!splitSql.isEmpty()) {
                list.add(splitSql);
            }
        }
        return list;
    }

    public static String removeLeftComment(String sql, DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        if ((sql = sql.trim()).startsWith("jar")) {
            return sql;
        }
        boolean containsComment = false;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.config(SQLParserFeature.SkipComments, false);
        lexer.config(SQLParserFeature.KeepComments, true);
        while (lexer.token != Token.EOF) {
            if (lexer.token == Token.LINE_COMMENT || lexer.token == Token.MULTI_LINE_COMMENT) {
                containsComment = true;
                break;
            }
            lexer.nextToken();
        }
        if (!containsComment) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        Lexer lexer2 = SQLParserUtils.createLexer(sql, dbType);
        lexer2.config(SQLParserFeature.SkipComments, false);
        lexer2.config(SQLParserFeature.KeepComments, true);
        lexer2.nextToken();
        int start = 0;
        while (lexer2.token != Token.EOF) {
            if (lexer2.token != Token.LINE_COMMENT && lexer2.token != Token.MULTI_LINE_COMMENT) {
                start = lexer2.startPos;
                break;
            }
            lexer2.nextToken();
        }
        if (start != sql.length()) {
            sb.append(sql.substring(start, sql.length()));
        }
        return sb.toString();
    }

    public static String removeComment(String sql, DbType dbType) {
        if (dbType == null) {
            dbType = DbType.other;
        }
        if ((sql = sql.trim()).startsWith("jar")) {
            return sql;
        }
        if ((sql.startsWith("pai") || sql.startsWith("PAI")) && sql.indexOf(59) == -1) {
            return sql;
        }
        boolean containsComment = false;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.config(SQLParserFeature.SkipComments, false);
        lexer.config(SQLParserFeature.KeepComments, true);
        while (lexer.token != Token.EOF) {
            if (lexer.token == Token.LINE_COMMENT || lexer.token == Token.MULTI_LINE_COMMENT) {
                containsComment = true;
                break;
            }
            lexer.nextToken();
        }
        if (!containsComment) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        Lexer lexer2 = SQLParserUtils.createLexer(sql, dbType);
        lexer2.config(SQLParserFeature.SkipComments, false);
        lexer2.config(SQLParserFeature.KeepComments, true);
        int start = 0;
        Token token = lexer2.token;
        while (lexer2.token != Token.EOF) {
            int len;
            if (token == Token.LINE_COMMENT) {
                len = lexer2.startPos - start;
                if (len > 0) {
                    sb.append(sql.substring(start, lexer2.startPos));
                }
                start = lexer2.startPos + lexer2.stringVal().length();
                if (lexer2.startPos > 1 && lexer2.text.charAt(lexer2.startPos - 1) == '\n') {
                    while (start + 1 < lexer2.text.length() && lexer2.text.charAt(start) == '\n') {
                        ++start;
                    }
                }
            } else if (token == Token.MULTI_LINE_COMMENT) {
                len = lexer2.startPos - start;
                if (len > 0) {
                    sb.append(sql.substring(start, lexer2.startPos));
                }
                start = lexer2.startPos + lexer2.stringVal().length();
            }
            if (lexer2.identifierEquals("ADD")) {
                lexer2.nextToken();
                if (lexer2.identifierEquals("JAR")) {
                    lexer2.nextPath();
                }
            } else {
                lexer2.nextToken();
            }
            token = lexer2.token;
        }
        if (start != sql.length() && token != Token.LINE_COMMENT && token != Token.MULTI_LINE_COMMENT) {
            sb.append(sql.substring(start, sql.length()));
        }
        return sb.toString();
    }

    public static List<String> getTables(String sql, DbType dbType) {
        SQLExprParser exprParser;
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        boolean set = false;
        Lexer lexer = SQLParserUtils.createLexer(sql, dbType);
        lexer.nextToken();
        switch (dbType) {
            case odps: {
                exprParser = new OdpsExprParser(lexer);
                break;
            }
            case mysql: {
                exprParser = new MySqlExprParser(lexer);
                break;
            }
            default: {
                exprParser = new SQLExprParser(lexer);
            }
        }
        block11: while (lexer.token != Token.EOF) {
            switch (lexer.token) {
                case CREATE: 
                case DROP: 
                case ALTER: {
                    set = false;
                    lexer.nextToken();
                    if (lexer.token != Token.TABLE) continue block11;
                    lexer.nextToken();
                    if (lexer.token == Token.IF) {
                        lexer.nextToken();
                        if (lexer.token == Token.NOT) {
                            lexer.nextToken();
                        }
                        if (lexer.token == Token.EXISTS) {
                            lexer.nextToken();
                        }
                    }
                    SQLName name = exprParser.name();
                    tables.add(name.toString());
                    if (lexer.token != Token.AS) continue block11;
                    lexer.nextToken();
                    continue block11;
                }
                case FROM: 
                case JOIN: {
                    lexer.nextToken();
                    if (lexer.token == Token.LPAREN || lexer.token == Token.VALUES) continue block11;
                    SQLName name = exprParser.name();
                    tables.add(name.toString());
                    continue block11;
                }
                case SEMI: {
                    set = false;
                    break;
                }
                case SET: {
                    set = true;
                    break;
                }
                case EQ: {
                    if (!set || dbType != DbType.odps) break;
                    lexer.nextTokenForSet();
                    continue block11;
                }
            }
            lexer.nextToken();
        }
        return new ArrayList<String>(tables);
    }

    public static interface SimpleValueEvalHandler {
        public Object eval(SQLExpr var1);
    }
}

