/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.h2.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.h2.parser.H2ExprParser;
import com.alibaba.druid.sql.dialect.h2.parser.H2SelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;

public class H2StatementParser
extends SQLStatementParser {
    public H2StatementParser(String sql) {
        super(new H2ExprParser(sql));
    }

    public H2StatementParser(String sql, SQLParserFeature ... features) {
        super(new H2ExprParser(sql, features));
    }

    public H2StatementParser(Lexer lexer) {
        super(new H2ExprParser(lexer));
    }

    @Override
    public H2SelectParser createSQLSelectParser() {
        return new H2SelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLStatement parseMerge() {
        this.accept(Token.MERGE);
        this.accept(Token.INTO);
        SQLReplaceStatement stmt = new SQLReplaceStatement();
        stmt.setDbType("h2");
        SQLName tableName = this.exprParser.name();
        stmt.setTableName(tableName);
        if (this.lexer.token() == Token.KEY) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.exprList(stmt.getColumns(), stmt);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES || this.lexer.identifierEquals("VALUE")) {
            this.lexer.nextToken();
            this.parseValueClause(stmt.getValuesList(), 0, stmt);
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr);
        } else if (this.lexer.token() == Token.LPAREN) {
            SQLSelect select = this.createSQLSelectParser().select();
            SQLQueryExpr queryExpr = new SQLQueryExpr(select);
            stmt.setQuery(queryExpr);
        }
        return stmt;
    }
}

