/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlObjectImpl;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAlterColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableCharacter;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableOption;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlShowColumnOutpuVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MySqlCreateTableStatement
extends SQLCreateTableStatement
implements MySqlStatement {
    private Map<String, SQLObject> tableOptions = new LinkedHashMap<String, SQLObject>();
    private SQLPartitionBy partitioning;
    private List<SQLCommentHint> hints = new ArrayList<SQLCommentHint>();
    private List<SQLCommentHint> optionHints = new ArrayList<SQLCommentHint>();
    private SQLName tableGroup;

    public MySqlCreateTableStatement() {
        super("mysql");
    }

    public List<SQLCommentHint> getHints() {
        return this.hints;
    }

    public void setHints(List<SQLCommentHint> hints) {
        this.hints = hints;
    }

    public void setTableOptions(Map<String, SQLObject> tableOptions) {
        this.tableOptions = tableOptions;
    }

    public SQLPartitionBy getPartitioning() {
        return this.partitioning;
    }

    public void setPartitioning(SQLPartitionBy partitioning) {
        this.partitioning = partitioning;
    }

    public Map<String, SQLObject> getTableOptions() {
        return this.tableOptions;
    }

    @Deprecated
    public SQLSelect getQuery() {
        return this.select;
    }

    @Deprecated
    public void setQuery(SQLSelect query) {
        this.select = query;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (!(visitor instanceof MySqlASTVisitor)) {
            throw new IllegalArgumentException("not support visitor type : " + visitor.getClass().getName());
        }
        this.accept0((MySqlASTVisitor)visitor);
    }

    @Override
    public void accept0(MySqlASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.getHints());
            this.acceptChild((SQLASTVisitor)visitor, this.getTableSource());
            this.acceptChild((SQLASTVisitor)visitor, this.getTableElementList());
            this.acceptChild((SQLASTVisitor)visitor, this.getLike());
            this.acceptChild((SQLASTVisitor)visitor, this.getSelect());
        }
        visitor.endVisit(this);
    }

    public List<SQLCommentHint> getOptionHints() {
        return this.optionHints;
    }

    public void setOptionHints(List<SQLCommentHint> optionHints) {
        this.optionHints = optionHints;
    }

    public SQLName getTableGroup() {
        return this.tableGroup;
    }

    public void setTableGroup(SQLName tableGroup) {
        this.tableGroup = tableGroup;
    }

    @Override
    public void simplify() {
        this.tableOptions.clear();
        super.simplify();
    }

    public void showCoumns(Appendable out) throws IOException {
        this.accept(new MySqlShowColumnOutpuVisitor(out));
    }

    public boolean apply(MySqlRenameTableStatement x) {
        for (MySqlRenameTableStatement.Item item : x.getItems()) {
            if (!this.apply(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean alterApply(SQLAlterTableItem item) {
        if (item instanceof MySqlAlterTableAlterColumn) {
            return this.apply((MySqlAlterTableAlterColumn)item);
        }
        if (item instanceof MySqlAlterTableChangeColumn) {
            return this.apply((MySqlAlterTableChangeColumn)item);
        }
        if (item instanceof MySqlAlterTableCharacter) {
            return this.apply((MySqlAlterTableCharacter)item);
        }
        if (item instanceof MySqlAlterTableModifyColumn) {
            return this.apply((MySqlAlterTableModifyColumn)item);
        }
        if (item instanceof MySqlAlterTableOption) {
            return this.apply((MySqlAlterTableOption)item);
        }
        return super.alterApply(item);
    }

    @Override
    public boolean apply(SQLAlterTableAddIndex item) {
        if (item.isUnique()) {
            MySqlUnique x = new MySqlUnique();
            item.cloneTo(x);
            x.setParent(this);
            this.tableElementList.add(x);
            return true;
        }
        if (item.isKey()) {
            MySqlKey x = new MySqlKey();
            item.cloneTo(x);
            x.setParent(this);
            this.tableElementList.add(x);
            return true;
        }
        MySqlTableIndex x = new MySqlTableIndex();
        item.cloneTo(x);
        x.setParent(this);
        this.tableElementList.add(x);
        return true;
    }

    public boolean apply(MySqlAlterTableOption item) {
        this.tableOptions.put(item.getName(), item.getValue());
        return true;
    }

    public boolean apply(MySqlAlterTableCharacter item) {
        SQLExpr collate;
        SQLExpr charset = item.getCharacterSet();
        if (charset != null) {
            this.tableOptions.put("CHARACTER SET", charset);
        }
        if ((collate = item.getCollate()) != null) {
            this.tableOptions.put("COLLATE", collate);
        }
        return true;
    }

    public boolean apply(MySqlRenameTableStatement.Item item) {
        if (!SQLUtils.nameEquals(item.getName(), this.getName())) {
            return false;
        }
        this.setName(item.getTo().clone());
        return true;
    }

    public boolean apply(MySqlAlterTableAlterColumn x) {
        int columnIndex = this.columnIndexOf(x.getColumn());
        if (columnIndex == -1) {
            return false;
        }
        SQLExpr defaultExpr = x.getDefaultExpr();
        SQLColumnDefinition column = (SQLColumnDefinition)this.tableElementList.get(columnIndex);
        if (x.isDropDefault()) {
            column.setDefaultExpr(null);
        } else if (defaultExpr != null) {
            column.setDefaultExpr(defaultExpr);
        }
        return true;
    }

    public boolean apply(MySqlAlterTableChangeColumn item) {
        SQLName columnName = item.getColumnName();
        int columnIndex = this.columnIndexOf(columnName);
        if (columnIndex == -1) {
            return false;
        }
        int afterIndex = this.columnIndexOf(item.getAfterColumn());
        int beforeIndex = this.columnIndexOf(item.getFirstColumn());
        int insertIndex = -1;
        if (beforeIndex != -1) {
            insertIndex = beforeIndex;
        } else if (afterIndex != -1) {
            insertIndex = afterIndex + 1;
        } else if (item.isFirst()) {
            insertIndex = 0;
        }
        SQLColumnDefinition column = item.getNewColumnDefinition().clone();
        column.setParent(this);
        if (insertIndex == -1 || insertIndex == columnIndex) {
            this.tableElementList.set(columnIndex, column);
        } else if (insertIndex > columnIndex) {
            this.tableElementList.add(insertIndex, column);
            this.tableElementList.remove(columnIndex);
        } else {
            this.tableElementList.remove(columnIndex);
            this.tableElementList.add(insertIndex, column);
        }
        for (int i = 0; i < this.tableElementList.size(); ++i) {
            SQLTableElement e = (SQLTableElement)this.tableElementList.get(i);
            if (e instanceof MySqlTableIndex) {
                ((MySqlTableIndex)e).applyColumnRename(columnName, column.getName());
                continue;
            }
            if (!(e instanceof SQLUnique)) continue;
            SQLUnique unique = (SQLUnique)e;
            unique.applyColumnRename(columnName, column.getName());
        }
        return true;
    }

    public boolean apply(MySqlAlterTableModifyColumn item) {
        SQLColumnDefinition column = item.getNewColumnDefinition().clone();
        SQLName columnName = column.getName();
        int columnIndex = this.columnIndexOf(columnName);
        if (columnIndex == -1) {
            return false;
        }
        int afterIndex = this.columnIndexOf(item.getAfterColumn());
        int beforeIndex = this.columnIndexOf(item.getFirstColumn());
        int insertIndex = -1;
        if (beforeIndex != -1) {
            insertIndex = beforeIndex;
        } else if (afterIndex != -1) {
            insertIndex = afterIndex + 1;
        }
        column.setParent(this);
        if (insertIndex == -1 || insertIndex == columnIndex) {
            this.tableElementList.set(columnIndex, column);
            return true;
        }
        if (insertIndex > columnIndex) {
            this.tableElementList.add(insertIndex, column);
            this.tableElementList.remove(columnIndex);
        } else {
            this.tableElementList.remove(columnIndex);
            this.tableElementList.add(insertIndex, column);
        }
        return true;
    }

    @Override
    public void output(StringBuffer buf) {
        this.accept(new MySqlOutputVisitor(buf));
    }

    public void cloneTo(MySqlCreateTableStatement x) {
        SQLCommentHint h2;
        super.cloneTo(x);
        for (Map.Entry<String, SQLObject> entry : this.tableOptions.entrySet()) {
            SQLObject obj = entry.getValue().clone();
            obj.setParent(x);
            x.tableOptions.put(entry.getKey(), obj);
        }
        if (this.partitioning != null) {
            x.setPartitioning(this.partitioning.clone());
        }
        for (SQLCommentHint hint : this.hints) {
            h2 = hint.clone();
            h2.setParent(x);
            x.hints.add(h2);
        }
        for (SQLCommentHint hint : this.optionHints) {
            h2 = hint.clone();
            h2.setParent(x);
            x.optionHints.add(h2);
        }
        if (this.like != null) {
            x.setLike(this.like.clone());
        }
        if (this.tableGroup != null) {
            x.setTableGroup(this.tableGroup.clone());
        }
    }

    @Override
    public MySqlCreateTableStatement clone() {
        MySqlCreateTableStatement x = new MySqlCreateTableStatement();
        this.cloneTo(x);
        return x;
    }

    public static class TableSpaceOption
    extends MySqlObjectImpl {
        private SQLName name;
        private SQLExpr storage;

        public SQLName getName() {
            return this.name;
        }

        public void setName(SQLName name) {
            if (name != null) {
                name.setParent(this);
            }
            this.name = name;
        }

        public SQLExpr getStorage() {
            return this.storage;
        }

        public void setStorage(SQLExpr storage) {
            if (storage != null) {
                storage.setParent(this);
            }
            this.storage = storage;
        }

        @Override
        public void accept0(MySqlASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild((SQLASTVisitor)visitor, this.getName());
                this.acceptChild((SQLASTVisitor)visitor, this.getStorage());
            }
            visitor.endVisit(this);
        }

        @Override
        public TableSpaceOption clone() {
            TableSpaceOption x = new TableSpaceOption();
            if (this.name != null) {
                x.setName(this.name.clone());
            }
            if (this.storage != null) {
                x.setStorage(this.storage.clone());
            }
            return x;
        }
    }
}

