/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class SQLExprTableSource
extends SQLTableSourceImpl {
    protected SQLExpr expr;
    private List<SQLName> partitions;
    private SchemaObject schemaObject;

    public SQLExprTableSource() {
    }

    public SQLExprTableSource(SQLExpr expr) {
        this(expr, null);
    }

    public SQLExprTableSource(SQLExpr expr, String alias) {
        this.setExpr(expr);
        this.setAlias(alias);
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    public void setExpr(String name) {
        this.setExpr(new SQLIdentifierExpr(name));
    }

    public SQLName getName() {
        if (this.expr instanceof SQLName) {
            return (SQLName)this.expr;
        }
        return null;
    }

    public String getSchema() {
        if (this.expr == null) {
            return null;
        }
        if (this.expr instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)this.expr).getOwnernName();
        }
        return null;
    }

    public void setSchema(String schema) {
        if (this.expr instanceof SQLIdentifierExpr) {
            if (schema == null) {
                return;
            }
            String ident = ((SQLIdentifierExpr)this.expr).getName();
            this.setExpr(new SQLPropertyExpr(schema, ident));
        } else if (this.expr instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)this.expr;
            if (schema == null) {
                this.setExpr(new SQLIdentifierExpr(propertyExpr.getName()));
            } else {
                propertyExpr.setOwner(schema);
            }
        }
    }

    public List<SQLName> getPartitions() {
        if (this.partitions == null) {
            this.partitions = new ArrayList<SQLName>(2);
        }
        return this.partitions;
    }

    public int getPartitionSize() {
        if (this.partitions == null) {
            return 0;
        }
        return this.partitions.size();
    }

    public void addPartition(SQLName partition) {
        if (partition != null) {
            partition.setParent(this);
        }
        if (this.partitions == null) {
            this.partitions = new ArrayList<SQLName>(2);
        }
        this.partitions.add(partition);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.expr);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        this.expr.output(buf);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLExprTableSource that = (SQLExprTableSource)o;
        if (this.expr != null ? !this.expr.equals(that.expr) : that.expr != null) {
            return false;
        }
        return this.partitions != null ? this.partitions.equals(that.partitions) : that.partitions == null;
    }

    public int hashCode() {
        int result = this.expr != null ? this.expr.hashCode() : 0;
        result = 31 * result + (this.partitions != null ? this.partitions.hashCode() : 0);
        return result;
    }

    @Override
    public String computeAlias() {
        String alias = this.getAlias();
        if (alias == null && this.expr instanceof SQLName) {
            alias = ((SQLName)this.expr).getSimpleName();
        }
        return SQLUtils.normalize(alias);
    }

    @Override
    public SQLExprTableSource clone() {
        SQLExprTableSource x = new SQLExprTableSource();
        this.cloneTo(x);
        return x;
    }

    public void cloneTo(SQLExprTableSource x) {
        x.alias = this.alias;
        if (this.expr != null) {
            x.expr = this.expr.clone();
        }
        if (this.partitions != null) {
            for (SQLName p : this.partitions) {
                SQLName p1 = p.clone();
                x.addPartition(p1);
            }
        }
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }

    @Override
    public boolean containsAlias(String alias) {
        if (SQLUtils.nameEquals(this.alias, alias)) {
            return true;
        }
        String name = null;
        if (this.expr instanceof SQLIdentifierExpr) {
            name = ((SQLIdentifierExpr)this.expr).getName();
        } else if (this.expr instanceof SQLPropertyExpr) {
            name = ((SQLPropertyExpr)this.expr).getName();
        }
        return name != null && SQLUtils.nameEquals(name, alias);
    }

    public boolean containsAlias(long aliasHash) {
        if (this.aliasHashCode64() == aliasHash) {
            return true;
        }
        if (this.expr instanceof SQLName) {
            long exprNameHash = ((SQLName)this.expr).nameHashCode64();
            return exprNameHash == this.aliasHashCod64;
        }
        return false;
    }

    @Override
    public SQLColumnDefinition findColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.findColumn(hash);
    }

    @Override
    public SQLColumnDefinition findColumn(long columnNameHash) {
        if (this.schemaObject == null) {
            return null;
        }
        SQLStatement stmt = this.schemaObject.getStatement();
        if (stmt instanceof SQLCreateTableStatement) {
            SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)stmt;
            return createTableStmt.findColumn(columnNameHash);
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(String columnName) {
        if (columnName == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columnName);
        return this.findTableSourceWithColumn(hash);
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnName_hash) {
        SQLTableSource tableSource;
        SQLCreateTableStatement createTableStmt;
        SQLStatement stmt;
        if (this.schemaObject != null && (stmt = this.schemaObject.getStatement()) instanceof SQLCreateTableStatement && (createTableStmt = (SQLCreateTableStatement)stmt).findColumn(columnName_hash) != null) {
            return this;
        }
        if (this.expr instanceof SQLIdentifierExpr && (tableSource = ((SQLIdentifierExpr)this.expr).getResolvedTableSource()) != null) {
            return tableSource.findTableSourceWithColumn(columnName_hash);
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSource(long alias_hash) {
        long hash;
        long exprNameHash;
        if (alias_hash == 0L) {
            return null;
        }
        if (this.aliasHashCode64() == alias_hash) {
            return this;
        }
        if (this.expr instanceof SQLName && (exprNameHash = ((SQLName)this.expr).nameHashCode64()) == alias_hash) {
            return this;
        }
        if (this.expr instanceof SQLPropertyExpr && (hash = ((SQLPropertyExpr)this.expr).hashCode64()) == alias_hash) {
            return this;
        }
        return null;
    }
}

