/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.jdbc;

import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.JdbcParameterDate;
import com.alibaba.druid.proxy.jdbc.JdbcParameterDecimal;
import com.alibaba.druid.proxy.jdbc.JdbcParameterImpl;
import com.alibaba.druid.proxy.jdbc.JdbcParameterInt;
import com.alibaba.druid.proxy.jdbc.JdbcParameterLong;
import com.alibaba.druid.proxy.jdbc.JdbcParameterNull;
import com.alibaba.druid.proxy.jdbc.JdbcParameterString;
import com.alibaba.druid.proxy.jdbc.JdbcParameterTimestamp;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.StatementExecuteType;
import com.alibaba.druid.proxy.jdbc.StatementProxyImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class PreparedStatementProxyImpl
extends StatementProxyImpl
implements PreparedStatementProxy {
    private PreparedStatement statement;
    protected final String sql;
    private JdbcParameter[] parameters;
    private int parametersSize = 0;
    private Map<Integer, JdbcParameter> paramMap = null;

    public PreparedStatementProxyImpl(ConnectionProxy connection, PreparedStatement statement, String sql, long id) {
        super(connection, statement, id);
        this.statement = statement;
        this.sql = sql;
        char quote = '\u0000';
        int paramCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                if (quote == '\u0000') {
                    quote = ch;
                } else if (quote == '\'') {
                    quote = '\u0000';
                }
            } else if (ch == '\"') {
                if (quote == '\u0000') {
                    quote = ch;
                } else if (quote == '\"') {
                    quote = '\u0000';
                }
            }
            if (quote != '\u0000' || ch != '?') continue;
            ++paramCount;
        }
        this.parameters = new JdbcParameter[paramCount];
    }

    @Override
    public Map<Integer, JdbcParameter> getParameters() {
        if (this.paramMap == null) {
            this.paramMap = new HashMap<Integer, JdbcParameter>(this.parametersSize);
            for (int i = 0; i < this.parametersSize; ++i) {
                this.paramMap.put(i, this.parameters[i]);
            }
        }
        return this.paramMap;
    }

    protected void setStatement(PreparedStatement statement) {
        ((StatementProxyImpl)this).statement = statement;
        this.statement = statement;
    }

    void setParameter(int jdbcIndex, JdbcParameter parameter) {
        int index = jdbcIndex - 1;
        if (jdbcIndex > this.parametersSize) {
            this.parametersSize = jdbcIndex;
        }
        if (this.parametersSize >= this.parameters.length) {
            int oldCapacity = this.parameters.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity <= 4) {
                newCapacity = 4;
            }
            this.parameters = Arrays.copyOf(this.parameters, newCapacity);
        }
        this.parameters[index] = parameter;
        if (this.paramMap != null) {
            this.paramMap = null;
        }
    }

    @Override
    public int getParametersSize() {
        return this.parametersSize;
    }

    @Override
    public JdbcParameter getParameter(int i) {
        if (i > this.parametersSize) {
            return null;
        }
        return this.parameters[i];
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public PreparedStatement getRawObject() {
        return this.statement;
    }

    @Override
    public void addBatch() throws SQLException {
        this.createChain().preparedStatement_addBatch(this);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.createChain().preparedStatement_clearParameters(this);
    }

    @Override
    public String getBatchSql() {
        return this.sql;
    }

    @Override
    public boolean execute() throws SQLException {
        this.updateCount = null;
        this.lastExecuteSql = this.sql;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        this.firstResultSet = this.createChain().preparedStatement_execute(this);
        return this.firstResultSet;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.firstResultSet = true;
        this.updateCount = null;
        this.lastExecuteSql = this.sql;
        this.lastExecuteType = StatementExecuteType.ExecuteQuery;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        return this.createChain().preparedStatement_executeQuery(this);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.firstResultSet = false;
        this.updateCount = null;
        this.lastExecuteSql = this.sql;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.lastExecuteStartNano = -1L;
        this.lastExecuteTimeNano = -1L;
        this.updateCount = this.createChain().preparedStatement_executeUpdate(this);
        return this.updateCount;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.createChain().preparedStatement_getMetaData(this);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.createChain().preparedStatement_getParameterMetaData(this);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2003, x));
        this.createChain().preparedStatement_setArray(this, parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10002, x));
        this.createChain().preparedStatement_setAsciiStream(this, parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10002, (Object)x, (long)length));
        this.createChain().preparedStatement_setAsciiStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10002, (Object)x, length));
        this.createChain().preparedStatement_setAsciiStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
        this.createChain().preparedStatement_setBigDecimal(this, parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10001, x));
        this.createChain().preparedStatement_setBinaryStream(this, parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10001, (Object)x, (long)length));
        this.createChain().preparedStatement_setBinaryStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10001, (Object)x, length));
        this.createChain().preparedStatement_setBinaryStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2004, x));
        this.createChain().preparedStatement_setBlob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2004, x));
        this.createChain().preparedStatement_setBlob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2004, (Object)x, length));
        this.createChain().preparedStatement_setBlob(this, parameterIndex, x, length);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(16, x));
        this.createChain().preparedStatement_setBoolean(this, parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(-6, x));
        this.createChain().preparedStatement_setByte(this, parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10007, x));
        this.createChain().preparedStatement_setBytes(this, parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10003, x));
        this.createChain().preparedStatement_setCharacterStream(this, parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10003, (Object)x, (long)length));
        this.createChain().preparedStatement_setCharacterStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10003, (Object)x, length));
        this.createChain().preparedStatement_setCharacterStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2005, x));
        this.createChain().preparedStatement_setClob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2005, x));
        this.createChain().preparedStatement_setClob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2005, (Object)x, length));
        this.createChain().preparedStatement_setClob(this, parameterIndex, x, length);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
        this.createChain().preparedStatement_setDate(this, parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(91, (Object)x, cal));
        this.createChain().preparedStatement_setDate(this, parameterIndex, x, cal);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(8, x));
        this.createChain().preparedStatement_setDouble(this, parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(6, Float.valueOf(x)));
        this.createChain().preparedStatement_setFloat(this, parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, this.createParemeter(x));
        this.createChain().preparedStatement_setInt(this, parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
        this.createChain().preparedStatement_setLong(this, parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10004, x));
        this.createChain().preparedStatement_setNCharacterStream(this, parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10004, (Object)x, length));
        this.createChain().preparedStatement_setNCharacterStream(this, parameterIndex, x, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2011, x));
        this.createChain().preparedStatement_setNClob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2011, x));
        this.createChain().preparedStatement_setNClob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2011, (Object)x, length));
        this.createChain().preparedStatement_setNClob(this, parameterIndex, x, length);
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(-9, x));
        this.createChain().preparedStatement_setNString(this, parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, this.createParameterNull(sqlType));
        this.createChain().preparedStatement_setNull(this, parameterIndex, sqlType);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, this.createParameterNull(sqlType));
        this.createChain().preparedStatement_setNull(this, parameterIndex, sqlType, typeName);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setObjectParameter(parameterIndex, x);
        this.createChain().preparedStatement_setObject(this, parameterIndex, x);
    }

    private void setObjectParameter(int parameterIndex, Object x) {
        if (x == null) {
            this.setParameter(parameterIndex, this.createParameterNull(1111));
            return;
        }
        Class<?> clazz = x.getClass();
        if (clazz == Byte.class) {
            this.setParameter(parameterIndex, this.createParameter(-6, x));
            return;
        }
        if (clazz == Short.class) {
            this.setParameter(parameterIndex, this.createParameter(5, x));
            return;
        }
        if (clazz == Integer.class) {
            this.setParameter(parameterIndex, this.createParemeter((Integer)x));
            return;
        }
        if (clazz == Long.class) {
            this.setParameter(parameterIndex, this.createParameter((Long)x));
            return;
        }
        if (clazz == String.class) {
            this.setParameter(parameterIndex, this.createParameter((String)x));
            return;
        }
        if (clazz == BigDecimal.class) {
            this.setParameter(parameterIndex, this.createParameter((BigDecimal)x));
            return;
        }
        if (clazz == Float.class) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(6, x));
            return;
        }
        if (clazz == Double.class) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(8, x));
            return;
        }
        if (clazz == Date.class || clazz == java.util.Date.class) {
            this.setParameter(parameterIndex, this.createParameter((java.util.Date)x));
            return;
        }
        if (clazz == Timestamp.class) {
            this.setParameter(parameterIndex, this.createParameter((Timestamp)x));
            return;
        }
        if (clazz == Time.class) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(92, x));
            return;
        }
        if (clazz == Boolean.class) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(16, x));
            return;
        }
        if (clazz == byte[].class) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(10007, x));
            return;
        }
        if (x instanceof InputStream) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(10001, x));
            return;
        }
        if (x instanceof Reader) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(10003, x));
            return;
        }
        if (x instanceof Clob) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(2005, x));
            return;
        }
        if (x instanceof NClob) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(2011, x));
            return;
        }
        if (x instanceof Blob) {
            this.setParameter(parameterIndex, new JdbcParameterImpl(2004, x));
            return;
        }
        this.setParameter(parameterIndex, this.createParameter(1111, null));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(targetSqlType, x));
        this.createChain().preparedStatement_setObject(this, parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x, targetSqlType, scaleOrLength));
        this.createChain().preparedStatement_setObject(this, parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2006, x));
        this.createChain().preparedStatement_setRef(this, parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(-8, x));
        this.createChain().preparedStatement_setRowId(this, parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2009, x));
        this.createChain().preparedStatement_setSQLXML(this, parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(5, x));
        this.createChain().preparedStatement_setShort(this, parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
        this.createChain().preparedStatement_setString(this, parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(92, x));
        this.createChain().preparedStatement_setTime(this, parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(92, (Object)x, cal));
        this.createChain().preparedStatement_setTime(this, parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
        this.createChain().preparedStatement_setTimestamp(this, parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(93, x));
        this.createChain().preparedStatement_setTimestamp(this, parameterIndex, x, cal);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10005, x));
        this.createChain().preparedStatement_setURL(this, parameterIndex, x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10006, (Object)x, (long)length));
        this.createChain().preparedStatement_setUnicodeStream(this, parameterIndex, x, length);
    }

    @Override
    public String getLastExecuteSql() {
        return this.sql;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == PreparedStatementProxy.class) {
            return (T)this;
        }
        return super.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == PreparedStatementProxy.class) {
            return true;
        }
        return super.isWrapperFor(iface);
    }

    private JdbcParameter createParemeter(int x) {
        return JdbcParameterInt.valueOf(x);
    }

    private JdbcParameter createParameter(long x) {
        return JdbcParameterLong.valueOf(x);
    }

    private JdbcParameter createParameterNull(int sqlType) {
        return JdbcParameterNull.valueOf(sqlType);
    }

    private JdbcParameter createParameter(java.util.Date x) {
        if (x == null) {
            return JdbcParameterNull.DATE;
        }
        return new JdbcParameterDate(x);
    }

    private JdbcParameter createParameter(BigDecimal x) {
        if (x == null) {
            return JdbcParameterNull.DECIMAL;
        }
        return JdbcParameterDecimal.valueOf(x);
    }

    private JdbcParameter createParameter(String x) {
        if (x == null) {
            return JdbcParameterNull.VARCHAR;
        }
        if (x.length() == 0) {
            return JdbcParameterString.empty;
        }
        return new JdbcParameterString(x);
    }

    private JdbcParameter createParameter(Timestamp x) {
        if (x == null) {
            return JdbcParameterNull.TIMESTAMP;
        }
        return new JdbcParameterTimestamp(x);
    }

    private JdbcParameter createParameter(Object x, int sqlType, int scaleOrLength) {
        if (x == null) {
            return JdbcParameterNull.valueOf(sqlType);
        }
        return new JdbcParameterImpl(sqlType, x, -1L, null, scaleOrLength);
    }

    private JdbcParameter createParameter(int sqlType, Object value, long length) {
        if (value == null) {
            return JdbcParameterNull.valueOf(sqlType);
        }
        return new JdbcParameterImpl(sqlType, value, length);
    }

    private JdbcParameter createParameter(int sqlType, Object value) {
        if (value == null) {
            return JdbcParameterNull.valueOf(sqlType);
        }
        return new JdbcParameterImpl(sqlType, value);
    }

    public JdbcParameter createParameter(int sqlType, Object value, Calendar calendar) {
        if (value == null) {
            return JdbcParameterNull.valueOf(sqlType);
        }
        return new JdbcParameterImpl(sqlType, value, calendar);
    }
}

