/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLSubqueryTableSource
extends SQLTableSourceImpl {
    protected SQLSelect select;
    protected List<SQLName> columns = new ArrayList<SQLName>();

    public SQLSubqueryTableSource() {
    }

    public SQLSubqueryTableSource(String alias) {
        super(alias);
    }

    public SQLSubqueryTableSource(SQLSelect select, String alias) {
        super(alias);
        this.setSelect(select);
    }

    public SQLSubqueryTableSource(SQLSelect select) {
        this.setSelect(select);
    }

    public SQLSubqueryTableSource(SQLSelectQuery query) {
        this(new SQLSelect(query));
    }

    public SQLSelect getSelect() {
        return this.select;
    }

    public void setSelect(SQLSelect select) {
        if (select != null) {
            select.setParent(this);
        }
        this.select = select;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.select);
            this.acceptChild(visitor, this.columns);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append("(");
        this.select.output(buf);
        buf.append(")");
    }

    public void cloneTo(SQLSubqueryTableSource x) {
        x.alias = this.alias;
        if (this.select != null) {
            x.select = this.select.clone();
        }
        for (SQLName column : this.columns) {
            SQLName c2 = column.clone();
            c2.setParent(x);
            x.columns.add(c2);
        }
    }

    @Override
    public SQLSubqueryTableSource clone() {
        SQLSubqueryTableSource x = new SQLSubqueryTableSource();
        this.cloneTo(x);
        return x;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(String columnName) {
        if (this.select == null) {
            return null;
        }
        SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
        if (queryBlock == null) {
            return null;
        }
        if (queryBlock.findSelectItem(columnName) != null) {
            return this;
        }
        return null;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnNameHash) {
        if (this.select == null) {
            return null;
        }
        SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
        if (queryBlock == null) {
            return null;
        }
        if (queryBlock.findSelectItem(columnNameHash) != null) {
            return this;
        }
        return null;
    }

    public List<SQLName> getColumns() {
        return this.columns;
    }

    public void addColumn(SQLName column) {
        column.setParent(this);
        this.columns.add(column);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLSubqueryTableSource that = (SQLSubqueryTableSource)o;
        return this.select != null ? this.select.equals(that.select) : that.select == null;
    }

    @Override
    public int hashCode() {
        return this.select != null ? this.select.hashCode() : 0;
    }
}

