/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.repository;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.repository.Schema;
import com.alibaba.druid.sql.repository.SchemaObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class SchemaRepository {
    private Schema defaultSchema;
    private Map<String, Schema> schemas = new LinkedHashMap<String, Schema>();

    public String getDefaultSchemaName() {
        return this.getDefaultSchema().getName();
    }

    public void setDefaultSchema(String name) {
        if (name == null) {
            this.defaultSchema = null;
            return;
        }
        String normalizedName = SQLUtils.normalize(name).toLowerCase();
        Schema defaultSchema = this.schemas.get(normalizedName);
        if (defaultSchema != null) {
            this.defaultSchema = defaultSchema;
            return;
        }
        if (defaultSchema == null) {
            if (this.defaultSchema != null && this.defaultSchema.getName() == null) {
                this.defaultSchema.setName(name);
                this.schemas.put(normalizedName, this.defaultSchema);
                return;
            }
            defaultSchema = new Schema(this);
            defaultSchema.setName(name);
            this.schemas.put(normalizedName, defaultSchema);
            this.defaultSchema = defaultSchema;
        }
    }

    public Schema findSchema(String schema) {
        if (schema == null) {
            return null;
        }
        return this.schemas.get(SQLUtils.normalize(schema).toLowerCase());
    }

    public Schema getDefaultSchema() {
        if (this.defaultSchema == null) {
            this.defaultSchema = new Schema(this);
        }
        return this.defaultSchema;
    }

    public void setDefaultSchema(Schema schema) {
        this.defaultSchema = schema;
    }

    public SchemaObject findTable(String tableName) {
        return this.getDefaultSchema().findTable(tableName);
    }

    public SchemaObject findTableOrView(String tableName) {
        return this.findTableOrView(tableName, true);
    }

    public SchemaObject findTableOrView(String tableName, boolean onlyCurrent) {
        Schema schema = this.getDefaultSchema();
        SchemaObject object = schema.findTableOrView(tableName);
        if (object != null) {
            return object;
        }
        for (Schema s : this.schemas.values()) {
            if (s == schema || (object = schema.findTableOrView(tableName)) == null) continue;
            return object;
        }
        return null;
    }

    public Collection<Schema> getSchemas() {
        return this.schemas.values();
    }

    public SchemaObject findFunction(String functionName) {
        return this.getDefaultSchema().findFunction(functionName);
    }

    public void acceptDDL(String ddl, String dbType) {
        this.getDefaultSchema().acceptDDL(ddl, dbType);
    }

    public void accept(SQLStatement stmt) {
        this.getDefaultSchema().accept(stmt);
    }

    public boolean isSequence(String name) {
        return this.getDefaultSchema().isSequence(name);
    }

    public SchemaObject findTable(SQLTableSource tableSource, String alias) {
        return this.getDefaultSchema().findTable(tableSource, alias);
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLSelectItem selectItem) {
        return this.getDefaultSchema().findColumn(tableSource, selectItem);
    }

    public SQLColumnDefinition findColumn(SQLTableSource tableSource, SQLExpr expr) {
        return this.getDefaultSchema().findColumn(tableSource, expr);
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLSelectItem selectItem) {
        return this.getDefaultSchema().findTable(tableSource, selectItem);
    }

    public SchemaObject findTable(SQLTableSource tableSource, SQLExpr expr) {
        return this.getDefaultSchema().findTable(tableSource, expr);
    }

    public Map<String, SchemaObject> getTables(SQLTableSource x) {
        return this.getDefaultSchema().getTables(x);
    }

    public int getTableCount() {
        return this.getDefaultSchema().getTableCount();
    }

    public Map<String, SchemaObject> getObjects() {
        return this.getDefaultSchema().getObjects();
    }

    public int getViewCount() {
        return this.getDefaultSchema().getViewCount();
    }
}

