/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.ListDG;
import com.alibaba.druid.util.lang.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SQLCreateTableStatement
extends SQLStatementImpl
implements SQLDDLStatement {
    protected boolean ifNotExiists = false;
    protected Type type;
    protected SQLExprTableSource tableSource;
    protected List<SQLTableElement> tableElementList = new ArrayList<SQLTableElement>();
    private SQLExprTableSource inherits;
    protected SQLSelect select;

    public SQLCreateTableStatement() {
    }

    public SQLCreateTableStatement(String dbType) {
        super(dbType);
    }

    public SQLName getName() {
        if (this.tableSource == null) {
            return null;
        }
        return (SQLName)this.tableSource.getExpr();
    }

    public void setName(SQLName name) {
        this.setTableSource(new SQLExprTableSource(name));
    }

    public void setName(String name) {
        this.setName(new SQLIdentifierExpr(name));
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSource = tableSource;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<SQLTableElement> getTableElementList() {
        return this.tableElementList;
    }

    public boolean isIfNotExiists() {
        return this.ifNotExiists;
    }

    public void setIfNotExiists(boolean ifNotExiists) {
        this.ifNotExiists = ifNotExiists;
    }

    public SQLExprTableSource getInherits() {
        return this.inherits;
    }

    public void setInherits(SQLExprTableSource inherits) {
        if (inherits != null) {
            inherits.setParent(this);
        }
        this.inherits = inherits;
    }

    public SQLSelect getSelect() {
        return this.select;
    }

    public void setSelect(SQLSelect select) {
        this.select = select;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.tableElementList);
            this.acceptChild(visitor, this.inherits);
            this.acceptChild(visitor, this.select);
        }
        visitor.endVisit(this);
    }

    public void addBodyBeforeComment(List<String> comments) {
        List attrComments;
        if (this.attributes == null) {
            this.attributes = new HashMap(1);
        }
        if ((attrComments = (List)this.attributes.get("format.body_before_comment")) == null) {
            this.attributes.put("format.body_before_comment", comments);
        } else {
            attrComments.addAll(comments);
        }
    }

    public List<String> getBodyBeforeCommentsDirect() {
        if (this.attributes == null) {
            return null;
        }
        return (List)this.attributes.get("format.body_before_comment");
    }

    public boolean hasBodyBeforeComment() {
        List<String> comments = this.getBodyBeforeCommentsDirect();
        if (comments == null) {
            return false;
        }
        return !comments.isEmpty();
    }

    public String computeName() {
        if (this.tableSource == null) {
            return null;
        }
        SQLExpr expr = this.tableSource.getExpr();
        if (expr instanceof SQLName) {
            String name = ((SQLName)expr).getSimpleName();
            return SQLUtils.normalize(name);
        }
        return null;
    }

    public SQLColumnDefinition findColumn(String columName) {
        columName = SQLUtils.normalize(columName);
        for (SQLTableElement element : this.tableElementList) {
            SQLColumnDefinition column;
            String name;
            if (!(element instanceof SQLColumnDefinition) || !columName.equalsIgnoreCase(name = (column = (SQLColumnDefinition)element).computeAlias())) continue;
            return column;
        }
        return null;
    }

    public SQLTableElement findIndex(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            List<SQLExpr> keyColumns = null;
            if (element instanceof SQLUniqueConstraint) {
                SQLUniqueConstraint unique = (SQLUniqueConstraint)((Object)element);
                keyColumns = unique.getColumns();
            } else if (element instanceof MySqlTableIndex) {
                keyColumns = ((MySqlTableIndex)element).getColumns();
            }
            if (keyColumns == null) continue;
            for (SQLExpr columnExpr : keyColumns) {
                if (!(columnExpr instanceof SQLIdentifierExpr)) continue;
                String keyColumName = ((SQLIdentifierExpr)columnExpr).getName();
                if (!(keyColumName = SQLUtils.normalize(keyColumName)).equalsIgnoreCase(columnName)) continue;
                return element;
            }
        }
        return null;
    }

    public void forEachColumn(Consumer<SQLColumnDefinition> columnConsumer) {
        if (columnConsumer == null) {
            return;
        }
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLColumnDefinition)) continue;
            columnConsumer.accept((SQLColumnDefinition)element);
        }
    }

    public SQLPrimaryKey findPrimaryKey() {
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLPrimaryKey)) continue;
            return (SQLPrimaryKey)element;
        }
        return null;
    }

    public List<SQLForeignKeyConstraint> findForeignKey() {
        ArrayList<SQLForeignKeyConstraint> fkList = new ArrayList<SQLForeignKeyConstraint>();
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            fkList.add((SQLForeignKeyConstraint)element);
        }
        return fkList;
    }

    public boolean hashForeignKey() {
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            return true;
        }
        return false;
    }

    public boolean isReferenced(SQLName tableName) {
        if (tableName == null) {
            return false;
        }
        return this.isReferenced(tableName.getSimpleName());
    }

    public boolean isReferenced(String tableName) {
        if (tableName == null) {
            return false;
        }
        tableName = SQLUtils.normalize(tableName);
        for (SQLTableElement element : this.tableElementList) {
            SQLForeignKeyConstraint fk;
            String refTableName;
            if (!(element instanceof SQLForeignKeyConstraint) || !SQLUtils.nameEquals(tableName, refTableName = (fk = (SQLForeignKeyConstraint)element).getReferencedTableName().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public SQLAlterTableStatement foreignKeyToAlterTable() {
        SQLAlterTableStatement stmt = new SQLAlterTableStatement();
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLTableElement element = this.tableElementList.get(i);
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            SQLForeignKeyConstraint fk = (SQLForeignKeyConstraint)element;
            this.tableElementList.remove(i);
            stmt.addItem(new SQLAlterTableAddConstraint(fk));
        }
        if (stmt.getItems().size() == 0) {
            return null;
        }
        stmt.setDbType(this.getDbType());
        stmt.setTableSource(this.tableSource.clone());
        Collections.reverse(stmt.getItems());
        return stmt;
    }

    public static void sort(List<SQLStatement> stmtList) {
        String fromTableName;
        SQLCreateTableStatement from;
        ListDG.Edge edge;
        int i;
        HashMap<Object, SQLCreateTableStatement> tables = new HashMap<Object, SQLCreateTableStatement>();
        HashMap<String, ArrayList<SQLCreateTableStatement>> referencedTables = new HashMap<String, ArrayList<SQLCreateTableStatement>>();
        for (SQLStatement sQLStatement : stmtList) {
            if (!(sQLStatement instanceof SQLCreateTableStatement)) continue;
            SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)sQLStatement;
            Object tableName = createTableStmt.getName().getSimpleName();
            tableName = SQLUtils.normalize((String)tableName).toLowerCase();
            tables.put(tableName, createTableStmt);
        }
        ArrayList<ListDG.Edge> edges = new ArrayList<ListDG.Edge>();
        for (SQLCreateTableStatement stmt : tables.values()) {
            for (SQLTableElement element : stmt.getTableElementList()) {
                ArrayList<SQLCreateTableStatement> referencedList;
                if (!(element instanceof SQLForeignKeyConstraint)) continue;
                SQLForeignKeyConstraint fk = (SQLForeignKeyConstraint)element;
                String refTableName = fk.getReferencedTableName().getSimpleName();
                SQLCreateTableStatement refTable = (SQLCreateTableStatement)tables.get(refTableName = SQLUtils.normalize(refTableName).toLowerCase());
                if (refTable != null) {
                    edges.add(new ListDG.Edge(stmt, refTable));
                }
                if ((referencedList = (ArrayList<SQLCreateTableStatement>)referencedTables.get(refTableName)) == null) {
                    referencedList = new ArrayList<SQLCreateTableStatement>();
                    referencedTables.put(refTableName, referencedList);
                }
                referencedList.add(stmt);
            }
        }
        ListDG listDG = new ListDG(stmtList, edges);
        Object[] tops = new SQLStatement[stmtList.size()];
        if (listDG.topologicalSort(tops)) {
            int size = stmtList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                stmtList.set(i2, (SQLStatement)tops[size - i2 - 1]);
            }
            return;
        }
        ArrayList<SQLAlterTableStatement> alterList = new ArrayList<SQLAlterTableStatement>();
        for (i = edges.size() - 1; i >= 0; --i) {
            edge = (ListDG.Edge)edges.get(i);
            from = (SQLCreateTableStatement)edge.from;
            fromTableName = from.getName().getSimpleName();
            if (!referencedTables.containsKey(fromTableName = SQLUtils.normalize(fromTableName).toLowerCase())) continue;
            edges.remove(i);
            Arrays.fill(tops, null);
            tops = new SQLStatement[stmtList.size()];
            ListDG listDG2 = new ListDG(stmtList, edges);
            if (listDG2.topologicalSort(tops)) {
                int size = stmtList.size();
                for (int j = 0; j < size; ++j) {
                    Object stmt = tops[size - j - 1];
                    stmtList.set(j, (SQLStatement)stmt);
                }
                SQLAlterTableStatement alter = from.foreignKeyToAlterTable();
                alterList.add(alter);
                stmtList.add(alter);
                return;
            }
            edges.add(i, edge);
        }
        for (i = edges.size() - 1; i >= 0; --i) {
            edge = (ListDG.Edge)edges.get(i);
            from = (SQLCreateTableStatement)edge.from;
            fromTableName = from.getName().getSimpleName();
            if (!referencedTables.containsKey(fromTableName = SQLUtils.normalize(fromTableName).toLowerCase())) continue;
            SQLAlterTableStatement alter = from.foreignKeyToAlterTable();
            edges.remove(i);
            if (alter != null) {
                alterList.add(alter);
            }
            Arrays.fill(tops, null);
            tops = new SQLStatement[stmtList.size()];
            ListDG listDG3 = new ListDG(stmtList, edges);
            if (!listDG3.topologicalSort(tops)) continue;
            int size = stmtList.size();
            for (int j = 0; j < size; ++j) {
                Object stmt = tops[size - j - 1];
                stmtList.set(j, (SQLStatement)stmt);
            }
            stmtList.addAll(alterList);
            return;
        }
    }

    public void simplify() {
        String tableName;
        SQLIdentifierExpr identExpr;
        SQLName name = this.getName();
        if (name instanceof SQLPropertyExpr) {
            String tableName2 = ((SQLPropertyExpr)name).getName();
            tableName2 = SQLUtils.normalize(tableName2);
            this.setName(tableName2);
            name = this.getName();
        }
        if (name instanceof SQLIdentifierExpr) {
            identExpr = (SQLIdentifierExpr)name;
            tableName = identExpr.getName();
            tableName = SQLUtils.normalize(tableName, this.dbType);
            identExpr.setName(tableName);
        }
        if (name instanceof SQLIdentifierExpr) {
            identExpr = (SQLIdentifierExpr)name;
            tableName = identExpr.getName();
            tableName = SQLUtils.normalize(tableName);
            identExpr.setName(tableName);
        }
        for (SQLTableElement element : this.tableElementList) {
            if (element instanceof SQLColumnDefinition) {
                SQLColumnDefinition column = (SQLColumnDefinition)element;
                column.simplify();
                continue;
            }
            if (!(element instanceof SQLConstraint)) continue;
            ((SQLConstraint)((Object)element)).simplify();
        }
    }

    public static enum Type {
        GLOBAL_TEMPORARY,
        LOCAL_TEMPORARY;

    }
}

