/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLMethodInvokeExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String methodName;
    private SQLExpr owner;
    private final List<SQLExpr> parameters = new ArrayList<SQLExpr>();
    private SQLExpr from;

    public SQLMethodInvokeExpr() {
    }

    public SQLMethodInvokeExpr(String methodName) {
        this.methodName = methodName;
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner) {
        this.methodName = methodName;
        this.setOwner(owner);
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner, SQLExpr ... params) {
        this.methodName = methodName;
        this.setOwner(owner);
        for (SQLExpr param : params) {
            this.addParameter(param);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public SQLExpr getOwner() {
        return this.owner;
    }

    public void setOwner(SQLExpr owner) {
        if (owner != null) {
            owner.setParent(this);
        }
        this.owner = owner;
    }

    public SQLExpr getFrom() {
        return this.from;
    }

    public void setFrom(SQLExpr from) {
        this.from = from;
    }

    public List<SQLExpr> getParameters() {
        return this.parameters;
    }

    public void addParameter(SQLExpr param) {
        if (param != null) {
            param.setParent(this);
        }
        this.parameters.add(param);
    }

    @Override
    public void output(StringBuffer buf) {
        if (this.owner != null) {
            this.owner.output(buf);
            buf.append(".");
        }
        buf.append(this.methodName);
        buf.append("(");
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            this.parameters.get(i).output(buf);
        }
        buf.append(")");
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.owner);
            this.acceptChild(visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.owner);
            this.acceptChild((SQLASTVisitor)visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLMethodInvokeExpr that = (SQLMethodInvokeExpr)o;
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return this.from != null ? this.from.equals(that.from) : that.from == null;
    }

    @Override
    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }

    @Override
    public SQLMethodInvokeExpr clone() {
        SQLMethodInvokeExpr x = new SQLMethodInvokeExpr();
        x.methodName = this.methodName;
        if (this.owner != null) {
            x.setOwner(this.owner.clone());
        }
        for (SQLExpr param : this.parameters) {
            x.addParameter(param.clone());
        }
        if (this.from != null) {
            x.setFrom(this.from.clone());
        }
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != expr) continue;
            this.parameters.set(i, target);
            target.setParent(this);
            return true;
        }
        return false;
    }

    public boolean match(String owner, String function) {
        if (function == null) {
            return false;
        }
        if (!SQLUtils.nameEquals(function, this.methodName)) {
            return false;
        }
        if (owner == null && this.owner == null) {
            return true;
        }
        if (owner == null || this.owner == null) {
            return false;
        }
        if (this.owner instanceof SQLIdentifierExpr) {
            return SQLUtils.nameEquals(((SQLIdentifierExpr)this.owner).name, owner);
        }
        return false;
    }
}

