/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.db2.visitor;

import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2SelectQueryBlock;
import com.alibaba.druid.sql.dialect.db2.ast.stmt.DB2ValuesStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2ASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class DB2OutputVisitor
extends SQLASTOutputVisitor
implements DB2ASTVisitor {
    public DB2OutputVisitor(Appendable appender) {
        super(appender, "db2");
    }

    public DB2OutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = "db2";
    }

    @Override
    public boolean visit(DB2SelectQueryBlock x) {
        this.visit((SQLSelectQueryBlock)x);
        if (x.isForReadOnly()) {
            this.println();
            this.print0(this.ucase ? "FOR READ ONLY" : "for read only");
        } else if (x.isForUpdate()) {
            this.println();
            this.print0(this.ucase ? "FOR UPDATE" : "for update");
        }
        if (x.getIsolation() != null) {
            this.println();
            this.print0(this.ucase ? "WITH " : "with ");
            this.print0(x.getIsolation().name());
        }
        if (x.getOptimizeFor() != null) {
            this.println();
            this.print0(this.ucase ? "OPTIMIZE FOR " : "optimize for ");
            x.getOptimizeFor().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(DB2SelectQueryBlock x) {
    }

    @Override
    public boolean visit(DB2ValuesStatement x) {
        this.print0(this.ucase ? "VALUES " : "values ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(DB2ValuesStatement x) {
    }

    @Override
    protected void printOperator(SQLBinaryOperator operator) {
        if (operator == SQLBinaryOperator.Concat) {
            this.print0(this.ucase ? "CONCAT" : "concat");
        } else {
            this.print0(this.ucase ? operator.name : operator.name_lcase);
        }
    }
}

