/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.repository.SchemaObject;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLExprTableSource
extends SQLTableSourceImpl {
    protected SQLExpr expr;
    private List<SQLName> partitions;
    private SchemaObject schemaObject;

    public SQLExprTableSource() {
    }

    public SQLExprTableSource(SQLExpr expr) {
        this(expr, null);
    }

    public SQLExprTableSource(SQLExpr expr, String alias) {
        this.setExpr(expr);
        this.setAlias(alias);
    }

    public SQLExpr getExpr() {
        return this.expr;
    }

    public void setExpr(SQLExpr expr) {
        if (expr != null) {
            expr.setParent(this);
        }
        this.expr = expr;
    }

    public List<SQLName> getPartitions() {
        if (this.partitions == null) {
            this.partitions = new ArrayList<SQLName>(2);
        }
        return this.partitions;
    }

    public int getPartitionSize() {
        if (this.partitions == null) {
            return 0;
        }
        return this.partitions.size();
    }

    public void addPartition(SQLName partition) {
        if (partition != null) {
            partition.setParent(this);
        }
        if (this.partitions == null) {
            this.partitions = new ArrayList<SQLName>(2);
        }
        this.partitions.add(partition);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.expr);
        }
        visitor.endVisit(this);
    }

    @Override
    public void output(StringBuffer buf) {
        this.expr.output(buf);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLExprTableSource that = (SQLExprTableSource)o;
        if (this.expr != null ? !this.expr.equals(that.expr) : that.expr != null) {
            return false;
        }
        return this.partitions != null ? this.partitions.equals(that.partitions) : that.partitions == null;
    }

    public int hashCode() {
        int result = this.expr != null ? this.expr.hashCode() : 0;
        result = 31 * result + (this.partitions != null ? this.partitions.hashCode() : 0);
        return result;
    }

    @Override
    public String computeAlias() {
        String alias = this.getAlias();
        if (alias == null && this.expr instanceof SQLName) {
            alias = ((SQLName)this.expr).getSimpleName();
        }
        return SQLUtils.normalize(alias);
    }

    @Override
    public SQLExprTableSource clone() {
        SQLExprTableSource x = new SQLExprTableSource();
        this.cloneTo(x);
        return x;
    }

    public void cloneTo(SQLExprTableSource x) {
        x.alias = this.alias;
        if (this.expr != null) {
            x.expr = this.expr.clone();
        }
        if (this.partitions != null) {
            for (SQLName p : this.partitions) {
                SQLName p1 = p.clone();
                x.addPartition(p1);
            }
        }
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }
}

