/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerExecStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerExprParser;
import com.alibaba.druid.sql.dialect.sqlserver.parser.SQLServerSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class SQLServerStatementParser
extends SQLStatementParser {
    public SQLServerStatementParser(String sql) {
        super(new SQLServerExprParser(sql));
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new SQLServerSelectParser(this.exprParser);
    }

    public SQLServerStatementParser(Lexer lexer) {
        super(new SQLServerExprParser(lexer));
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.WITH) {
            SQLSelectStatement stmt = this.parseSelect();
            statementList.add(stmt);
            return true;
        }
        if (this.identifierEquals("EXEC") || this.identifierEquals("EXECUTE")) {
            this.lexer.nextToken();
            SQLServerExecStatement execStmt = new SQLServerExecStatement();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprParser.exprList(execStmt.getParameters(), execStmt);
                this.accept(Token.RPAREN);
            } else {
                SQLName moduleName = this.exprParser.name();
                execStmt.setModuleName(moduleName);
                this.exprParser.exprList(execStmt.getParameters(), execStmt);
            }
            statementList.add(execStmt);
            return true;
        }
        return false;
    }

    @Override
    public SQLStatement parseInsert() {
        SQLServerInsertStatement insertStatement = new SQLServerInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.accept(Token.INSERT);
        }
        this.parseInsert0(insertStatement);
        return insertStatement;
    }

    @Override
    protected void parseInsert0(SQLInsertInto insert, boolean acceptSubQuery) {
        SQLServerInsertStatement insertStatement = (SQLServerInsertStatement)insert;
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            SQLName tableName = this.exprParser.name();
            insertStatement.setTableName(tableName);
            if (this.lexer.token() == Token.LITERAL_ALIAS) {
                insertStatement.setAlias(this.as());
            }
            this.parseInsert0_hinits(insertStatement);
            if (this.lexer.token() == Token.IDENTIFIER) {
                insertStatement.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(insertStatement.getColumns(), insertStatement);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(values.getValues(), values);
                insertStatement.getValuesList().add(values);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (acceptSubQuery && (this.lexer.token() == Token.SELECT || this.lexer.token() == Token.LPAREN)) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            insertStatement.setQuery(queryExpr.getSubQuery());
        } else if (this.lexer.token() == Token.DEFAULT) {
            this.lexer.nextToken();
            this.accept(Token.VALUES);
            insertStatement.setDefaultValues(true);
        }
    }

    @Override
    protected SQLServerUpdateStatement createUpdateStatement() {
        return new SQLServerUpdateStatement();
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        SQLServerUpdateStatement udpateStatement = this.createUpdateStatement();
        this.accept(Token.UPDATE);
        SQLServerTop top = this.getExprParser().parseTop();
        if (top != null) {
            udpateStatement.setTop(top);
        }
        SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
        udpateStatement.setTableSource(tableSource);
        this.parseUpdateSet(udpateStatement);
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
            SQLTableSource from = this.exprParser.createSelectParser().parseTableSource();
            udpateStatement.setFrom(from);
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        return udpateStatement;
    }

    @Override
    public SQLServerExprParser getExprParser() {
        return (SQLServerExprParser)this.exprParser;
    }
}

