/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGValuesQuery;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class PGSelectParser
extends SQLSelectParser {
    public PGSelectParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    public PGSelectParser(String sql) {
        this(new PGExprParser(sql));
    }

    protected SQLExprParser createExprParser() {
        return new PGExprParser(this.lexer);
    }

    @Override
    public SQLSelectQuery query() {
        SQLExpr expr;
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            PGValuesQuery valuesQuery = new PGValuesQuery();
            this.exprParser.exprList(valuesQuery.getValues(), valuesQuery);
            this.accept(Token.RPAREN);
            return this.queryRest(valuesQuery);
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            if (select instanceof SQLSelectQueryBlock) {
                ((SQLSelectQueryBlock)select).setParenthesized(true);
            }
            this.accept(Token.RPAREN);
            return this.queryRest(select);
        }
        PGSelectQueryBlock queryBlock = new PGSelectQueryBlock();
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
                if (this.lexer.token() == Token.ON) {
                    this.lexer.nextToken();
                    while (true) {
                        SQLExpr expr2 = this.createExprParser().expr();
                        queryBlock.getDistinctOn().add(expr2);
                        if (this.lexer.token() == Token.COMMA) {
                            this.lexer.nextToken();
                            continue;
                        }
                        break;
                    }
                }
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            this.parseSelectList(queryBlock);
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TEMPORARY) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.TEMPORARY);
                } else if (this.lexer.token() == Token.TEMP) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.TEMP);
                } else if (this.lexer.token() == Token.UNLOGGED) {
                    this.lexer.nextToken();
                    queryBlock.setIntoOption(PGSelectQueryBlock.IntoOption.UNLOGGED);
                }
                if (this.lexer.token() == Token.TABLE) {
                    this.lexer.nextToken();
                }
                SQLName name = this.createExprParser().name();
                queryBlock.setInto(new SQLExprTableSource(name));
            }
        }
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseGroupBy(queryBlock);
        if (this.lexer.token() == Token.WINDOW) {
            this.lexer.nextToken();
            PGSelectQueryBlock.WindowClause window = new PGSelectQueryBlock.WindowClause();
            window.setName(this.expr());
            this.accept(Token.AS);
            while (true) {
                expr = this.createExprParser().expr();
                window.getDefinition().add(expr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            queryBlock.setWindow(window);
        }
        queryBlock.setOrderBy(this.createExprParser().parseOrderBy());
        while (true) {
            PGSelectQueryBlock.PGLimit limit;
            if (this.lexer.token() == Token.LIMIT) {
                limit = new PGSelectQueryBlock.PGLimit();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.ALL) {
                    limit.setRowCount(new SQLIdentifierExpr("ALL"));
                    this.lexer.nextToken();
                } else {
                    limit.setRowCount(this.expr());
                }
                queryBlock.setLimit(limit);
                continue;
            }
            if (this.lexer.token() != Token.OFFSET) break;
            limit = queryBlock.getLimit();
            if (limit == null) {
                limit = new PGSelectQueryBlock.PGLimit();
                queryBlock.setLimit(limit);
            }
            this.lexer.nextToken();
            SQLExpr offset = this.expr();
            limit.setOffset(offset);
            if (this.lexer.token() != Token.ROW && this.lexer.token() != Token.ROWS) continue;
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.FETCH) {
            this.lexer.nextToken();
            PGSelectQueryBlock.FetchClause fetch = new PGSelectQueryBlock.FetchClause();
            if (this.lexer.token() == Token.FIRST) {
                fetch.setOption(PGSelectQueryBlock.FetchClause.Option.FIRST);
            } else if (this.lexer.token() == Token.NEXT) {
                fetch.setOption(PGSelectQueryBlock.FetchClause.Option.NEXT);
            } else {
                throw new ParserException("expect 'FIRST' or 'NEXT'");
            }
            SQLExpr count = this.expr();
            fetch.setCount(count);
            if (this.lexer.token() != Token.ROW && this.lexer.token() != Token.ROWS) {
                throw new ParserException("expect 'ROW' or 'ROWS'");
            }
            this.lexer.nextToken();
            if (this.lexer.token() != Token.ONLY) {
                throw new ParserException("expect 'ONLY'");
            }
            this.lexer.nextToken();
            queryBlock.setFetch(fetch);
        }
        if (this.lexer.token() == Token.FOR) {
            this.lexer.nextToken();
            PGSelectQueryBlock.ForClause forClause = new PGSelectQueryBlock.ForClause();
            if (this.lexer.token() == Token.UPDATE) {
                forClause.setOption(PGSelectQueryBlock.ForClause.Option.UPDATE);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.SHARE) {
                forClause.setOption(PGSelectQueryBlock.ForClause.Option.SHARE);
                this.lexer.nextToken();
            } else {
                throw new ParserException("expect 'FIRST' or 'NEXT'");
            }
            if (this.lexer.token() == Token.OF) {
                while (true) {
                    expr = this.createExprParser().expr();
                    forClause.getOf().add(expr);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.token() == Token.NOWAIT) {
                this.lexer.nextToken();
                forClause.setNoWait(true);
            }
            queryBlock.setForClause(forClause);
        }
        return this.queryRest(queryBlock);
    }

    @Override
    protected SQLTableSource parseTableSourceRest(SQLTableSource tableSource) {
        if (this.lexer.token() == Token.AS && tableSource instanceof SQLExprTableSource) {
            this.lexer.nextToken();
            String alias = null;
            if (this.lexer.token() == Token.IDENTIFIER) {
                alias = this.lexer.stringVal();
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.LPAREN) {
                SQLExprTableSource exprTableSource = (SQLExprTableSource)tableSource;
                PGFunctionTableSource functionTableSource = new PGFunctionTableSource(exprTableSource.getExpr());
                if (alias != null) {
                    functionTableSource.setAlias(alias);
                }
                this.lexer.nextToken();
                this.parserParameters(functionTableSource.getParameters());
                this.accept(Token.RPAREN);
                return super.parseTableSourceRest(functionTableSource);
            }
        }
        return super.parseTableSourceRest(tableSource);
    }

    private void parserParameters(List<SQLParameter> parameters) {
        do {
            SQLParameter parameter = new SQLParameter();
            parameter.setName(this.exprParser.name());
            parameter.setDataType(this.exprParser.parseDataType());
            parameters.add(parameter);
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.SEMI) continue;
            this.lexer.nextToken();
        } while (this.lexer.token() != Token.BEGIN && this.lexer.token() != Token.RPAREN);
    }
}

