/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.config;

import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.config.BaseWebMvcConfig;
import com.alibaba.csp.sentinel.adapter.web.common.UrlCleaner;

public class SentinelWebMvcConfig
extends BaseWebMvcConfig {
    public static final String DEFAULT_REQUEST_ATTRIBUTE_NAME = "$$sentinel_spring_web_entry_attr";
    private UrlCleaner urlCleaner;
    private boolean httpMethodSpecify;
    private static boolean mseHttpMethodSpecify;
    private boolean webContextUnify = true;
    private boolean contextPathSpecify = true;

    public SentinelWebMvcConfig() {
        this.setRequestAttributeName(DEFAULT_REQUEST_ATTRIBUTE_NAME);
        try {
            String enableContextPath;
            String enable = System.getProperty("spring.cloud.mse.sentinel.web.http-method-prefix", "true");
            if (enable != null) {
                mseHttpMethodSpecify = Boolean.parseBoolean(enable);
            }
            if ((enableContextPath = System.getProperty("spring.cloud.ahas.sentinel.web.context-path", "true")) != null) {
                this.contextPathSpecify = Boolean.parseBoolean(enableContextPath);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UrlCleaner getUrlCleaner() {
        return this.urlCleaner;
    }

    public SentinelWebMvcConfig setUrlCleaner(UrlCleaner urlCleaner) {
        this.urlCleaner = urlCleaner;
        return this;
    }

    public boolean isHttpMethodSpecify() {
        return this.httpMethodSpecify;
    }

    public SentinelWebMvcConfig setHttpMethodSpecify(boolean httpMethodSpecify) {
        this.httpMethodSpecify = httpMethodSpecify;
        return this;
    }

    public static boolean isMseHttpMethodSpecify() {
        return mseHttpMethodSpecify;
    }

    public boolean isWebContextUnify() {
        return this.webContextUnify;
    }

    public SentinelWebMvcConfig setWebContextUnify(boolean webContextUnify) {
        this.webContextUnify = webContextUnify;
        return this;
    }

    public boolean isContextPathSpecify() {
        return this.contextPathSpecify;
    }

    public SentinelWebMvcConfig setContextPathSpecify(boolean contextPathSpecify) {
        this.contextPathSpecify = contextPathSpecify;
        return this;
    }

    public String toString() {
        return "SentinelWebMvcConfig{urlCleaner=" + this.urlCleaner + ", httpMethodSpecify=" + this.httpMethodSpecify + ", webContextUnify=" + this.webContextUnify + ", contextPathSpecify=" + this.contextPathSpecify + ", requestAttributeName='" + this.requestAttributeName + '\'' + ", blockExceptionHandler=" + this.blockExceptionHandler + ", originParser=" + this.originParser + '}';
    }
}

