/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.sc.api.matcher;

import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPathPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.matcher.AbstractApiMatcher;
import com.alibaba.csp.sentinel.adapter.gateway.sc.route.RouteMatchers;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.Optional;
import org.springframework.web.server.ServerWebExchange;

public class WebExchangeApiMatcher
extends AbstractApiMatcher<ServerWebExchange> {
    public WebExchangeApiMatcher(ApiDefinition apiDefinition) {
        super(apiDefinition);
    }

    protected void initializeMatchers() {
        if (this.apiDefinition.getPredicateItems() != null) {
            this.apiDefinition.getPredicateItems().forEach(item -> this.fromApiPredicate((ApiPredicateItem)item).ifPresent(this.matchers::add));
        }
    }

    private Optional<Predicate<ServerWebExchange>> fromApiPredicate(ApiPredicateItem item) {
        if (item instanceof ApiPathPredicateItem) {
            return this.fromApiPathPredicate((ApiPathPredicateItem)item);
        }
        return Optional.empty();
    }

    private Optional<Predicate<ServerWebExchange>> fromApiPathPredicate(ApiPathPredicateItem item) {
        String pattern = item.getPattern();
        if (StringUtil.isBlank((String)pattern)) {
            return Optional.empty();
        }
        switch (item.getMatchStrategy()) {
            case 2: {
                return Optional.of(RouteMatchers.regexPath(pattern));
            }
            case 1: {
                return Optional.of(RouteMatchers.antPath(pattern));
            }
        }
        return Optional.of(RouteMatchers.exactPath(pattern));
    }
}

