/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.spi;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.Spi;
import com.alibaba.csp.sentinel.spi.SpiLoaderException;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SpiLoader<S> {
    private static final String SPI_FILE_PREFIX = "META-INF/services/";
    private static final ConcurrentHashMap<String, SpiLoader> SPI_LOADER_MAP = new ConcurrentHashMap();
    private final List<Class<? extends S>> classList = Collections.synchronizedList(new ArrayList());
    private final List<Class<? extends S>> sortedClassList = Collections.synchronizedList(new ArrayList());
    private final ConcurrentHashMap<String, Class<? extends S>> classMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, S> singletonMap = new ConcurrentHashMap();
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    private Class<? extends S> defaultClass = null;
    private Class<S> service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> SpiLoader<T> of(Class<T> service) {
        AssertUtil.notNull(service, "SPI class cannot be null");
        AssertUtil.isTrue(service.isInterface() || Modifier.isAbstract(service.getModifiers()), "SPI class[" + service.getName() + "] must be interface or abstract class");
        String className = service.getName();
        SpiLoader spiLoader = SPI_LOADER_MAP.get(className);
        if (spiLoader != null) return spiLoader;
        Class<SpiLoader> clazz = SpiLoader.class;
        synchronized (SpiLoader.class) {
            spiLoader = SPI_LOADER_MAP.get(className);
            if (spiLoader != null) return spiLoader;
            SPI_LOADER_MAP.putIfAbsent(className, new SpiLoader<T>(service));
            return SPI_LOADER_MAP.get(className);
        }
    }

    static synchronized void resetAndClearAll() {
        Set<Map.Entry<String, SpiLoader>> entries = SPI_LOADER_MAP.entrySet();
        for (Map.Entry<String, SpiLoader> entry : entries) {
            SpiLoader spiLoader = entry.getValue();
            spiLoader.resetAndClear();
        }
        SPI_LOADER_MAP.clear();
    }

    private SpiLoader(Class<S> service) {
        this.service = service;
    }

    public List<S> loadInstanceList() {
        this.load();
        return this.createInstanceList(this.classList);
    }

    public List<S> loadInstanceListSorted() {
        this.load();
        return this.createInstanceList(this.sortedClassList);
    }

    public S loadHighestPriorityInstance() {
        this.load();
        if (this.sortedClassList.size() == 0) {
            return null;
        }
        Class<? extends S> highestClass = this.sortedClassList.get(0);
        return this.createInstance(highestClass);
    }

    public S loadLowestPriorityInstance() {
        this.load();
        if (this.sortedClassList.size() == 0) {
            return null;
        }
        Class<? extends S> lowestClass = this.sortedClassList.get(this.sortedClassList.size() - 1);
        return this.createInstance(lowestClass);
    }

    public S loadFirstInstance() {
        this.load();
        if (this.classList.size() == 0) {
            return null;
        }
        Class<? extends S> serviceClass = this.classList.get(0);
        S instance = this.createInstance(serviceClass);
        return instance;
    }

    public S loadFirstInstanceOrDefault() {
        this.load();
        for (Class<? extends S> clazz : this.classList) {
            if (this.defaultClass != null && clazz == this.defaultClass) continue;
            return this.createInstance(clazz);
        }
        return this.loadDefaultInstance();
    }

    public S loadDefaultInstance() {
        this.load();
        if (this.defaultClass == null) {
            return null;
        }
        return this.createInstance(this.defaultClass);
    }

    public S loadInstance(Class<? extends S> clazz) {
        AssertUtil.notNull(clazz, "SPI class cannot be null");
        if (clazz.equals(this.service)) {
            this.fail(clazz.getName() + " is not subtype of " + this.service.getName());
        }
        this.load();
        if (!this.classMap.containsValue(clazz)) {
            this.fail(clazz.getName() + " is not Provider class of " + this.service.getName() + ",check if it is in the SPI configuration file?");
        }
        return this.createInstance(clazz);
    }

    public S loadInstance(String aliasName) {
        AssertUtil.notEmpty(aliasName, "aliasName cannot be empty");
        this.load();
        Class<? extends S> clazz = this.classMap.get(aliasName);
        if (clazz == null) {
            this.fail("no Provider class's aliasName is " + aliasName);
        }
        return this.createInstance(clazz);
    }

    synchronized void resetAndClear() {
        SPI_LOADER_MAP.remove(this.service.getName());
        this.classList.clear();
        this.sortedClassList.clear();
        this.classMap.clear();
        this.singletonMap.clear();
        this.defaultClass = null;
        this.loaded.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (!this.loaded.compareAndSet(false, true)) {
            return;
        }
        String fullFileName = SPI_FILE_PREFIX + this.service.getName();
        ClassLoader classLoader = SentinelConfig.shouldUseContextClassloader() ? Thread.currentThread().getContextClassLoader() : this.service.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(fullFileName);
        }
        catch (IOException e) {
            this.fail("Error locating SPI configuration file,filename=" + fullFileName + ",classloader=" + classLoader, e);
        }
        if (urls == null || !urls.hasMoreElements()) {
            RecordLog.warn("No SPI configuration file,filename=" + fullFileName + ",classloader=" + classLoader, new Object[0]);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream in = null;
            BufferedReader br = null;
            try {
                String line;
                in = url.openStream();
                br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                while ((line = br.readLine()) != null) {
                    String aliasName;
                    int commentIndex;
                    if (StringUtil.isBlank(line) || (commentIndex = (line = line.trim()).indexOf("#")) == 0) continue;
                    if (commentIndex > 0) {
                        line = line.substring(0, commentIndex);
                    }
                    line = line.trim();
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(line, false, classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        this.fail("class " + line + " not found", e);
                    }
                    if (this.classMap.containsValue(clazz)) {
                        RecordLog.warn("duplicate class found,className=" + clazz.getName() + ",SPI configuration file[" + url + "]", new Object[0]);
                        continue;
                    }
                    if (!this.service.isAssignableFrom(clazz)) {
                        this.fail("class " + clazz.getName() + "is not subtype of " + this.service.getName() + ",SPI configuration file[" + url + "]");
                    }
                    this.classList.add(clazz);
                    Spi spi = clazz.getAnnotation(Spi.class);
                    String string = aliasName = spi == null || "".equals(spi.value()) ? clazz.getName() : spi.value();
                    if (this.classMap.containsKey(aliasName)) {
                        Class<S> existClass = this.classMap.get(aliasName);
                        this.fail("Found repeat alias name for " + clazz.getName() + " and " + existClass.getName() + ",SPI configuration file[" + url + "]");
                    }
                    this.classMap.put(aliasName, clazz);
                    if (spi != null && spi.isDefault()) {
                        if (this.defaultClass != null) {
                            this.fail("Found more than one default Provider,className=" + clazz.getName() + ",SPI configuration file[" + url + "]");
                        }
                        this.defaultClass = clazz;
                    }
                    RecordLog.info("[SpiLoader] Found SPI implementation for SPI {}, provider={}, aliasName={}, isSingleton={}, isDefault={}, order={}", this.service.getName(), line, aliasName, spi == null ? true : spi.isSingleton(), spi == null ? false : spi.isDefault(), spi == null ? 0 : spi.order());
                }
            }
            catch (IOException e) {
                try {
                    this.fail("error reading SPI configuration file[" + url + "]", e);
                }
                catch (Throwable throwable) {
                    this.closeResources(in, br);
                    throw throwable;
                }
                this.closeResources(in, br);
                continue;
            }
            this.closeResources(in, br);
        }
        this.sortedClassList.addAll(this.classList);
        Collections.sort(this.sortedClassList, new Comparator<Class<? extends S>>(){

            @Override
            public int compare(Class<? extends S> o1, Class<? extends S> o2) {
                Spi spi1 = o1.getAnnotation(Spi.class);
                int order1 = spi1 == null ? 0 : spi1.order();
                Spi spi2 = o2.getAnnotation(Spi.class);
                int order2 = spi2 == null ? 0 : spi2.order();
                return Integer.compare(order1, order2);
            }
        });
    }

    public String toString() {
        return "com.alibaba.csp.sentinel.spi.SpiLoader[" + this.service.getName() + "]";
    }

    private List<S> createInstanceList(List<Class<? extends S>> clazzList) {
        if (clazzList == null || clazzList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<S> instances = new ArrayList<S>(clazzList.size());
        for (Class<S> clazz : clazzList) {
            S instance = this.createInstance(clazz);
            instances.add(instance);
        }
        return instances;
    }

    private S createInstance(Class<? extends S> clazz) {
        Spi spi = clazz.getAnnotation(Spi.class);
        boolean singleton = true;
        if (spi != null) {
            singleton = spi.isSingleton();
        }
        return this.createInstance(clazz, singleton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S createInstance(Class<? extends S> clazz, boolean singleton) {
        Object instance;
        block7: {
            instance = null;
            try {
                if (singleton) {
                    instance = this.singletonMap.get(clazz.getName());
                    if (instance != null) break block7;
                    SpiLoader spiLoader = this;
                    synchronized (spiLoader) {
                        instance = this.singletonMap.get(clazz.getName());
                        if (instance == null) {
                            instance = this.service.cast(clazz.newInstance());
                            this.singletonMap.put(clazz.getName(), instance);
                        }
                        break block7;
                    }
                }
                instance = this.service.cast(clazz.newInstance());
            }
            catch (Throwable e) {
                this.fail(clazz.getName() + " could not be instantiated");
            }
        }
        return (S)instance;
    }

    private void closeResources(Closeable ... closeables) {
        if (closeables == null || closeables.length == 0) {
            return;
        }
        Exception firstException = null;
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            this.fail("error closing resources", firstException);
        }
    }

    private void fail(String msg) {
        RecordLog.error(msg, new Object[0]);
        throw new SpiLoaderException("[" + this.service.getName() + "]" + msg);
    }

    private void fail(String msg, Throwable e) {
        RecordLog.error(msg, e);
        throw new SpiLoaderException("[" + this.service.getName() + "]" + msg, e);
    }
}

