/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log.jul;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.log.jul.CspFormatter;
import com.alibaba.csp.sentinel.log.jul.Level;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

class ConsoleHandler
extends Handler {
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 5, 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(1024), new NamedThreadFactory("sentinel-console-log-executor", true), new LogRejectedExecutionHandler());
    private StreamHandler stdoutHandler;
    private StreamHandler stderrHandler;
    private AtomicReference<Future<?>> lastFuture = new AtomicReference();

    public ConsoleHandler() {
        this.stdoutHandler = new StreamHandler(System.out, new CspFormatter());
        this.stderrHandler = new StreamHandler(System.err, new CspFormatter());
    }

    @Override
    public synchronized void setFormatter(Formatter newFormatter) throws SecurityException {
        this.stdoutHandler.setFormatter(newFormatter);
        this.stderrHandler.setFormatter(newFormatter);
    }

    @Override
    public synchronized void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        this.stdoutHandler.setEncoding(encoding);
        this.stderrHandler.setEncoding(encoding);
    }

    @Override
    public void publish(LogRecord record) {
        this.lastFuture.set(executor.submit(new LogTask(record, this.stdoutHandler, this.stderrHandler)));
    }

    @Override
    public void flush() {
        this.stdoutHandler.flush();
        this.stderrHandler.flush();
    }

    @Override
    public void close() throws SecurityException {
        Future<?> future = this.lastFuture.get();
        if (future != null) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        this.stdoutHandler.close();
        this.stderrHandler.close();
    }

    static {
        executor.allowCoreThreadTimeOut(true);
    }

    static class LogTask
    implements Runnable {
        private final LogRecord record;
        private final StreamHandler stdoutHandler;
        private final StreamHandler stderrHandler;

        public LogTask(LogRecord record, StreamHandler stdoutHandler, StreamHandler stderrHandler) {
            this.record = record;
            this.stdoutHandler = stdoutHandler;
            this.stderrHandler = stderrHandler;
        }

        @Override
        public void run() {
            if (this.record.getLevel().intValue() >= Level.WARNING.intValue()) {
                this.stderrHandler.publish(this.record);
                this.stderrHandler.flush();
            } else {
                this.stdoutHandler.publish(this.record);
                this.stdoutHandler.flush();
            }
        }

        public LogRecord getRecord() {
            return this.record;
        }
    }

    static class LogRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final long recordPeriod;
        private Long lastRecordTime;

        public LogRejectedExecutionHandler() {
            String DEFAULT_REJECTED_RECORD_PERIOD = "60000";
            String REJECTED_RECORD_PERIOD_KEY = "sentinel.rejected.record.period";
            this.lastRecordTime = null;
            this.recordPeriod = Long.parseLong(System.getProperty(REJECTED_RECORD_PERIOD_KEY, DEFAULT_REJECTED_RECORD_PERIOD));
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            long currentTimestamp = System.currentTimeMillis();
            if (this.lastRecordTime == null || currentTimestamp - this.lastRecordTime > this.recordPeriod) {
                System.err.println("Failed to log sentinel record with console, rejected");
                this.lastRecordTime = currentTimestamp;
            }
        }
    }
}

