/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log;

import com.alibaba.csp.sentinel.log.LogConfigLoader;
import com.alibaba.csp.sentinel.util.ConfigUtil;
import java.io.File;
import java.util.Properties;

public class LogBase {
    public static final String LOG_DIR = "csp.sentinel.log.dir";
    public static final String LOG_NAME_USE_PID = "csp.sentinel.log.use.pid";
    public static final String LOG_OUTPUT_TYPE = "csp.sentinel.log.output.type";
    public static final String LOG_CHARSET = "csp.sentinel.log.charset";
    public static final String LOG_OUTPUT_TYPE_FILE = "file";
    public static final String LOG_OUTPUT_TYPE_CONSOLE = "console";
    public static final String LOG_CHARSET_UTF8 = "utf-8";
    private static final String DIR_NAME = "logs" + File.separator + "csp";
    private static final String USER_HOME = "user.home";
    private static boolean logNameUsePid;
    private static String logOutputType;
    private static String logBaseDir;
    private static String logCharSet;

    private static void initializeDefault() {
        logNameUsePid = false;
        logOutputType = LOG_OUTPUT_TYPE_FILE;
        logBaseDir = ConfigUtil.addSeparator(System.getProperty(USER_HOME)) + DIR_NAME + File.separator;
        logCharSet = LOG_CHARSET_UTF8;
    }

    private static void loadProperties() {
        Properties properties = LogConfigLoader.getProperties();
        String string = logOutputType = properties.get(LOG_OUTPUT_TYPE) == null ? logOutputType : properties.getProperty(LOG_OUTPUT_TYPE);
        if (!LOG_OUTPUT_TYPE_FILE.equalsIgnoreCase(logOutputType) && !LOG_OUTPUT_TYPE_CONSOLE.equalsIgnoreCase(logOutputType)) {
            logOutputType = LOG_OUTPUT_TYPE_FILE;
        }
        System.out.println("INFO: Sentinel log output type is: " + logOutputType);
        logCharSet = properties.getProperty(LOG_CHARSET) == null ? logCharSet : properties.getProperty(LOG_CHARSET);
        System.out.println("INFO: Sentinel log charset is: " + logCharSet);
        logBaseDir = properties.getProperty(LOG_DIR) == null ? logBaseDir : properties.getProperty(LOG_DIR);
        logBaseDir = ConfigUtil.addSeparator(logBaseDir);
        File dir = new File(logBaseDir);
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("ERROR: create Sentinel log base directory error: " + logBaseDir);
        }
        System.out.println("INFO: Sentinel log base directory is: " + logBaseDir);
        String usePid = properties.getProperty(LOG_NAME_USE_PID);
        logNameUsePid = "true".equalsIgnoreCase(usePid);
        System.out.println("INFO: Sentinel log name use pid is: " + logNameUsePid);
    }

    public static boolean isLogNameUsePid() {
        return logNameUsePid;
    }

    public static String getLogBaseDir() {
        return logBaseDir;
    }

    public static String getLogOutputType() {
        return logOutputType;
    }

    public static String getLogCharset() {
        return logCharSet;
    }

    static {
        try {
            LogBase.initializeDefault();
            LogBase.loadProperties();
        }
        catch (Throwable t) {
            System.err.println("[LogBase] FATAL ERROR when initializing logging config");
            t.printStackTrace();
        }
    }
}

