/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log;

import com.alibaba.csp.sentinel.util.ConfigUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;

public class LogConfigLoader {
    public static final String LOG_CONFIG = "csp.sentinel.config.file";
    private static final String DEFAULT_LOG_CONFIG_FILE = "classpath:sentinel.properties";
    private static final Properties properties = new Properties();

    private static void load() {
        Properties p;
        String file = System.getProperty(LOG_CONFIG);
        if (StringUtil.isBlank(file)) {
            file = DEFAULT_LOG_CONFIG_FILE;
        }
        if ((p = ConfigUtil.loadProperties(file)) != null && !p.isEmpty()) {
            properties.putAll((Map<?, ?>)p);
        }
        CopyOnWriteArraySet<Map.Entry<Object, Object>> copy = new CopyOnWriteArraySet<Map.Entry<Object, Object>>(System.getProperties().entrySet());
        for (Map.Entry<Object, Object> entry : copy) {
            String configKey = entry.getKey().toString();
            String newConfigValue = entry.getValue().toString();
            properties.put(configKey, newConfigValue);
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    static {
        LogConfigLoader.load();
    }
}

