/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.connection;

import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.connection.Connection;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionPool;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.List;

public class ScanIdleConnectionTask
implements Runnable {
    private final ConnectionPool connectionPool;

    public ScanIdleConnectionTask(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    @Override
    public void run() {
        try {
            int idleSeconds = ClusterServerConfigManager.getIdleSeconds();
            long idleTimeMillis = idleSeconds * 1000;
            if (idleTimeMillis < 0L) {
                idleTimeMillis = 600000L;
            }
            long now = System.currentTimeMillis();
            List<Connection> connections = this.connectionPool.listAllConnection();
            for (Connection conn : connections) {
                if (now - conn.getLastReadTime() <= idleTimeMillis) continue;
                RecordLog.info((String)"[ScanIdleConnectionTask] The connection <{}:{}> has been idle for <{}>s. It will be closed now.", (Object[])new Object[]{conn.getRemoteIP(), conn.getRemotePort(), idleSeconds});
                conn.close();
            }
        }
        catch (Throwable t) {
            RecordLog.warn((String)"[ScanIdleConnectionTask] Failed to clean-up idle tasks", (Throwable)t);
        }
    }
}

