/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.command.handler;

import com.alibaba.csp.sentinel.cluster.flow.statistic.limit.GlobalRequestLimiter;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionGroup;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Set;

@CommandMapping(name="cluster/server/info", desc="get cluster server info")
public class FetchClusterServerInfoCommandHandler
implements CommandHandler<String> {
    public CommandResponse<String> handle(CommandRequest request) {
        JSONObject info = new JSONObject();
        JSONArray connectionGroups = new JSONArray();
        Set<String> namespaceSet = ClusterServerConfigManager.getNamespaceSet();
        for (String namespace : namespaceSet) {
            ConnectionGroup group = ConnectionManager.getOrCreateConnectionGroup(namespace);
            if (group == null) continue;
            connectionGroups.add((Object)group);
        }
        ServerTransportConfig transportConfig = new ServerTransportConfig().setPort(ClusterServerConfigManager.getPort()).setIdleSeconds(ClusterServerConfigManager.getIdleSeconds());
        ServerFlowConfig flowConfig = new ServerFlowConfig().setExceedCount(ClusterServerConfigManager.getExceedCount()).setMaxOccupyRatio(ClusterServerConfigManager.getMaxOccupyRatio()).setIntervalMs(ClusterServerConfigManager.getIntervalMs()).setSampleCount(ClusterServerConfigManager.getSampleCount()).setMaxAllowedQps(ClusterServerConfigManager.getMaxAllowedQps());
        JSONArray requestLimitData = this.buildRequestLimitData(namespaceSet);
        info.fluentPut("port", (Object)ClusterServerConfigManager.getPort()).fluentPut("connection", (Object)connectionGroups).fluentPut("requestLimitData", (Object)requestLimitData).fluentPut("transport", (Object)transportConfig).fluentPut("flow", (Object)flowConfig).fluentPut("namespaceSet", namespaceSet).fluentPut("embedded", (Object)ClusterServerConfigManager.isEmbedded());
        info.put("appName", (Object)AppNameUtil.getAppName());
        return CommandResponse.ofSuccess((Object)info.toJSONString());
    }

    private JSONArray buildRequestLimitData(Set<String> namespaceSet) {
        JSONArray array = new JSONArray();
        for (String namespace : namespaceSet) {
            array.add((Object)new JSONObject().fluentPut("namespace", (Object)namespace).fluentPut("currentQps", (Object)GlobalRequestLimiter.getCurrentQps(namespace)).fluentPut("maxAllowedQps", (Object)GlobalRequestLimiter.getMaxAllowedQps(namespace)));
        }
        return array;
    }
}

