/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.command.handler;

import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import java.net.URLDecoder;

@CommandMapping(name="cluster/server/modifyFlowConfig", desc="modify cluster server flow config")
public class ModifyClusterServerFlowConfigHandler
implements CommandHandler<String> {
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank((String)data)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("empty data"));
        }
        String namespace = request.getParam("namespace");
        try {
            data = URLDecoder.decode(data, "utf-8");
            if (StringUtil.isEmpty((String)namespace)) {
                RecordLog.info((String)("[ModifyClusterServerFlowConfigHandler] Receiving cluster server global flow config: " + data), (Object[])new Object[0]);
                ServerFlowConfig config = (ServerFlowConfig)JSON.parseObject((String)data, ServerFlowConfig.class);
                if (!ClusterServerConfigManager.isValidFlowConfig(config)) {
                    CommandResponse.ofFailure((Throwable)new IllegalArgumentException("Bad flow config"));
                }
                ClusterServerConfigManager.loadGlobalFlowConfig(config);
            } else {
                RecordLog.info((String)"[ModifyClusterServerFlowConfigHandler] Receiving cluster server flow config for namespace <{}>: {}", (Object[])new Object[]{namespace, data});
                ServerFlowConfig config = (ServerFlowConfig)JSON.parseObject((String)data, ServerFlowConfig.class);
                if (!ClusterServerConfigManager.isValidFlowConfig(config)) {
                    CommandResponse.ofFailure((Throwable)new IllegalArgumentException("Bad flow config"));
                }
                ClusterServerConfigManager.loadFlowConfig(namespace, config);
            }
            return CommandResponse.ofSuccess((Object)"success");
        }
        catch (Exception e) {
            RecordLog.warn((String)"[ModifyClusterServerFlowConfigHandler] Decode cluster server flow config error", (Throwable)e);
            return CommandResponse.ofFailure((Throwable)e, (Object)"decode cluster server flow config error");
        }
    }
}

